/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.x.Intersectable;
import gishur.x.Intersection;
import gishur.x.IntersectionException;
import gishur.x.XBaseline;
import gishur.x.XPoint;

public class XLine
extends XBaseline
implements Intersectable,
Cloneable {
    public void set(XPoint xPoint, double d) {
        if (xPoint == null) {
            return;
        }
        this._source = new XPoint(xPoint);
        if (Math.abs(d) < 1.0) {
            this._target = new XPoint(xPoint.x + 1.0, xPoint.y + d);
            return;
        }
        if (d > 0.0) {
            this._target = new XPoint(xPoint.x + 1.0 / d, xPoint.y + 1.0);
            return;
        }
        this._target = new XPoint(xPoint.x - 1.0 / d, xPoint.y - 1.0);
    }

    public String toString(boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            string = string + ",slope=" + this.slope();
        }
        if (bl2) {
            string = string + ",(0," + this.y_abs() + ")";
        }
        return string.substring(1);
    }

    public XLine() {
        this._source = new XPoint();
        this._target = new XPoint();
    }

    public XLine(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public XLine(XPoint xPoint, XPoint xPoint2) {
        this.set(xPoint.x, xPoint.y, xPoint2.x, xPoint2.y);
    }

    public XLine(XPoint xPoint, double d) {
        this.set(xPoint, d);
    }

    public XLine(XLine xLine) {
        this.copy(xLine);
    }

    public XLine(XBaseline xBaseline, XBaseline xBaseline2) {
        if (xBaseline.parallel(xBaseline2)) {
            XLine xLine = new XLine(xBaseline2.source(), xBaseline2.target());
            XPoint xPoint = xLine.plumb(xBaseline.source());
            XPoint xPoint2 = xLine.plumb(xBaseline.target());
            this._source = new XPoint(xBaseline.source(), xPoint);
            this._target = new XPoint(xBaseline.target(), xPoint2);
            return;
        }
        XPoint xPoint = xBaseline.getDirectionVector();
        XPoint xPoint3 = xBaseline2.getDirectionVector();
        xPoint.normalize();
        xPoint3.normalize();
        XPoint xPoint4 = (XPoint)xBaseline.baseIntersection(xBaseline2);
        xPoint.translate(xPoint4.x, xPoint4.y);
        xPoint3.translate(xPoint4.x, xPoint4.y);
        this._source = xPoint4;
        this._target = new XPoint(xPoint, xPoint3);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toString(true, true) + "]";
    }

    public boolean supportsIntersection(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XPoint) {
            return true;
        }
        return object instanceof XLine;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XLine) {
            return this.slope() == ((XBaseline)object).slope() && this.y_abs() == ((XBaseline)object).y_abs();
        }
        return false;
    }

    public void copy(XLine xLine) {
        if (xLine == null) {
            return;
        }
        this._source = new XPoint(xLine._source);
        this._target = new XPoint(xLine._target);
    }

    public Intersection intersection(Object object) {
        if (this.supportsIntersection(object)) {
            if (object instanceof XPoint) {
                if (this.liesOn((XPoint)object)) {
                    return new Intersection(((XPoint)object).clone());
                }
                return new Intersection();
            }
            if (object instanceof XLine) {
                Object object2 = super.baseIntersection((XBaseline)object);
                if (object2 == this) {
                    return new Intersection(new XLine(this));
                }
                return new Intersection(object2);
            }
        } else {
            if (object instanceof Intersectable && ((Intersectable)object).supportsIntersection(this)) {
                return ((Intersectable)object).intersection(this);
            }
            throw new IntersectionException(this, this, object);
        }
        throw new IntersectionException(this, this, object);
    }
}

