/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.Comparitor;
import gishur.core.SimpleList;
import gishur.x.Area;
import gishur.x.AreaIntersectable;
import gishur.x.Intersectable;
import gishur.x.Intersection;
import gishur.x.IntersectionException;
import gishur.x.PointComparitor;
import gishur.x.XBaseline;
import gishur.x.XHalfplane;
import gishur.x.XLine;
import gishur.x.XObject;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XPolyline;
import gishur.x.XRay;
import gishur.x.XSegment;

public class XUPolygon
extends XPolyline
implements AreaIntersectable {
    public static final byte ORIENTATION_LEFT = 1;
    public static final byte ORIENTATION_RIGHT = 2;
    private double _slope_in = 0.0;
    private double _slope_out = 0.0;
    private byte _dir_in = 1;
    private byte _dir_out = (byte)2;
    private byte _orientation = 1;

    public void setOrientation(byte by) {
        this._orientation = by;
    }

    private Area intersection_area(XHalfplane xHalfplane) {
        XObject xObject;
        SimpleList simpleList = new SimpleList();
        byte by = xHalfplane.orientation();
        XBaseline xBaseline = this.inRay();
        XPoint xPoint = null;
        Intersection intersection = xHalfplane.intersection(xBaseline);
        byte by2 = intersection.empty() ? xHalfplane.orientation(xBaseline.source()) : (intersection.xpoint() == null ? by : XPoint.opposite(xHalfplane.orientation(xBaseline.source())));
        int n = -1;
        while (n < this._points.length) {
            if (n >= 0 && n < this._points.length - 1) {
                xBaseline = this.segment(n);
            }
            if (n >= this._points.length - 1) {
                xBaseline = this.outRay();
            }
            if ((intersection = xHalfplane.intersection(xBaseline)).xpoint() == null || xPoint != null && xPoint.equals(intersection.xpoint())) {
                if (by2 == by) {
                    simpleList.push((Object)xBaseline);
                }
            } else {
                if (by2 == by) {
                    if (xBaseline instanceof XRay) {
                        if (n < 0) {
                            simpleList.push((Object)new XRay(intersection.xpoint(), xBaseline.slope(), ((XRay)xBaseline).direction()));
                        } else {
                            simpleList.push((Object)new XSegment(xBaseline.source(), intersection.xpoint()));
                        }
                    }
                    if (xBaseline instanceof XSegment) {
                        simpleList.push((Object)new XSegment(xBaseline.source(), intersection.xpoint()));
                    }
                } else {
                    if (xPoint == null) {
                        xObject = xHalfplane.source();
                        if (intersection.xpoint().equals(xObject)) {
                            xObject = xHalfplane.target();
                        }
                        XRay xRay = new XRay(intersection.xpoint(), (XPoint)xObject);
                        if (n >= 0) {
                            if (xBaseline.orientation((XPoint)xObject) == this._orientation) {
                                simpleList.push((Object)xRay);
                            } else {
                                simpleList.push((Object)new XRay(intersection.xpoint(), xRay.slope(), XBaseline.oppositeDirection(xRay.direction())));
                            }
                        } else if (XPoint.opposite(xBaseline.orientation((XPoint)xObject)) == this._orientation) {
                            simpleList.push((Object)xRay);
                        } else {
                            simpleList.push((Object)new XRay(intersection.xpoint(), xRay.slope(), XBaseline.oppositeDirection(xRay.direction())));
                        }
                    } else {
                        simpleList.push((Object)new XSegment(xPoint, intersection.xpoint()));
                    }
                    if (xBaseline instanceof XSegment) {
                        simpleList.push((Object)new XSegment(intersection.xpoint(), xBaseline.target()));
                    }
                    if (xBaseline instanceof XRay) {
                        if (n < 0) {
                            simpleList.push((Object)new XSegment(intersection.xpoint(), xBaseline.source()));
                        } else {
                            simpleList.push((Object)new XRay(intersection.xpoint(), xBaseline.slope(), ((XRay)xBaseline).direction()));
                        }
                    }
                }
                xPoint = intersection.xpoint();
                by2 = XPoint.opposite(by2);
            }
            ++n;
        }
        if (by2 != by && xPoint != null) {
            xBaseline = (XBaseline)simpleList.lastValue();
            XPoint xPoint2 = xHalfplane.source();
            if (xPoint.equals(xPoint2)) {
                xPoint2 = xHalfplane.target();
            }
            xObject = new XRay(xPoint, xPoint2);
            byte by3 = xBaseline.orientation(xPoint2);
            if (xBaseline instanceof XRay && simpleList.length() == 1) {
                by3 = XPoint.opposite(by3);
            }
            if (by3 == this._orientation) {
                simpleList.push((Object)xObject);
            } else {
                simpleList.push((Object)new XRay(xPoint, ((XBaseline)xObject).slope(), XBaseline.oppositeDirection(((XBaseline)xObject).direction())));
            }
        }
        if (simpleList.empty()) {
            return new Area();
        }
        return new Area(new XUPolygon(simpleList));
    }

    public XRay inRay() {
        if (this._points.length < 1) {
            return null;
        }
        return new XRay(this._points[0], this._slope_in, this._dir_in);
    }

    public XLine line(int n) {
        if (this._points.length < 1) {
            return null;
        }
        if (n < 0) {
            return new XLine(this._points[0], this._slope_in);
        }
        if (n >= this._points.length - 1) {
            return new XLine(this._points[this._points.length - 1], this._slope_out);
        }
        return new XLine(this._points[n], this._points[n + 1]);
    }

    public void set(SimpleList simpleList) {
        XRay xRay;
        super.set(simpleList);
        if (simpleList.firstValue() instanceof XRay) {
            xRay = (XRay)simpleList.firstValue();
            this._slope_in = xRay.slope();
            this._dir_in = xRay.direction();
        }
        if (simpleList.lastValue() instanceof XRay) {
            xRay = (XRay)simpleList.lastValue();
            this._slope_out = xRay.slope();
            this._dir_out = xRay.direction();
        }
    }

    public boolean isHalfplane() {
        if (this._points.length != 1) {
            return false;
        }
        return this._orientation == XPoint.opposite(this._orientation) && this._slope_in == this._slope_out;
    }

    public String toString(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string = this.toString(bl, bl2);
        if (!string.equals("")) {
            string = "," + string;
        }
        if (bl3) {
            string = string + ",inray=[" + this.inRay().toString(false, true, true) + "]";
        }
        if (bl4) {
            string = string + ",outray=[" + this.outRay().toString(false, true, true) + "]";
        }
        if (bl5) {
            switch (this._orientation) {
                case 1: {
                    string = string + ",orientation=left";
                    break;
                }
                case 2: {
                    string = string + ",orientation=right";
                    break;
                }
                case 3: {
                    string = string + ",orientation=line";
                    break;
                }
                default: {
                    string = string + ",no orientation";
                }
            }
        }
        return string.substring(1);
    }

    public XUPolygon() {
        this.clear();
    }

    public XUPolygon(XPoint[] xPointArray) {
        this.set(xPointArray);
    }

    public XUPolygon(SimpleList simpleList) {
        this.set(simpleList);
    }

    public XUPolygon(XUPolygon xUPolygon) {
        this.copy(xUPolygon);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toString(true, true, true, true, true);
    }

    public boolean in(XPoint xPoint) {
        return this.locate(xPoint) == 1;
    }

    public boolean contains(double d, double d2) {
        return this.liesOn(new XPoint(d, d2)) >= -1;
    }

    public boolean supportsIntersection(AreaIntersectable areaIntersectable, boolean bl) {
        if (areaIntersectable == null) {
            return false;
        }
        boolean bl2 = this.convex();
        return areaIntersectable instanceof XHalfplane && bl2;
    }

    public void setInRay(XRay xRay) {
        this._slope_in = xRay.slope();
        this._dir_in = xRay.direction();
    }

    public boolean supportsIntersection(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XPoint) {
            return true;
        }
        if (object instanceof XLine) {
            return true;
        }
        if (object instanceof XRay) {
            return true;
        }
        if (object instanceof XSegment) {
            return true;
        }
        if (object instanceof XPolygon) {
            return true;
        }
        if (object instanceof XUPolygon) {
            return true;
        }
        return object instanceof XPolyline;
    }

    public byte locate(XPoint xPoint) {
        PointComparitor pointComparitor;
        if (this._points.length < 1) {
            return 3;
        }
        if (this.liesOn(xPoint) >= 0) {
            return 2;
        }
        XRay xRay = new XRay(xPoint, this._points[0]);
        SimpleList simpleList = this.intersection_impl(xRay);
        XPoint xPoint2 = (XPoint)simpleList.min((Comparitor)(pointComparitor = new PointComparitor(4, xPoint))).value();
        int n = this.liesOn(xPoint2);
        byte by = n < this._points.length - 1 ? this.segment(n).orientation(xPoint) : this.outRay().orientation(xPoint);
        byte by2 = xPoint2.equals(this._points[n]) ? (n > 0 ? this.segment(n - 1).orientation(xPoint) : XPoint.opposite(this.inRay().orientation(xPoint))) : by;
        if (by != by2) {
            XBaseline xBaseline = n < this._points.length - 1 ? this.segment(n) : this.outRay();
            byte by3 = n > 0 ? this.segment(n - 1).orientation(xBaseline.target()) : XPoint.opposite(this.inRay().orientation(xBaseline.target()));
            if (by == by3) {
                by = by2;
            }
        }
        if (by == this._orientation) {
            return 1;
        }
        return 3;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public void copy(XUPolygon xUPolygon) {
        super.copy(xUPolygon);
        this._slope_in = xUPolygon._slope_in;
        this._slope_out = xUPolygon._slope_out;
        this._dir_in = xUPolygon._dir_in;
        this._dir_out = xUPolygon._dir_out;
        this._orientation = xUPolygon._orientation;
    }

    public int findBorderIndex(int n, boolean bl) {
        if (n < 0 || n >= this._points.length) {
            return -1;
        }
        if (bl) {
            return n + 1;
        }
        return n;
    }

    public int countBorderSegments() {
        return this._points.length + 1;
    }

    public Area intersection(AreaIntersectable areaIntersectable, boolean bl) {
        if (areaIntersectable instanceof XHalfplane) {
            XPolygon xPolygon = ((XHalfplane)areaIntersectable).getInfiniteXPolygon();
            Area area = new Area(this.getInfiniteXPolygon().convexPolygonIntersection(xPolygon));
            area.setConvexMode((byte)2);
            return area;
        }
        throw new IntersectionException(this, areaIntersectable);
    }

    public XRay outRay() {
        if (this._points.length < 1) {
            return null;
        }
        return new XRay(this._points[this._points.length - 1], this._slope_out, this._dir_out);
    }

    public void setOutRay(XRay xRay) {
        this._slope_out = xRay.slope();
        this._dir_out = xRay.direction();
    }

    public XPolygon getInfiniteXPolygon() {
        XSegment xSegment = this.inRay().getInfiniteSegment();
        XSegment xSegment2 = this.outRay().getInfiniteSegment();
        XPoint[] xPointArray = new XPoint[this._points.length + 6];
        if (this._orientation == 1) {
            XBaseline.copyInfiniteChain(xSegment2.target(), xSegment.target(), xPointArray, this._points.length);
            try {
                System.arraycopy(this._points, 0, xPointArray, 0, this._points.length);
            }
            catch (Exception exception) {}
        } else {
            XBaseline.copyInfiniteChain(xSegment.target(), xSegment2.target(), xPointArray, this._points.length);
            int n = 0;
            while (n < this._points.length) {
                xPointArray[n] = this._points[this._points.length - n - 1];
                ++n;
            }
        }
        return new XPolygon(xPointArray);
    }

    public Intersection intersection(Object object) {
        if (this.supportsIntersection(object)) {
            if (object instanceof XPoint) {
                if (this.liesOn((XPoint)object) >= 0) {
                    return new Intersection(((XPoint)object).clone());
                }
                return new Intersection();
            }
            if (object instanceof XBaseline) {
                return new Intersection(this.intersection_impl((XBaseline)object));
            }
            if (object instanceof XPolyline) {
                return new Intersection(this.intersection_impl((XPolyline)object));
            }
        } else {
            if (object instanceof Intersectable && ((Intersectable)object).supportsIntersection(this)) {
                return ((Intersectable)object).intersection(this);
            }
            throw new IntersectionException(this, this, object);
        }
        throw new IntersectionException(this, this, object);
    }

    public Object clone() {
        XUPolygon xUPolygon = new XUPolygon(this);
        int n = 0;
        while (n < this._points.length) {
            xUPolygon._points[n] = (XPoint)this._points[n].clone();
            ++n;
        }
        return xUPolygon;
    }

    public XSegment borderSegment(int n) {
        if (n < 0 || n > this._points.length) {
            return null;
        }
        if (n > 0 && n < this._points.length) {
            return this.segment(n - 1);
        }
        if (n == 0) {
            XSegment xSegment = this.inRay().getInfiniteSegment();
            xSegment.flip();
            return xSegment;
        }
        return this.outRay().getInfiniteSegment();
    }

    public boolean isAngle() {
        return this._points.length == 1;
    }

    public byte orientation() {
        return this._orientation;
    }
}

