/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.Comparitor;
import gishur.core.ListItem;
import gishur.core.SimpleList;
import gishur.x.Intersection;
import gishur.x.PointComparitor;
import gishur.x.XBaseline;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XRay;
import gishur.x.XSegment;

public class visPolygon {
    private XPolygon _polygon = null;
    private SimpleList _todo = null;
    private SimpleList _done = null;
    private XSegment _akt;
    private XSegment _next;
    private XPoint _p = null;
    private XPoint _r0 = null;
    private XPoint _r = null;
    private XPoint _rl = null;
    private byte _vis = 0;
    private byte _lvis = 0;
    private boolean _cutOnr0 = false;
    private static final byte _VISIBLE = 0;
    private static final byte _UNVISIBLE = 1;
    private static final byte _START_COVERED = 3;
    private static final byte _END_COVERED = 4;
    private static final byte _STARTEND_COVERED = 5;
    private static final byte _IN_LINE_VISIBLE = 6;
    private static final byte _IN_LINE_UNVISIBLE = 7;
    private static final byte _ENTER_SHADOW = 8;
    private static final byte _ON_LINE = 9;

    private String getStringForVis(byte by) {
        String string = null;
        switch (by) {
            case 0: {
                string = "Segment visible";
                break;
            }
            case 1: {
                string = "Segment unvisible";
                break;
            }
            case 3: {
                string = "Start covered";
                break;
            }
            case 4: {
                string = "End covered";
                break;
            }
            case 5: {
                string = "Start & end covered";
                break;
            }
            case 6: 
            case 7: {
                string = "Segment in line with p";
                break;
            }
            case 9: {
                string = "p lies on Segment";
                break;
            }
            case 8: {
                string = "Enter Shadow";
            }
        }
        return string;
    }

    private void checkVisibility() {
        if (this._akt == null || this._r == null || this._rl == null) {
            return;
        }
        this._lvis = this._vis;
        this._vis = 0;
        if (this._p.orientation(this._rl, this._r) == 2) {
            this._vis = 1;
        }
        if (this._p.orientation(this._rl, this._r) == 3) {
            this._vis = this._akt.liesOn(this._p) ? (byte)9 : (this._lvis == 7 || this._lvis == 1 ? (byte)7 : (byte)6);
        }
        if (this._vis == 0 && !this._done.empty()) {
            new XSegment(this._p, this._rl);
            new XSegment(this._p, this._r);
            XSegment xSegment = (XSegment)this._done.lastValue();
            XSegment xSegment2 = (XSegment)this._done.firstValue();
            if (this.triaCheck(this._p, this._rl, this._r, xSegment.target())) {
                this._vis = (byte)3;
            }
            if (this.triaCheck(this._p, this._rl, this._r, xSegment2.source()) && xSegment2.target().orientation(this._p, this._r) == 1) {
                if (this._vis == 3) {
                    this._vis = (byte)5;
                    return;
                }
                this._vis = (byte)4;
            }
        }
    }

    private boolean triaCheck(XPoint xPoint, XPoint xPoint2, XPoint xPoint3, XPoint xPoint4) {
        return xPoint4.orientation(xPoint, xPoint2) == 1 && xPoint4.orientation(xPoint2, xPoint3) == 1 && xPoint4.orientation(xPoint3, xPoint) == 1;
    }

    private XPoint getFirstBorderPoint() {
        XRay xRay = new XRay((XPoint)this._p.clone(), 0.0, 2);
        Intersection intersection = this._polygon.intersection(xRay);
        if (intersection.empty()) {
            return null;
        }
        if (intersection.singleCutPoint()) {
            return intersection.xpoint();
        }
        SimpleList simpleList = new SimpleList();
        int n = 0;
        while (n < intersection.length()) {
            if (intersection.xpoint(n) != null) {
                simpleList.add((Object)intersection.xpoint(n));
            }
            if (intersection.xsegment(n) != null) {
                XSegment xSegment = intersection.xsegment(n);
                simpleList.add((Object)xSegment.source());
                simpleList.add((Object)xSegment.target());
            }
            ++n;
        }
        PointComparitor pointComparitor = new PointComparitor();
        pointComparitor.setOrder((byte)1);
        boolean bl = true;
        int n2 = -1;
        ListItem listItem = null;
        while (!simpleList.empty() && bl) {
            bl = false;
            listItem = simpleList.max((Comparitor)pointComparitor);
            n2 = this._polygon.indexOf((XPoint)listItem.key());
            if (n2 <= 0 || this._p.orientation(this._polygon.point(n2), this._polygon.point((n2 + 1) % this._polygon.length())) == 1) continue;
            simpleList.remove(listItem);
            bl = true;
        }
        if (listItem != null && !bl) {
            return (XPoint)listItem.key();
        }
        return null;
    }

    private void trimAkt() {
        if (this._vis == 5 || this._vis == 3 || this._vis == 4) {
            Intersection intersection;
            XPoint xPoint = ((XSegment)this._done.lastValue()).target();
            XPoint xPoint2 = ((XSegment)this._done.firstValue()).source();
            XRay xRay = null;
            if (!(this._vis != 3 && this._vis != 5 || (intersection = this._akt.intersection(xRay = new XRay(this._p, xPoint))).xpoint() == null || intersection.xpoint().equals(this._akt.target()))) {
                this._akt = new XSegment(intersection.xpoint(), this._akt.target());
            }
            if (!(this._vis != 4 && this._vis != 5 || (intersection = this._akt.intersection(xRay = new XRay(this._p, xPoint2))).xpoint() == null || intersection.xpoint().equals(this._akt.source()))) {
                this._akt = new XSegment(this._akt.source(), intersection.xpoint());
            }
        }
    }

    visPolygon(XPolygon xPolygon) {
        this._polygon = xPolygon;
        this._todo = new SimpleList();
        this._done = new SimpleList();
    }

    private void updateDone() {
        switch (this._vis) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                if (this._akt.source().equals(this._akt.target())) break;
                this._done.push((Object)this._akt);
                return;
            }
            case 1: {
                this.shadow();
                return;
            }
        }
    }

    private boolean testRightTurnOutside() {
        if (this._next == null || this._vis == 7 || this._vis == 1) {
            return false;
        }
        XPoint xPoint = this._next.target();
        boolean bl = this._rl.orientation(this._p, this._r) != 1 && xPoint.orientation(this._p, this._r) == 2;
        bl = bl && this._p.orientation(this._rl, this._r) != 2 && xPoint.orientation(this._rl, this._r) == 2;
        return bl;
    }

    private boolean testLeftTurnOutside() {
        if (this._vis == 9 || this._vis == 8 || this._vis == 0 || this._vis == 6 || this._next == null) {
            return false;
        }
        XPoint xPoint = this._next.target();
        boolean bl = this._rl.orientation(this._p, this._r) != 2 && xPoint.orientation(this._p, this._r) == 1;
        bl = bl && this._p.orientation(this._rl, this._r) != 1 && xPoint.orientation(this._rl, this._r) == 1;
        return bl;
    }

    private void shadow() {
        boolean bl = false;
        boolean bl2 = false;
        XRay xRay = new XRay(this._p, this._r);
        XBaseline xBaseline = null;
        XBaseline xBaseline2 = null;
        Intersection intersection = new Intersection();
        while (!(this._done.empty() || bl || bl2)) {
            xBaseline2 = xBaseline;
            xBaseline = (XSegment)this._done.pop();
            if (xBaseline2 != null && !xBaseline.target().equals(xBaseline2.source())) {
                XSegment xSegment = new XSegment(xBaseline.target(), xBaseline2.source());
                this._done.push((Object)xBaseline);
                xBaseline = xSegment;
                intersection = ((XSegment)xBaseline).intersection(this._akt);
                bl2 = intersection.xpoint() != null;
                continue;
            }
            intersection = ((XSegment)xBaseline).intersection(xRay);
            boolean bl3 = bl = intersection.xpoint() != null;
        }
        if (bl && !intersection.xpoint().equals(xBaseline.source())) {
            this._done.push((Object)new XSegment(xBaseline.source(), intersection.xpoint()));
        }
        if (bl2) {
            this._todo.push((Object)this._akt);
            this._vis = (byte)8;
        }
    }

    private void initializeToDo() {
        this._cutOnr0 = false;
        if (this._polygon == null || this._r0 == null) {
            return;
        }
        this._todo.clear();
        this._done.clear();
        XSegment xSegment = null;
        int n = 0;
        ListItem listItem = null;
        XPoint xPoint = this._polygon.point(this._polygon.length() - 1);
        while (n < this._polygon.length()) {
            xSegment = new XSegment(xPoint, this._polygon.point(n));
            ListItem listItem2 = this._todo.Push((Object)xSegment);
            if (xSegment.liesOn(this._r0) && !this._r0.equals(xSegment.target())) {
                listItem = listItem2;
            }
            xPoint = this._polygon.point(n);
            ++n;
        }
        if (listItem == null) {
            return;
        }
        this._todo.cycle(this._todo.cyclicRelative(listItem, 1));
        xSegment = (XSegment)listItem.value();
        if (this._r0.equals(xSegment.source())) {
            return;
        }
        this._todo.remove(listItem);
        this._todo.Push((Object)new XSegment(xSegment.source(), this._r0));
        this._todo.push((Object)new XSegment(this._r0, xSegment.target()));
        this._cutOnr0 = true;
    }

    private void handleCovering() {
        if (this._vis == 4 || this._vis == 5) {
            if (this._todo.empty()) {
                return;
            }
            XRay xRay = new XRay(this._p, ((XSegment)this._done.firstValue()).source());
            XSegment xSegment = null;
            Intersection intersection = this._akt.intersection(xRay);
            if (intersection.xpoint() == null) {
                return;
            }
            XSegment xSegment2 = new XSegment(((XSegment)this._done.firstValue()).source(), intersection.xpoint());
            boolean bl = false;
            do {
                boolean bl2 = bl = (intersection = xSegment2.intersection(xSegment = (XSegment)this._todo.pop())).xpoint() != null;
                if (!bl || xSegment.target().orientation(this._p, intersection.xpoint()) == 2) continue;
                bl = false;
            } while (!this._todo.empty() && !bl);
            if (bl) {
                this._todo.push((Object)new XSegment(intersection.xpoint(), xSegment.target()));
            }
        }
    }

    private void handleRightTurnOutside() {
        if (this._todo.empty()) {
            return;
        }
        XRay xRay = new XRay(this._p, this._r);
        XSegment xSegment = (XSegment)this._todo.pop();
        Intersection intersection = new Intersection();
        while (!this._todo.empty() && intersection.xpoint() == null) {
            xSegment = (XSegment)this._todo.pop();
            intersection = xSegment.intersection(xRay);
            if (intersection.xpoint() == null || !intersection.xpoint().equals(xSegment.target()) || this._todo.empty()) continue;
            XSegment xSegment2 = (XSegment)this._todo.peek();
            if (xSegment.source().orientation(this._p, xSegment.target()) != xSegment2.target().orientation(this._p, xSegment.target())) continue;
            this._todo.pop();
            intersection = new Intersection();
        }
        if (intersection.xpoint() != null) {
            if (this._p.orientation(xSegment.source(), xSegment.target()) == 1) {
                if (!intersection.xpoint().equals(xSegment.target())) {
                    this._todo.push((Object)new XSegment(intersection.xpoint(), xSegment.target()));
                    return;
                }
            } else if (this._p.squareDistance(intersection.xpoint()) < this._p.squareDistance(this._r)) {
                if (!intersection.xpoint().equals(xSegment.target())) {
                    this._todo.push((Object)new XSegment(intersection.xpoint(), xSegment.target()));
                    return;
                }
            } else {
                this._todo.push((Object)xSegment);
                this._vis = (byte)8;
            }
        }
    }

    private void handleLeftTurnOutside() {
        if (this._todo.empty()) {
            return;
        }
        XRay xRay = new XRay(this._p, this._r);
        XSegment xSegment = (XSegment)this._todo.pop();
        Intersection intersection = new Intersection();
        while (!this._todo.empty() && intersection.xpoint() == null) {
            xSegment = (XSegment)this._todo.pop();
            intersection = xSegment.intersection(xRay);
        }
        if (intersection.xpoint() != null && !intersection.xpoint().equals(xSegment.target())) {
            this._todo.push((Object)new XSegment(intersection.xpoint(), xSegment.target()));
        }
    }

    private void handleEnterShadow() {
        if (this._vis == 8 && !this._todo.empty() && !this._done.empty()) {
            XSegment xSegment = (XSegment)this._done.lastValue();
            XRay xRay = new XRay(this._p, xSegment.target());
            xSegment = (XSegment)this._todo.pop();
            Intersection intersection = xSegment.intersection(xRay);
            if (intersection.xpoint() == null || this._todo.empty()) {
                return;
            }
            if (intersection.xpoint().equals(xSegment.target())) {
                xSegment = (XSegment)this._todo.pop();
            }
            if (this._todo.empty()) {
                return;
            }
            xSegment = (XSegment)this._todo.pop();
            XSegment xSegment2 = new XSegment(this._p, intersection.xpoint());
            intersection = xSegment2.intersection(xSegment);
            while (!this._todo.empty() && intersection.xpoint() == null) {
                xSegment = (XSegment)this._todo.pop();
                intersection = xSegment2.intersection(xSegment);
            }
            if (intersection.xpoint() != null && !intersection.xpoint().equals(xSegment.target())) {
                this._todo.push((Object)new XSegment(intersection.xpoint(), xSegment.target()));
            }
        }
    }

    public XPolygon vis(XPoint xPoint) {
        XSegment xSegment;
        if (this._polygon == null || this._polygon.length() < 3 || xPoint == null) {
            return null;
        }
        this._polygon.setOrientation((byte)1);
        this._p = xPoint;
        byte by = this._polygon.locate(this._p);
        if (by == 3) {
            return null;
        }
        this._r0 = by == 2 ? new XPoint(this._p) : this.getFirstBorderPoint();
        this.initializeToDo();
        while (!this._todo.empty()) {
            this._akt = (XSegment)this._todo.pop();
            this._next = !this._todo.empty() ? (XSegment)this._todo.lastValue() : null;
            this._r = this._akt.target();
            this._rl = this._akt.source();
            this.checkVisibility();
            this.trimAkt();
            this.updateDone();
            if (this.testRightTurnOutside()) {
                this.handleRightTurnOutside();
            }
            if (this.testLeftTurnOutside()) {
                this.handleLeftTurnOutside();
            }
            this.handleCovering();
            this.handleEnterShadow();
        }
        if (this._done.length() < 2) {
            return new XPolygon(this._done);
        }
        XSegment xSegment2 = (XSegment)this._done.firstValue();
        if (xSegment2 != (xSegment = (XSegment)this._done.lastValue()) && this._cutOnr0 && xSegment2.source().equals(xSegment.target())) {
            this._done.Pop();
            this._done.pop();
            this._done.push((Object)new XSegment(xSegment.source(), xSegment2.target()));
        }
        return new XPolygon(this._done);
    }
}

