/*
 * Decompiled with CFR 0.152.
 */
package gishur.x.voronoi;

import gishur.core.ControlledCloneable;
import gishur.core.ListItem;
import gishur.core.SimpleList;
import gishur.x.XPoint;
import gishur.x.XSegment;
import gishur.x.voronoi.SkEdge;
import gishur.x.voronoi.VoronoiException;
import java.util.Hashtable;

public class SKR
implements ControlledCloneable {
    public static final byte SEGMENT = 0;
    public static final byte POINT = 1;
    protected SimpleList edges;
    public boolean mark;
    private Object base;
    private byte type = 0;

    public String toString() {
        return this.getClass().getName() + "[" + this.base + "][" + this.edges.length() + " SkEdges" + (this.mark ? ", marked]" : "]");
    }

    public SKR(Object object) {
        if (!(object instanceof XSegment) && !(object instanceof XPoint)) {
            throw new VoronoiException(2, object);
        }
        this.base = object;
        this.type = object instanceof XSegment ? (byte)0 : 1;
        this.edges = new SimpleList();
    }

    public SkEdge scan(SkEdge skEdge, XPoint xPoint, boolean bl) {
        ListItem listItem = bl ? this.edges.first() : this.edges.last();
        ListItem listItem2 = null;
        if (skEdge != null) {
            listItem = skEdge.leftID();
            if (!this.edges.contains(listItem)) {
                listItem = skEdge.rightID();
            }
            if (!this.edges.contains(listItem)) {
                throw new VoronoiException(4, skEdge);
            }
        } else {
            skEdge = (SkEdge)listItem.key();
        }
        int n = bl ? 1 : -1;
        XPoint xPoint2 = null;
        ListItem listItem3 = this.edges.cyclicRelative(listItem, n);
        while (listItem3 != listItem && xPoint2 == null) {
            xPoint2 = ((SkEdge)listItem3.key()).intersect(skEdge, skEdge.source());
            listItem2 = listItem3;
            listItem3 = this.edges.cyclicRelative(listItem3, n);
        }
        if (xPoint2 != null) {
            xPoint.set(xPoint2.x, xPoint2.y);
            return (SkEdge)listItem2.key();
        }
        return null;
    }

    public String toShortString() {
        return "SKR[" + this.base + "]";
    }

    ListItem addleft(SkEdge skEdge, SkEdge skEdge2) {
        if (skEdge != null) {
            ListItem listItem = skEdge.leftID();
            if (!this.edges.contains(listItem)) {
                listItem = skEdge.rightID();
            }
            if (!this.edges.contains(listItem)) {
                throw new VoronoiException(4, skEdge);
            }
            return this.edges.insert(listItem.next(), (Object)skEdge2);
        }
        return this.edges.insert(this.edges.first(), (Object)skEdge2);
    }

    public byte type() {
        return this.type;
    }

    public SkEdge first() {
        if (this.edges.empty()) {
            return null;
        }
        return (SkEdge)this.edges.first().key();
    }

    public SkEdge last() {
        if (this.edges.empty()) {
            return null;
        }
        return (SkEdge)this.edges.last().key();
    }

    ListItem addright(SkEdge skEdge, SkEdge skEdge2) {
        if (skEdge != null) {
            ListItem listItem = skEdge.leftID();
            if (!this.edges.contains(listItem)) {
                listItem = skEdge.rightID();
            }
            if (!this.edges.contains(listItem)) {
                throw new VoronoiException(4, skEdge);
            }
            return this.edges.insert(listItem, (Object)skEdge2);
        }
        return this.edges.add((Object)skEdge2);
    }

    public void cleanup(SkEdge skEdge, SkEdge skEdge2) {
        ListItem listItem;
        ListItem listItem2 = this.edges.contains(skEdge.leftID()) ? skEdge.leftID() : skEdge.rightID();
        ListItem listItem3 = listItem = this.edges.contains(skEdge2.leftID()) ? skEdge2.leftID() : skEdge2.rightID();
        if (listItem2 == listItem || listItem2.next() == listItem) {
            return;
        }
        listItem2 = listItem2.next();
        while (listItem2 != null && listItem2 != listItem) {
            SkEdge skEdge3 = (SkEdge)listItem2.key();
            listItem2 = listItem2.next();
            skEdge3.remove();
        }
    }

    public Object base() {
        return this.base;
    }

    public void cleanup(SkEdge skEdge, boolean bl) {
        ListItem listItem;
        if (skEdge == null) {
            return;
        }
        ListItem listItem2 = listItem = this.edges.contains(skEdge.leftID()) ? skEdge.leftID() : skEdge.rightID();
        if (listItem == null) {
            return;
        }
        listItem = bl ? listItem.next() : listItem.prev();
        while (listItem != null) {
            SkEdge skEdge2 = (SkEdge)listItem.key();
            listItem = bl ? listItem.next() : listItem.prev();
            skEdge2.remove();
        }
    }

    public SkEdge next(SkEdge skEdge) {
        ListItem listItem = null;
        if (skEdge != null) {
            listItem = skEdge.ID(this);
        }
        if ((listItem = this.edges.cyclicRelative(listItem, 1)) == null) {
            return null;
        }
        return (SkEdge)listItem.key();
    }

    public Object clone(Hashtable hashtable, int n) {
        SKR sKR;
        if (n == 0) {
            return this;
        }
        if (hashtable == null) {
            hashtable = new Hashtable<Object, Object>();
        }
        if (hashtable.contains(this)) {
            return hashtable.get(this);
        }
        SimpleList simpleList = this.edges;
        Object object = this.base;
        this.edges = null;
        this.base = null;
        try {
            sKR = (SKR)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error while cloning");
        }
        this.edges = simpleList;
        this.base = object;
        if (hashtable.contains(this.base)) {
            sKR.base = hashtable.get(this.base);
        } else if (this.base instanceof XSegment) {
            sKR.base = ((XSegment)this.base).clone();
            hashtable.put(this.base, sKR.base);
        } else if (this.base instanceof XPoint) {
            sKR.base = ((XPoint)this.base).clone();
            hashtable.put(this.base, sKR.base);
        } else {
            sKR.base = this.base;
        }
        sKR.edges = (SimpleList)this.edges.clone(hashtable, n);
        hashtable.put(this.edges, sKR.edges);
        hashtable.put(this, sKR);
        return sKR;
    }

    public Object clone() {
        return this.clone(null, -1);
    }

    Object clone(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        if (hashtable.contains(this)) {
            return hashtable.get(this);
        }
        Object v = hashtable.get(this.base);
        if (v == null) {
            return null;
        }
        SKR sKR = new SKR(v);
        System.out.println("begin SKR.clone");
        System.out.println("h=" + hashtable);
        sKR.edges = (SimpleList)this.edges.clone(hashtable, -1);
        sKR.mark = this.mark;
        hashtable.put(this, sKR);
        System.out.println("h=" + hashtable);
        System.out.println("end SKR.clone");
        return sKR;
    }

    public XSegment xsegment() {
        if (this.type == 0) {
            return (XSegment)this.base;
        }
        return null;
    }

    public XPoint xpoint() {
        if (this.type == 1) {
            return (XPoint)this.base;
        }
        return null;
    }

    public SkEdge prev(SkEdge skEdge) {
        ListItem listItem = null;
        if (skEdge != null) {
            listItem = skEdge.ID(this);
        }
        if ((listItem = this.edges.cyclicRelative(listItem, -1)) == null) {
            return null;
        }
        return (SkEdge)listItem.key();
    }

    public void remove(SkEdge skEdge) {
        ListItem listItem = this.edges.contains(skEdge.leftID()) ? skEdge.leftID() : skEdge.rightID();
        this.edges.remove(listItem);
    }
}

