/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.objects.jfreechart;

import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.OutputDeviceGraphicsDrawer;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JFreeChartBarDiagramObjectDrawer
implements FSObjectDrawer {
    static Map<Shape, String> buildShapeLinkMap(ChartRenderingInfo renderingInfo, int dotsPerPixel) {
        HashMap<Shape, String> linkShapes = null;
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.scale(dotsPerPixel, dotsPerPixel);
        for (Object entity : renderingInfo.getEntityCollection().getEntities()) {
            if (!(entity instanceof ChartEntity)) continue;
            ChartEntity chartEntity = (ChartEntity)entity;
            Shape shape = chartEntity.getArea();
            String url = chartEntity.getURLText();
            if (url == null) continue;
            if (linkShapes == null) {
                linkShapes = new HashMap<Shape, String>();
            }
            linkShapes.put(scaleTransform.createTransformedShape(shape), url);
        }
        return linkShapes;
    }

    public Map<Shape, String> drawObject(Element e, double x, double y, final double width, final double height, OutputDevice outputDevice, RenderingContext ctx, final int dotsPerPixel) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        NodeList childNodes = e.getChildNodes();
        final HashMap<String, String> urls = new HashMap<String, String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!(item instanceof Element)) continue;
            Element childElement = (Element)item;
            String tagName = ((Element)item).getTagName();
            if (!tagName.equals("data")) continue;
            String series = childElement.getAttribute("series");
            String categorie = childElement.getAttribute("category");
            double value = Double.parseDouble(childElement.getAttribute("value"));
            String url = childElement.getAttribute("url");
            dataset.setValue(value, (Comparable)((Object)series), (Comparable)((Object)categorie));
            urls.put(series + ":" + categorie, url);
        }
        final JFreeChart chart1 = ChartFactory.createBarChart((String)e.getAttribute("title"), (String)e.getAttribute("series-label"), (String)e.getAttribute("categories-label"), (CategoryDataset)dataset);
        ((CategoryPlot)chart1.getPlot()).getRenderer().setDefaultItemURLGenerator(new CategoryURLGenerator(){

            public String generateURL(CategoryDataset dataset, int series, int category) {
                return (String)urls.get(dataset.getRowKey(series) + ":" + dataset.getColumnKey(category));
            }
        });
        final ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
        outputDevice.drawWithGraphics((float)x, (float)y, (float)width / (float)dotsPerPixel, (float)height / (float)dotsPerPixel, new OutputDeviceGraphicsDrawer(){

            public void render(Graphics2D graphics2D) {
                chart1.draw(graphics2D, (Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, (float)(width / (double)dotsPerPixel), (float)(height / (double)dotsPerPixel)), renderingInfo);
            }
        });
        return JFreeChartBarDiagramObjectDrawer.buildShapeLinkMap(renderingInfo, dotsPerPixel);
    }
}

