/*
 * Decompiled with CFR 0.152.
 */
package thinletcommons;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import thinlet.Thinlet;
import thinletcommons.AntiAliasedThinlet;
import thinletcommons.ThinletDialog;

public class ColorChooser {
    private static final Logger log = Logger.getLogger("thinletcommons");
    private ThinletDialog dialog;
    private Thinlet thinlet;
    private Color selectedColor;
    private Object sl_red;
    private Object sl_green;
    private Object sl_blue;
    private Object sb_red;
    private Object sb_green;
    private Object sb_blue;
    private Object tf_hue;
    private Object tf_saturation;
    private Object tf_brightness;
    private Object pb_hue;
    private Object pb_saturation;
    private Object pb_brightness;
    private Object rgb_label;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public ColorChooser(Frame owner, String title) {
        this.dialog = new ThinletDialog(owner, title);
        this.init();
    }

    public ColorChooser(Dialog owner, String title) {
        this.dialog = new ThinletDialog(owner, title);
        this.init();
    }

    private void init() {
        this.thinlet = new AntiAliasedThinlet();
        try {
            Object panel = this.thinlet.parse("/thinletcommons/colorchooser.xml", (Object)this);
            this.thinlet.add(panel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing colorchooser.xml", e);
        }
        this.dialog.setContent(this.thinlet);
    }

    public void show() {
        if (ColorChooser.debug()) {
            log.fine("in show");
        }
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void setSelectedColor(Color color) {
        int red = 0;
        int green = 0;
        int blue = 0;
        if (color != null) {
            red = color.getRed();
            green = color.getGreen();
            blue = color.getBlue();
            this.thinlet.setInteger(this.sl_red, "value", red);
            this.thinlet.setInteger(this.sl_green, "value", green);
            this.thinlet.setInteger(this.sl_blue, "value", blue);
            this.thinlet.setString(this.sb_red, "text", String.valueOf(red));
            this.thinlet.setString(this.sb_green, "text", String.valueOf(green));
            this.thinlet.setString(this.sb_blue, "text", String.valueOf(blue));
            this.hsbChanged();
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void init(Object sl_red, Object sl_green, Object sl_blue, Object sb_red, Object sb_green, Object sb_blue, Object tf_hue, Object tf_saturation, Object tf_brightness, Object pb_hue, Object pb_saturation, Object pb_brightness, Object rgb_label) {
        if (ColorChooser.debug()) {
            log.fine("in init");
        }
        this.sl_red = sl_red;
        this.sl_green = sl_green;
        this.sl_blue = sl_blue;
        this.sb_red = sb_red;
        this.sb_green = sb_green;
        this.sb_blue = sb_blue;
        this.tf_hue = tf_hue;
        this.tf_saturation = tf_saturation;
        this.tf_brightness = tf_brightness;
        this.pb_hue = pb_hue;
        this.pb_saturation = pb_saturation;
        this.pb_brightness = pb_brightness;
        this.rgb_label = rgb_label;
    }

    public void sliderChanged(int value, Object spinbox) {
        this.thinlet.setString(spinbox, "text", String.valueOf(value));
        this.hsbChanged();
    }

    public void spinboxChanged(String text, Object slider) {
        try {
            int value = Integer.parseInt(text);
            if (value >= 0 && value <= 255) {
                this.thinlet.setInteger(slider, "value", value);
                this.hsbChanged();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void ok() {
        int red = this.thinlet.getInteger(this.sl_red, "value");
        int green = this.thinlet.getInteger(this.sl_green, "value");
        int blue = this.thinlet.getInteger(this.sl_blue, "value");
        this.selectedColor = new Color(red, green, blue);
        this.dialog.setVisible(false);
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    private void hsbChanged() {
        int red = this.thinlet.getInteger(this.sl_red, "value");
        int green = this.thinlet.getInteger(this.sl_green, "value");
        int blue = this.thinlet.getInteger(this.sl_blue, "value");
        float[] hsb = Color.RGBtoHSB(red, green, blue, null);
        this.thinlet.setColor(this.rgb_label, "background", new Color(red, green, blue));
        this.thinlet.setString(this.tf_hue, "text", String.valueOf(hsb[0]));
        this.thinlet.setString(this.tf_saturation, "text", String.valueOf(hsb[1]));
        this.thinlet.setString(this.tf_brightness, "text", String.valueOf(hsb[2]));
        this.thinlet.setInteger(this.pb_hue, "value", (int)(100.0f * hsb[0]));
        this.thinlet.setInteger(this.pb_saturation, "value", (int)(100.0f * hsb[1]));
        this.thinlet.setInteger(this.pb_brightness, "value", (int)(100.0f * hsb[2]));
    }
}

