/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.cts.gt2;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.impl.cts.gt2.CoordSys;
import org.geotools.ct.CannotCreateTransformException;
import org.geotools.ct.CoordinateTransformation;
import org.geotools.ct.CoordinateTransformationFactory;
import org.geotools.ct.MathTransform;
import org.geotools.pt.CoordinatePoint;
import org.opengis.referencing.operation.TransformException;

class CoordTrans
implements ICoordTrans {
    private CoordinateTransformationFactory trFactory = CoordinateTransformationFactory.getDefault();
    private CoordinateTransformation tr = null;
    private MathTransform mt = null;
    private MathTransform mt2 = null;
    private MathTransform mt3 = null;
    private MathTransform mtDatum = null;
    private CoordSys from = null;
    private CoordSys to = null;
    private ICoordTrans invertedCT = null;

    public CoordTrans(CoordSys from, CoordSys to) {
        this.from = from;
        this.to = to;
        try {
            if (from.getDatum() != to.getDatum()) {
                this.tr = this.trFactory.createFromCoordinateSystems(from.toGeo().getCS(), to.toGeo().getCS());
                this.mtDatum = this.tr.getMathTransform();
            }
            if (from.projCS != null && to.projCS != null) {
                CoordSys geogcs = from.toGeo();
                this.tr = this.trFactory.createFromCoordinateSystems(from.getCS(), geogcs.getCS());
                this.mt = this.tr.getMathTransform();
                if (this.mtDatum != null) {
                    this.mt2 = this.mtDatum;
                }
                geogcs = to.toGeo();
                this.tr = this.trFactory.createFromCoordinateSystems(geogcs.getCS(), to.getCS());
                if (this.mt2 == null) {
                    this.mt2 = this.tr.getMathTransform();
                } else {
                    this.mt3 = this.tr.getMathTransform();
                }
            } else {
                if (from.projCS == null) {
                    this.mt = this.mtDatum;
                }
                this.tr = this.trFactory.createFromCoordinateSystems(from.getCS(), to.getCS());
                if (this.mt == null) {
                    this.mt = this.tr.getMathTransform();
                    if (this.mtDatum != null) {
                        this.mt2 = this.mtDatum;
                    }
                } else {
                    this.mt2 = this.tr.getMathTransform();
                }
            }
        }
        catch (CannotCreateTransformException e) {
            e.printStackTrace();
        }
    }

    public IProjection getPOrig() {
        return this.from;
    }

    public IProjection getPDest() {
        return this.to;
    }

    public ICoordTrans getInverted() {
        if (this.invertedCT == null) {
            this.invertedCT = new CoordTrans(this.to, this.from);
        }
        return this.invertedCT;
    }

    public Point2D convert(Point2D ptOrig, Point2D ptDest) {
        CoordinatePoint pt1 = new CoordinatePoint(ptOrig);
        CoordinatePoint pt2 = new CoordinatePoint(0.0, 0.0);
        ptDest = null;
        try {
            this.mt.transform(pt1, pt2);
            ptDest = pt2.toPoint2D();
            if (this.mt2 != null) {
                this.mt2.transform(pt2, pt1);
                ptDest = pt1.toPoint2D();
                if (this.mt3 != null) {
                    this.mt3.transform(pt1, pt2);
                    ptDest = pt2.toPoint2D();
                }
            }
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return ptDest;
    }

    public String toString() {
        return this.tr.toString();
    }

    public Rectangle2D convert(Rectangle2D rect) {
        Point2D.Double pt1 = new Point2D.Double(rect.getMinX(), rect.getMinY());
        Point2D.Double pt2 = new Point2D.Double(rect.getMaxX(), rect.getMaxY());
        Point2D.Double pt3 = new Point2D.Double(rect.getMinX(), rect.getMaxY());
        Point2D.Double pt4 = new Point2D.Double(rect.getMaxX(), rect.getMinY());
        this.convert(pt1, pt1);
        this.convert(pt2, pt2);
        this.convert(pt3, pt3);
        this.convert(pt4, pt4);
        double min_x = Math.min(Math.min(((Point2D)pt1).getX(), ((Point2D)pt2).getX()), Math.min(((Point2D)pt3).getX(), ((Point2D)pt4).getX()));
        double min_y = Math.min(Math.min(((Point2D)pt1).getY(), ((Point2D)pt2).getY()), Math.min(((Point2D)pt3).getY(), ((Point2D)pt4).getY()));
        double max_x = Math.max(Math.max(((Point2D)pt1).getX(), ((Point2D)pt2).getX()), Math.max(((Point2D)pt3).getX(), ((Point2D)pt4).getX()));
        double max_y = Math.max(Math.max(((Point2D)pt1).getY(), ((Point2D)pt2).getY()), Math.max(((Point2D)pt3).getY(), ((Point2D)pt4).getY()));
        return new Rectangle2D.Double(min_x, min_y, max_x - min_x, max_y - min_y);
    }
}

