/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import java.awt.geom.Point2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.geo.Projected;
import org.cresques.impl.geo.Ellipsoid;
import org.cresques.impl.geo.Mercator;
import org.cresques.impl.geo.Projection;

public class ProjPoint
extends Point2D
implements Projected {
    IProjection proj = Mercator.getProjection(Ellipsoid.ed50);
    public double X;
    public double Y;

    public ProjPoint() {
        this.setLocation(0.0, 0.0);
    }

    public ProjPoint(Projection proj) {
        this.setLocation(0.0, 0.0);
        this.proj = proj;
    }

    public ProjPoint(double x, double y) {
        this.setLocation(x, y);
    }

    public ProjPoint(Projection proj, double x, double y) {
        this.setLocation(x, y);
        this.proj = proj;
    }

    public ProjPoint(Point2D pt) {
        this.setLocation(pt.getX(), pt.getY());
    }

    public ProjPoint(Projection proj, Point2D pt) {
        this.setLocation(pt.getX(), pt.getY());
        this.proj = proj;
    }

    public IProjection getProjection() {
        return this.proj;
    }

    public void reProject(ICoordTrans rp) {
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public void setLocation(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    public String toString() {
        return "(" + this.proj + ": " + this.getX() + "," + this.getY() + ")";
    }

    public Point2D toGeo() {
        return ((Projection)this.proj).toGeo(this);
    }
}

