/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.spi.dynformfield;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.json.JsonObject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.DynFormFieldAction;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynform.spi.dynformfield.JProblemIndicator;
import org.gvsig.tools.dynform.spi.dynformfield.SupportPopupMenu;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractJDynFormField.class);
    private final DynFormSPIManager manager;
    private final JDynFormFieldFactory factory;
    private final DynFormFieldDefinition definition;
    private final DynFormSPIManager.ComponentsFactory componentsFactory;
    private JDynForm form;
    protected JLabel jlabel = null;
    private JPanel jlabelpanel = null;
    private Set listeners = null;
    private JProblemIndicator problemIndicator = null;
    protected JComponent contents = null;
    protected boolean readOnly = false;
    private final List customActions;
    protected boolean emptyToNull = false;
    private Map<String, AbstractButton> buttonsOfEvents = null;

    public AbstractJDynFormField(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        this.manager = serviceManager;
        this.factory = factory;
        this.definition = definition;
        this.componentsFactory = componentsFactory;
        this.listeners = new HashSet();
        this.problemIndicator = this.manager.createProblemIndicator(this);
        this.customActions = new ArrayList();
        if (this.definition != null) {
            this.readOnly = this.definition.isReadOnly();
            this.loadDefaultValuesFromTags(definition.getTags());
        }
    }

    public DynFormSPIManager.ComponentsFactory getComponentsFactory() {
        return this.componentsFactory;
    }

    public void loadDefaultValuesFromTags(Tags tags) {
        try {
            this.readOnly = tags.getBoolean("dynform.readonly");
        }
        catch (CoercionException coercionException) {
            // empty catch block
        }
        try {
            this.emptyToNull = tags.getBoolean("dynform.translateEmptyToNull");
        }
        catch (CoercionException coercionException) {
            // empty catch block
        }
    }

    public abstract void initComponent();

    public abstract Object getAssignedValue();

    public JComponent asJComponent() {
        if (this.contents == null) {
            try {
                this.initComponent();
            }
            catch (Throwable th) {
                StringWriter sw = new StringWriter();
                th.printStackTrace(new PrintWriter(sw));
                this.contents = new JLabel("##ERROR##");
                this.problemIndicator().set("Can't create component\n" + sw.toString());
            }
            if (!this.customActions.isEmpty()) {
                this.addPopupComponents();
            }
            if (this.readOnly) {
                this.setReadOnly(this.readOnly);
            }
        }
        return this.contents;
    }

    public String getName() {
        return this.definition.getName();
    }

    public String getLabel() {
        if (this.definition.getLabel() != null) {
            String label = this.definition.getLabel();
            label = ToolsLocator.getI18nManager().getTranslation(label);
            return label;
        }
        return this.getName();
    }

    public String getSeparatorTitleToUseBefore() {
        String separatorTitle = this.getTagValueAsString("dynform.separator", null);
        return separatorTitle;
    }

    public boolean useEmptyLabel() {
        boolean useEmpty = this.getTagValueAsBoolean("dynform.label.empty", false);
        return useEmpty;
    }

    public JComponent getJLabel() {
        if (this.jlabel == null) {
            this.jlabel = this.getComponentsFactory().getJLabel(this.definition, null);
            if (this.jlabel == null) {
                this.jlabel = new JLabel();
            }
            if (!this.useEmptyLabel()) {
                this.jlabel.setText(this.getLabel());
            }
            this.jlabel.setLabelFor(this.contents);
            if (this.getDefinition().isMandatory()) {
                this.jlabel.setForeground(Color.red.darker());
                this.jlabel.setText("<html><b>" + this.getLabel() + "</b></html>");
            }
            this.jlabelpanel = new JPanel();
            this.jlabelpanel.setLayout(new BorderLayout());
            this.jlabelpanel.add((Component)this.jlabel, "Center");
            this.jlabelpanel.add((Component)this.problemIndicator.asJComponent(), "After");
        }
        return this.jlabelpanel;
    }

    public DynFormFieldDefinition getDefinition() {
        return this.definition;
    }

    public DynFormSPIManager getServiceManager() {
        return this.manager;
    }

    public void addListener(JDynFormField.JDynFormFieldListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(JDynFormField.JDynFormFieldListener listener) {
        this.listeners.remove(listener);
    }

    public void fireFieldChangedEvent() {
        if (this.isReadOnly()) {
            return;
        }
        for (JDynFormField.JDynFormFieldListener listener : this.listeners) {
            try {
                listener.fieldChanged((JDynFormField)this);
            }
            catch (Exception ex) {
                LOGGER.info("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
            }
        }
    }

    protected void fireFieldEnterEvent() {
        for (JDynFormField.JDynFormFieldListener listener : this.listeners) {
            try {
                listener.fieldEnter((JDynFormField)this);
            }
            catch (Exception ex) {
                LOGGER.info("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
            }
        }
    }

    protected void fireFieldExitEvent() {
        for (JDynFormField.JDynFormFieldListener listener : this.listeners) {
            try {
                listener.fieldExit((JDynFormField)this);
            }
            catch (Exception ex) {
                LOGGER.info("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
            }
        }
    }

    public void fireMessageEvent(String message) {
        for (JDynFormField.JDynFormFieldListener listener : this.listeners) {
            try {
                listener.message((JDynFormField)this, message);
            }
            catch (Exception ex) {
                LOGGER.info("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
            }
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected boolean isForcedReadOnly() {
        return this.getTagValueAsBoolean("dynform.readonly", false);
    }

    public void setReadOnly(boolean readonly) {
        if (!readonly && this.isForcedReadOnly()) {
            readonly = true;
        }
        this.readOnly = readonly;
        if (this.jlabel != null) {
            this.jlabel.setEnabled(!readonly);
        }
        if (this.contents != null) {
            if (this.contents instanceof JTextComponent) {
                JTextComponent x = (JTextComponent)this.contents;
                x.setEditable(!readonly);
            } else if (this.contents instanceof JComboBox) {
                JComboBox x = (JComboBox)this.contents;
                x.setEnabled(!readonly);
            } else if (this.contents instanceof JScrollPane) {
                try {
                    JViewport port = ((JScrollPane)this.contents).getViewport();
                    JTextComponent x = (JTextComponent)port.getView();
                    x.setEditable(!readonly);
                }
                catch (Exception ex) {
                    this.contents.setEnabled(!this.readOnly);
                }
            } else {
                this.contents.setEnabled(!this.readOnly);
            }
        }
        this.setReadOnlyButtonsOfEvents(readonly);
    }

    public JProblemIndicator problemIndicator() {
        return this.problemIndicator;
    }

    public String toString() {
        return super.toString() + "{" + this.getName() + "}";
    }

    public boolean isModified() {
        boolean modified = false;
        try {
            if (!this.isReadOnly()) {
                Object value = this.getValue();
                if (value == null) {
                    Object x = this.getAssignedValue();
                    if (StringUtils.isNotBlank((CharSequence)Objects.toString(x, null))) {
                        modified = true;
                    }
                } else {
                    Object x = this.getAssignedValue();
                    if (x instanceof CharSequence) {
                        if (!StringUtils.equals((CharSequence)((CharSequence)x), (CharSequence)value.toString())) {
                            modified = true;
                        }
                    } else if (!value.equals(this.getAssignedValue())) {
                        modified = true;
                    }
                }
            }
        }
        catch (IllegalFieldValue ex) {
            modified = true;
        }
        return modified;
    }

    private void addPopupComponents() {
        for (Object obj : this.customActions) {
            if (obj != null) {
                Action act = (Action)obj;
                if (!(this.contents instanceof SupportPopupMenu)) continue;
                DynFormFieldAction sact = new DynFormFieldAction(this, act);
                ((SupportPopupMenu)((Object)this.contents)).addActionToPopupMenu(sact.getName(), sact);
                continue;
            }
            if (!(this.contents instanceof SupportPopupMenu)) continue;
            ((SupportPopupMenu)((Object)this.contents)).addSeparatorToPopupMenu();
        }
    }

    public void addActionToPopupMenu(String name, Action action) {
        if (this.contents != null) {
            if (this.contents instanceof SupportPopupMenu) {
                DynFormFieldAction sact = new DynFormFieldAction(this, action);
                ((SupportPopupMenu)((Object)this.contents)).addActionToPopupMenu(sact.getName(), sact);
            }
        } else {
            this.customActions.add(action);
        }
    }

    public void addSeparatorToPopupMenu() {
        if (this.contents != null) {
            if (this.contents instanceof SupportPopupMenu) {
                ((SupportPopupMenu)((Object)this.contents)).addSeparatorToPopupMenu();
            }
        } else {
            this.customActions.add(null);
        }
    }

    public void setTranslateEmptyToNull(boolean emptyToNull) {
        this.emptyToNull = emptyToNull;
    }

    public boolean translateEmptyToNull() {
        return this.emptyToNull;
    }

    public void clear() {
        if (this.contents == null) {
            return;
        }
        Object value = this.getDefinition().getDefaultValue();
        this.setValue(value);
    }

    public void setForm(JDynForm form) {
        this.form = form;
    }

    public JDynForm getForm() {
        return this.form;
    }

    public void fetch(DynObject container) {
        DynField dynfield;
        Object value = this.getValue();
        DynClass dynclass = container.getDynClass();
        if (dynclass != null && (dynfield = dynclass.getDynField(this.getName())) != null && dynfield.isReadOnly()) {
            return;
        }
        container.setDynValue(this.getName(), value);
    }

    protected int getTagValueAsInt(String tagname, int defaultVaue) {
        return this.getTagValueAsInt(tagname, null, defaultVaue);
    }

    protected int getTagValueAsInt(String tagname1, String tagname2, int defaultVaue) {
        String tagname;
        DynFormFieldDefinition fielddef = this.getDefinition();
        if (fielddef.getTags().has(tagname1)) {
            tagname = tagname1;
        } else if (fielddef.getTags().has(tagname2)) {
            tagname = tagname2;
        } else {
            return defaultVaue;
        }
        try {
            int value = fielddef.getTags().getInt(tagname);
            return value;
        }
        catch (CoercionException ex) {
            LOGGER.warn("Can't parse tag '" + tagname + "' as int for field '" + fielddef.getName() + "'.", (Throwable)ex);
            return defaultVaue;
        }
    }

    protected boolean getTagValueAsBoolean(String tagname, boolean defaultVaue) {
        return this.getTagValueAsBoolean(tagname, null, defaultVaue);
    }

    protected boolean getTagValueAsBoolean(String tagname1, String tagname2, boolean defaultVaue) {
        String tagname;
        DynFormFieldDefinition fielddef = this.getDefinition();
        if (fielddef.getTags().has(tagname1)) {
            tagname = tagname1;
        } else if (fielddef.getTags().has(tagname2)) {
            tagname = tagname2;
        } else {
            return defaultVaue;
        }
        try {
            boolean value = fielddef.getTags().getBoolean(tagname);
            return value;
        }
        catch (CoercionException ex) {
            LOGGER.warn("Can't parse tag '" + tagname + "' as boolean for field '" + fielddef.getName() + "'.", (Throwable)ex);
            return defaultVaue;
        }
    }

    protected String getTagValueAsString(String tagname, String defaultVaue) {
        return this.getTagValueAsString(tagname, null, defaultVaue);
    }

    protected String getTagValueAsString(String tagname1, String tagname2, String defaultVaue) {
        String tagname;
        DynFormFieldDefinition fielddef = this.getDefinition();
        if (fielddef.getTags().has(tagname1)) {
            tagname = tagname1;
        } else if (fielddef.getTags().has(tagname2)) {
            tagname = tagname2;
        } else {
            return defaultVaue;
        }
        try {
            String value = (String)fielddef.getTags().get(tagname, 8);
            return value;
        }
        catch (CoercionException ex) {
            LOGGER.warn("Can't parse tag '" + tagname + "' as string for field '" + fielddef.getName() + "'.", (Throwable)ex);
            return defaultVaue;
        }
    }

    public double getResizeWeight() {
        Tags tags = this.getDefinition().getTags();
        int resizeWeight = tags.getInt("dynform.resizeWeight", 0);
        if (resizeWeight < 1) {
            return 0.0;
        }
        if (resizeWeight > 100) {
            return 1.0;
        }
        return (double)resizeWeight / 100.0;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.hasValidValue()) {
            this.problemIndicator().clear();
        } else {
            try {
                Object object = this.getValue();
            }
            catch (Exception e) {
                this.problemIndicator().set(e.getLocalizedMessage());
            }
        }
        this.fireFieldExitEvent();
    }

    protected void fixPreferredWidth(JComponent comp) {
        Dimension prefsize = comp.getPreferredSize();
        if (prefsize.width > 200) {
            prefsize.width = 200;
            comp.setPreferredSize(prefsize);
        }
    }

    protected ImageIcon getIcon(String name) {
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        ImageIcon icon = theme.get(name);
        return icon;
    }

    public String toHTML() {
        return null;
    }

    public boolean hasClickEvent(String eventName) {
        Script script = this.getForm().getScript();
        if (script == null) {
            return false;
        }
        String functionName = this.getName() + "_" + eventName + "_click";
        List names = script.getNames();
        return names != null && names.contains(functionName);
    }

    public AbstractButton getButtonForClickEvent(String eventName, String tip, String iconName) {
        AbstractButton button;
        AbstractJDynFormField jfield = this;
        JDynForm jform = this.getForm();
        Script script = jform.getScript();
        if (script == null) {
            return null;
        }
        if (this.buttonsOfEvents == null) {
            this.buttonsOfEvents = new HashMap<String, AbstractButton>();
        }
        if ((button = this.buttonsOfEvents.get(eventName + "_click")) != null) {
            return button;
        }
        String functionName = this.getName() + "_" + eventName + "_click";
        JsonObject config = this.getEventConfiguration(eventName);
        if (config != null && StringUtils.isNotBlank((CharSequence)config.getString("tip", null))) {
            tip = config.getString("tip", null);
        }
        button = new JButton();
        ToolsSwingUtils.configurePickersButton((AbstractButton)button, (String)tip, (String)iconName, e -> {
            try {
                script.invokeFunction(functionName, new Object[]{jform, jfield});
            }
            catch (Throwable t) {
                LOGGER.warn("Error calling event '" + functionName + "'", t);
            }
        }, (FocusListener)new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AbstractJDynFormField.this.fireFieldEnterEvent();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.buttonsOfEvents.put(eventName + "_click", button);
        return button;
    }

    protected JsonObject getEventConfiguration(String name) {
        JDynForm jform = this.getForm();
        Script script = jform.getScript();
        if (script == null) {
            return null;
        }
        String functionName = this.getName() + "_" + name + "_config";
        try {
            Object x = script.invokeFunction(functionName, new Object[0]);
            return (JsonObject)x;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            LOGGER.warn("Error calling event '" + functionName + "'", t);
            return null;
        }
    }

    protected void setReadOnlyButtonsOfEvents(boolean readonly) {
        if (this.buttonsOfEvents == null) {
            return;
        }
        for (Map.Entry<String, AbstractButton> entry : this.buttonsOfEvents.entrySet()) {
            String name = entry.getKey();
            AbstractButton button = entry.getValue();
            try {
                JsonObject config = this.getEventConfiguration(StringUtils.removeEnd((String)name, (String)"_click"));
                boolean enabled = config.getBoolean("enabled");
                button.setEnabled(enabled);
            }
            catch (Throwable ex) {
                button.setEnabled(!readonly);
            }
        }
    }

    public class IllegalFieldValue
    extends RuntimeException {
        private static final long serialVersionUID = -4409236610055983438L;

        public IllegalFieldValue(JDynFormField field, String message) {
            super("The value of field '" + field.getLabel() + "' is not valid. " + message);
        }
    }
}

