/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gpe;

import java.io.File;
import java.util.HashMap;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.resource.exception.ResourceExecuteException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.gpe.GPESetProvider;
import org.gvsig.fmap.dal.store.gpe.GPEStoreParameters;
import org.gvsig.fmap.dal.store.gpe.handlers.FmapContentHandler;
import org.gvsig.fmap.dal.store.gpe.handlers.FmapErrorHandler;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.lib.api.parser.IGPEContentHandler;
import org.gvsig.gpe.lib.api.parser.IGPEErrorHandler;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.xmlschema.lib.api.XMLSchemaLocator;
import org.gvsig.xmlschema.lib.api.XMLSchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPEStoreProvider
extends AbstractFeatureStoreProvider
implements ResourceConsumer {
    public static final String NAME = "GPE";
    public static final String DESCRIPTION = "GPE file";
    public static final String METADATA_DEFINITION_NAME = "GPE";
    private static Logger logger = LoggerFactory.getLogger(GPEStoreProvider.class);
    protected File m_Fich;
    protected boolean isOpen = false;
    private ResourceProvider gpeResource;
    protected GPEManager gpeManager = null;
    protected XMLSchemaManager xmlSchemaManager = null;
    protected FmapContentHandler contentHandler;
    protected FmapErrorHandler errorHandler;

    public GPEStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        this(params, storeServices, FileHelper.newMetadataContainer((String)"GPE"));
    }

    protected GPEStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata) throws InitializeException {
        super(params, storeServices, metadata);
        this.setDynValue("Envelope", params.getDynValue("Envelope"));
        this.gpeManager = GPELocator.getGPEManager();
        this.xmlSchemaManager = XMLSchemaLocator.getXMLSchemaManager();
        this.retrieveFile();
        this.gpeResource = this.createResource("file", new Object[]{this.m_Fich.getAbsolutePath()});
        this.gpeResource.addConsumer((ResourceConsumer)this);
        this.initFeatureType();
    }

    protected void retrieveFile() throws InitializeException {
        this.m_Fich = this.getGPEParameters().getFile();
    }

    protected void initFeatureType() throws InitializeException {
        try {
            this.open();
        }
        catch (DataException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
    }

    private GPEStoreParameters getGPEParameters() {
        return (GPEStoreParameters)this.getParameters();
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        IProjection resp;
        if ("CRS".equalsIgnoreCase(name) && (resp = this.getSRS()) != null) {
            return resp;
        }
        return super.getDynValue(name);
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return false;
    }

    public void resourceChanged(ResourceProvider resource) {
    }

    public boolean canWriteGeometry(int geometryType, int geometrySubtype) throws DataException {
        return false;
    }

    public Object createNewOID() {
        return this.contentHandler.createNewOID();
    }

    public FeatureSetProvider createSet(FeatureQuery query) throws DataException {
        return new GPESetProvider(this, query);
    }

    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference) throws DataException {
        return this.internalGetFeatureProviderByReference(reference, this.getFeatureStore().getDefaultFeatureType());
    }

    public FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference, FeatureType featureType) throws DataException {
        HashMap featureSet = this.contentHandler.getFeatureSet();
        if (featureSet.containsKey(reference.getOID())) {
            return (FeatureProvider)featureSet.get(reference.getOID());
        }
        return null;
    }

    FeatureProvider getFeatureProviderByIndex(Long index, FeatureType fType) throws DataException {
        HashMap featureSet = this.contentHandler.getFeatureSet();
        if (featureSet.containsKey(index)) {
            return (FeatureProvider)featureSet.get(index);
        }
        return null;
    }

    public void resourcesBegin() throws ResourceExecuteException {
    }

    public void resourcesEnd() {
    }

    public int getOIDType() {
        return 8;
    }

    public String getProviderName() {
        return "GPE";
    }

    public Object getSourceId() {
        return this.getGPEParameters().getFile();
    }

    public String getName() {
        String name = this.getGPEParameters().getFile().getName();
        int n = name.lastIndexOf(".");
        if (n < 1) {
            return name;
        }
        return name.substring(0, n);
    }

    public String getFullName() {
        return this.getGPEParameters().getFile().getAbsolutePath();
    }

    public void open() throws OpenException {
        if (this.isOpen) {
            return;
        }
        try {
            this.errorHandler = new FmapErrorHandler();
            this.contentHandler = new FmapContentHandler((IGPEErrorHandler)this.errorHandler, this.getStoreServices(), this, this.m_Fich, this.getSRS(), this.getGeometryType(), this.getGPEParameters().getUseAxisOrderYX());
            if (this.getStoreServices().getDefaultFeatureType() != null) {
                this.contentHandler.setFeatureType(this.getStoreServices().getDefaultFeatureType().getEditable());
            }
            this.contentHandler.setEnvelope((Envelope)this.getDynValue("Envelope"));
            this.isOpen = true;
            this.gpeManager.parse((IGPEContentHandler)this.contentHandler, (IGPEErrorHandler)this.errorHandler, this.m_Fich.toURI());
        }
        catch (Exception e) {
            throw new OpenException("Imposible create a parser", (Throwable)e);
        }
        if (this.errorHandler.getErrorsSize() > 0) {
            throw new OpenException("Error when open gpe", this.errorHandler.getErrorAt(0));
        }
    }

    protected IProjection getSRS() {
        return this.getGPEParameters().getCRS();
    }

    protected int getGeometryType() {
        return 0;
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType featureType) throws DataException {
        return new GPESetProvider(this, query, featureType);
    }

    public long getFeatureCount() throws DataException {
        return this.contentHandler.getFeaturesCount();
    }

    public Envelope getEnvelope() throws DataException {
        this.open();
        return (Envelope)this.getDynValue("Envelope");
    }

    public void setEnvelope(Envelope envelope) {
        this.setDynValue("Envelope", envelope);
    }

    public ResourceProvider getResource() {
        return this.gpeResource;
    }

    public DataServerExplorer getExplorer() throws ReadException, ValidateDataParametersException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getGPEParameters().getFile().getParent());
            return manager.createServerExplorer((DataServerExplorerParameters)params);
        }
        catch (DataException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
        catch (ValidateDataParametersException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
    }

    public FmapContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public FmapErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

