/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.app.extension.messagewait;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.gvsig.scripting.app.extension.messagewait.MessageWaitView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class MessageWait
extends MessageWaitView {
    private static final long serialVersionUID = 6668980523307140920L;
    private WaitingCondition condition;
    private int seconds = 3;
    private boolean cancelled = false;
    private Runnable action;

    public MessageWait() {
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageWait.this.cancelled = true;
                MessageWait.this.setVisible(false);
            }
        });
        URL url = this.getClass().getResource("/images/spinner.gif");
        ImageIcon icon = new ImageIcon(url);
        this.lblIcon.setIcon(icon);
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.btnCancel.setText(i18n.getTranslation("Cancel"));
    }

    public void showMessage(String title, String msg, WaitingCondition condition, Runnable action) {
        this.showMessage(title, msg, condition, action, 3);
    }

    public void showMessage(String title, String msg, WaitingCondition condition, Runnable action, int seconds) {
        if (condition.stopWaiting()) {
            SwingUtilities.invokeLater(action);
            return;
        }
        this.setVisible(true);
        this.condition = condition;
        this.seconds = seconds;
        this.action = action;
        this.cancelled = false;
        this.lblMsg.setText("<html>" + msg.replace("\n", "<br>\n") + "</html>");
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)5, (int)60, (int)10, (int)100);
        WindowManager winmgr = ToolsSwingLocator.getWindowManager();
        winmgr.showWindow((JComponent)this, title, WindowManager.MODE.TOOL);
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                MessageWait.this.doWait();
            }
        }, "MessageWait");
        th.start();
    }

    private void doWait() {
        while (!this.condition.stopWaiting()) {
            try {
                Thread.sleep(this.seconds * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.cancelled) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageWait.this.setVisible(false);
                MessageWait.this.action.run();
            }
        });
    }

    public static interface WaitingCondition {
        public boolean stopWaiting();
    }
}

