/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gml;

import java.io.IOException;
import java.io.Reader;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.gml.GMLFeatureTypeLoader;
import org.gvsig.fmap.dal.store.gml.GMLStoreParameters;
import org.gvsig.fmap.dal.store.gml.simplereaders.GMLReader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderFeatureTypeLoader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreProvider;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.SimpleReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMLStoreProvider
extends SimpleReaderStoreProvider
implements ResourceConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GMLStoreProvider.class);
    public static final String NAME = "GML";
    public static final String DESCRIPTION = "GML file";
    public static final String METADATA_DEFINITION_NAME = "GML";

    public GMLStoreProvider(GMLStoreParameters parameters, DataStoreProviderServices storeServices) throws InitializeException {
        super((SimpleReaderStoreParameters)parameters, storeServices, FileHelper.newMetadataContainer((String)"GML"));
    }

    private GMLStoreParameters getGMLParameters() {
        return (GMLStoreParameters)this.getParameters();
    }

    public String getProviderName() {
        return "GML";
    }

    protected SimpleReader getSimpleReader(SimpleReaderStoreParameters parameters, Reader in) throws IOException {
        GMLReader reader = new GMLReader(in, (GMLStoreParameters)parameters);
        return reader;
    }

    protected SimpleReaderFeatureTypeLoader getFeatureTypeLoader() {
        return new GMLFeatureTypeLoader(this.getGMLParameters());
    }
}

