/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.impl;

import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.AbstractManager;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.ProviderManager;
import org.gvsig.vectorediting.lib.api.EditingManager;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.api.EditingServiceInfo;
import org.gvsig.vectorediting.lib.api.exceptions.ServiceInformationException;
import org.gvsig.vectorediting.lib.impl.DefaultEditingProviderManager;
import org.gvsig.vectorediting.lib.impl.DefaultEditingProviderServices;
import org.gvsig.vectorediting.lib.impl.DefaultEditingService;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditingManager
extends AbstractManager
implements EditingManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEditingManager.class);

    public DefaultEditingManager() {
        super((ProviderManager)new DefaultEditingProviderManager());
    }

    public Service getService(DynObject arg0) throws ServiceException {
        DefaultEditingProviderServices editingProviderServices = new DefaultEditingProviderServices();
        DefaultEditingService service = new DefaultEditingService(arg0, editingProviderServices);
        return service;
    }

    public EditingServiceInfo getServiceInfo(String serviceName) throws ServiceInformationException {
        return EditingProviderLocator.getProviderManager().getServiceInfo(serviceName);
    }

    public EditingService getEditingService(String name, FeatureStore featureStore, MapContext mapContext, IVectorLegend legend) {
        try {
            DynObject params = this.createServiceParameters(name);
            params.setDynValue("featureStore", (Object)featureStore);
            params.setDynValue("mapContext", (Object)mapContext);
            if (legend != null && params.getDynClass().getDynField("legendField") != null) {
                params.setDynValue("legendField", (Object)legend);
            }
            return (EditingService)this.getService(params);
        }
        catch (ServiceException e) {
            String msg = String.format("Some problem getting %1$s editing service. Seems to name is not correct or there is not factory registered with that name. ", name);
            logger.info(msg, (Throwable)e);
            return null;
        }
    }

    public EditingService getEditingService(String name, FeatureStore featureStore, MapContext mapContext) {
        return this.getEditingService(name, featureStore, mapContext, null);
    }
}

