/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryCoercionContext;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.AbstractProviderManager;
import org.gvsig.tools.service.spi.Provider;
import org.gvsig.tools.service.spi.ProviderFactory;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.vectorediting.lib.api.EditingServiceInfo;
import org.gvsig.vectorediting.lib.api.exceptions.ServiceInformationException;
import org.gvsig.vectorediting.lib.spi.EditingProviderFactory;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditingProviderManager
extends AbstractProviderManager
implements EditingProviderManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEditingProviderManager.class);
    Map<String, ISymbol> symbols = new HashMap<String, ISymbol>();
    Map<String, Map<String, String>> defaultValues = new HashMap<String, Map<String, String>>();
    private String clipboardValue;
    private List<Geometry> geometriesFromClipboard;
    private List<EditableFeature> featuresFromClipboard;

    public ProviderServices createProviderServices(Service service) {
        return null;
    }

    protected String getRegistryKey() {
        return null;
    }

    protected String getRegistryDescription() {
        return null;
    }

    public Provider createProvider(DynObject serviceParameters, ProviderServices providerServices) throws ServiceException {
        String providerName = (String)serviceParameters.getDynValue("providerName");
        ProviderFactory factory = this.getProviderFactory(providerName);
        return factory == null ? null : factory.create(serviceParameters, providerServices);
    }

    public EditingServiceInfo getServiceInfo(String name) throws ServiceInformationException {
        try {
            EditingProviderFactory factory = (EditingProviderFactory)this.getProviderFactory(name);
            return factory == null ? null : factory.getServiceInfo();
        }
        catch (Exception e) {
            throw new ServiceInformationException("Can't get service info of " + name, (Throwable)e);
        }
    }

    public void registerIcon(String group, String name, ClassLoader loader, String provider) {
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        String resourceName = group == null || group.trim().length() == 0 ? "images/" + name + ".png" : "images/" + group + "/" + name + ".png";
        URL resource = null;
        try {
            resource = loader.getResource(resourceName);
            iconTheme.registerDefault(provider, group, name, null, resource);
        }
        catch (Throwable e) {
            logger.info("Can't register icon '" + name + "'.", e);
        }
    }

    public void registerSymbol(String name, ISymbol symbol) {
        this.symbols.put(name, symbol);
    }

    public ISymbol getSymbol(String name) {
        return this.symbols.get(name);
    }

    public void registerDefaultValues(String provider, Map values) {
        if (!this.defaultValues.containsKey(provider)) {
            this.defaultValues.put(provider, values);
        }
    }

    public void registerDefaultValues(String provider, ClassLoader loader) {
        if (!this.defaultValues.containsKey(provider)) {
            String resourceName = "defaultvalues/" + provider + "/defaultvalues.properties";
            HashMap<String, String> providerDefaultValues = new HashMap<String, String>();
            URL resource = null;
            try {
                resource = loader.getResource(resourceName);
                Properties properties = new Properties();
                properties.load(resource.openStream());
                for (String string : properties.keySet()) {
                    providerDefaultValues.put(string, (String)properties.get(string));
                }
                this.defaultValues.put(provider, providerDefaultValues);
            }
            catch (Throwable e) {
                logger.info("Can't register default values from '" + provider + "'.", e);
            }
        }
    }

    public Map<String, String> getDefaultValues(String name) {
        return this.defaultValues.get(name);
    }

    public List<Geometry> getGeometriesFromClipboard() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        String clipboardValue = manager.getFromClipboard();
        if (StringUtils.isNotBlank((CharSequence)clipboardValue) && StringUtils.isNotBlank((CharSequence)this.clipboardValue) && StringUtils.equals((CharSequence)clipboardValue, (CharSequence)this.clipboardValue)) {
            return this.geometriesFromClipboard;
        }
        this.geometriesFromClipboard = new ArrayList<Geometry>();
        String geometryName = null;
        try {
            JsonArray jsonArray = Json.createArray((String)clipboardValue);
            Coercion toGeometry = ToolsLocator.getDataTypesManager().getCoercion(66);
            block6: for (JsonValue item : jsonArray) {
                JsonObject jsonItem = (JsonObject)item;
                if (StringUtils.isBlank(geometryName)) {
                    for (Map.Entry field : jsonItem.entrySet()) {
                        try {
                            Geometry geometry = (Geometry)toGeometry.coerce((Object)((JsonValue)field.getValue()).toString().replace("\"", ""));
                            if (geometry == null) continue;
                            geometryName = (String)field.getKey();
                            this.geometriesFromClipboard.add(geometry);
                            continue block6;
                        }
                        catch (Exception exception) {
                        }
                    }
                    continue;
                }
                try {
                    String strGeom = jsonItem.getString(geometryName);
                    Geometry geometry = (Geometry)toGeometry.coerce((Object)strGeom);
                    if (geometry == null) continue;
                    this.geometriesFromClipboard.add(geometry);
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.geometriesFromClipboard;
    }

    public List<EditableFeature> getFeaturesFromClipboard(EditingProviderServices providerServices, FeatureStore store) {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        String clipboardValue = manager.getFromClipboard();
        if (StringUtils.isNotBlank((CharSequence)clipboardValue) && StringUtils.isNotBlank((CharSequence)this.clipboardValue) && StringUtils.equals((CharSequence)clipboardValue, (CharSequence)this.clipboardValue)) {
            return this.featuresFromClipboard;
        }
        this.featuresFromClipboard = new ArrayList<EditableFeature>();
        GeometryType storeGeomType = store.getDefaultFeatureTypeQuietly().getDefaultGeometryAttribute().getGeomType();
        GeometryCoercionContext context = GeometryLocator.getGeometryManager().createGeometryCoercionContext();
        context.setGeometryType(storeGeomType);
        context.setMode(1);
        Coercion toGeometry = DataTypeUtils.getCoercion((int)66);
        String geometryName = null;
        try {
            JsonArray jsonArray = Json.createArray((String)clipboardValue);
            for (JsonValue item : jsonArray) {
                JsonObject jsonItem = (JsonObject)item;
                EditableFeature feat = providerServices.createNewFeature(store);
                feat.setDefaultGeometry(null);
                feat.copyFrom(jsonItem, t -> !t.isPrimaryKey() && (!t.isIndexed() || t.allowIndexDuplicateds()));
                Geometry geometry = feat.getDefaultGeometry();
                if (geometry == null) {
                    if (StringUtils.isBlank(geometryName)) {
                        for (Map.Entry field : jsonItem.entrySet()) {
                            try {
                                geometry = (Geometry)toGeometry.coerce((Object)((JsonValue)field.getValue()).toString().replace("\"", ""), (CoercionContext)context);
                                if (geometry == null) continue;
                                geometryName = (String)field.getKey();
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                    } else {
                        try {
                            String strGeom = jsonItem.getString(geometryName);
                            geometry = (Geometry)toGeometry.coerce((Object)strGeom, (CoercionContext)context);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    geometry = (Geometry)toGeometry.coerce((Object)geometry, (CoercionContext)context);
                }
                if (geometry == null) continue;
                feat.setDefaultGeometry(geometry);
                this.featuresFromClipboard.add(feat);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.featuresFromClipboard;
    }
}

