/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.comboboxconfigurablelookup;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.MutableComboBoxModel;
import org.gvsig.gui.beans.comboboxconfigurablelookup.IComboBoxLookUp;
import org.gvsig.gui.beans.comboboxconfigurablelookup.ILookUp;
import org.gvsig.gui.beans.comboboxconfigurablelookup.StringComparator;
import org.gvsig.gui.beans.comboboxconfigurablelookup.agents.StartsWithLookUpAgent;

public class DefaultComboBoxConfigurableLookUpModel
extends AbstractListModel
implements ComboBoxModel,
MutableComboBoxModel,
Serializable,
IComboBoxLookUp {
    private static final long serialVersionUID = 3514664640086791882L;
    private Vector<Object> objects;
    private Vector<Object> alphabeticallyOrdered;
    private Object selectedObject = null;
    private List<Object> visibleList;
    private String textWritten;
    private ILookUp lookUpAgent;
    private VectorUtilities vectorUtilities;
    private boolean eventNotificationEnabled = true;
    public static final int MAINTAIN_POSITION = 0;
    public static final int ALPHABETICAL_ORDERED = 1;
    public static final int MAINTAIN_AGENT_POSITIONS = 2;
    public static final boolean SHOW_ALL_ITEMS = true;
    public static final boolean SHOW_ONLY_MATCHES = false;
    public static final boolean CASE_SENSITIVE = true;
    public static final boolean CASE_INSENSITIVE = false;
    public static final int DEFAULT_ITEMS_ORDER_CONFIGURATION = 2;
    public static final boolean DEFAULT_SHOW_ALL_ITEMS_IN_LIST_BOX_CONFIGURATION = false;
    public static final String DEFAULT_LANGUAGE_RULES_CONFIGURATION = "en_EN";
    public static final boolean DEFAULT_CASE_SENSITIVE_CONFIGURATION = true;
    private int itemsOrder;
    private boolean showAllItemsInListBox;
    private String localeRules;
    private StringComparator stringComparator;

    public DefaultComboBoxConfigurableLookUpModel() {
        this.objects = new Vector();
        this.initialize();
    }

    public DefaultComboBoxConfigurableLookUpModel(Object[] items) {
        this.objects = new Vector<Object>(Arrays.asList(items));
        this.initialize();
    }

    public DefaultComboBoxConfigurableLookUpModel(Vector<Object> vector) {
        this.objects = new Vector<Object>(vector);
        this.initialize();
    }

    public void addElement(Object object) {
        this.objects.addElement(object);
        this.vectorUtilities.addAlphabeticallyOrdered(this.alphabeticallyOrdered, object, this.stringComparator);
        int index = this.objects.size() - 1;
        this.updateVisibleList();
        if (this.eventNotificationEnabled) {
            this.fireIntervalAdded(this, index, index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        Object obj = this.objects.get(index);
        this.alphabeticallyOrdered.remove(obj);
        this.objects.removeElementAt(index);
        this.updateVisibleList();
        if (this.eventNotificationEnabled) {
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void insertElementAt(Object object, int index) {
        this.objects.insertElementAt(object, index);
        this.vectorUtilities.addAlphabeticallyOrdered(this.alphabeticallyOrdered, object, this.stringComparator);
        this.updateVisibleList();
        if (this.eventNotificationEnabled) {
            this.fireIntervalAdded(this, index, index);
        }
    }

    @Override
    public void removeElement(Object object) {
        int index = this.getIndexOf(object);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        this.selectedObject = null;
        int size = this.objects.size();
        if (size > 0) {
            this.objects.removeAllElements();
            this.alphabeticallyOrdered.removeAllElements();
            this.updateVisibleList();
            if (this.eventNotificationEnabled) {
                this.fireIntervalRemoved(this, 0, size - 1);
            }
        }
    }

    @Override
    public int getSize() {
        if (this.visibleList == null) {
            return 0;
        }
        return this.visibleList.size();
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.selectedObject == null && anObject == null) {
            return;
        }
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.textWritten = anObject == null ? null : anObject.toString();
            this.updateVisibleList();
            if (this.eventNotificationEnabled) {
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public Object getElementAt(int index) {
        if (this.visibleList == null) {
            return null;
        }
        if (index >= 0 && index < this.visibleList.size()) {
            return this.visibleList.get(index);
        }
        return null;
    }

    public int getIndexOf(Object object) {
        if (this.visibleList == null) {
            return -1;
        }
        return this.visibleList.indexOf(object);
    }

    public int getItemsOrder() {
        return this.itemsOrder;
    }

    public void setItemsOrder(int itemsOrder) {
        this.itemsOrder = itemsOrder;
    }

    public boolean isShowAllItemsInListBox() {
        return this.showAllItemsInListBox;
    }

    public void setShowAllItemsInListBox(boolean itemsShownInListBox) {
        this.showAllItemsInListBox = itemsShownInListBox;
    }

    public String getLocaleRules() {
        return this.localeRules;
    }

    public void setLocaleRules(String localeRules) {
        this.localeRules = localeRules;
        StringComparator stringComparator = this.stringComparator;
        stringComparator.getClass();
        this.stringComparator.setLocaleRules(new StringComparator.LocaleRules(stringComparator, true, Collator.getInstance(new Locale(this.localeRules))));
        Collections.sort(this.alphabeticallyOrdered.subList(0, this.alphabeticallyOrdered.size()), this.stringComparator);
        this.updateVisibleList();
    }

    public boolean isCaseSensitive() {
        return this.stringComparator.isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.stringComparator.setCaseSensitive(caseSensitive);
        Collections.sort(this.alphabeticallyOrdered.subList(0, this.alphabeticallyOrdered.size()), this.stringComparator);
        this.updateVisibleList();
    }

    protected void initialize() {
        this.textWritten = "";
        this.vectorUtilities = new VectorUtilities();
        this.lookUpAgent = new StartsWithLookUpAgent();
        this.stringComparator = new StringComparator();
        this.stringComparator.setCaseSensitive(true);
        StringComparator stringComparator = this.stringComparator;
        stringComparator.getClass();
        this.stringComparator.setLocaleRules(new StringComparator.LocaleRules(stringComparator, true, Collator.getInstance(new Locale(DEFAULT_LANGUAGE_RULES_CONFIGURATION))));
        this.setDefaultBehaviorFlagsConfiguration();
        this.alphabeticallyOrdered = new Vector<Object>(this.objects.subList(0, this.objects.size()));
        Collections.sort(this.alphabeticallyOrdered.subList(0, this.alphabeticallyOrdered.size()), this.stringComparator);
        this.visibleList = new ArrayList<Object>();
        this.updateVisibleList();
    }

    protected void setDefaultBehaviorFlagsConfiguration() {
        this.itemsOrder = 2;
        this.showAllItemsInListBox = false;
        this.localeRules = DEFAULT_LANGUAGE_RULES_CONFIGURATION;
        this.stringComparator.setCaseSensitive(true);
    }

    public Vector<Object> getData() {
        return this.objects;
    }

    public Vector<Object> getDataAccordingItemsOrder() {
        switch (this.itemsOrder) {
            case 0: {
                return this.objects;
            }
            case 1: {
                return this.alphabeticallyOrdered;
            }
            case 2: {
                List<Object> list = this.stringComparator.isCaseSensitive() ? this.lookUpAgent.doLookUpConsideringCaseSensitive("", this.alphabeticallyOrdered, this.stringComparator) : this.lookUpAgent.doLookUpIgnoringCaseSensitive("", this.alphabeticallyOrdered, this.stringComparator);
                return new Vector<Object>(list.subList(0, list.size()));
            }
        }
        return this.alphabeticallyOrdered;
    }

    protected void updateVisibleList() {
        if (!this.eventNotificationEnabled) {
            return;
        }
        if (this.objects.size() == 0) {
            this.visibleList = this.alphabeticallyOrdered.subList(0, 0);
            return;
        }
        if (this.showAllItemsInListBox) {
            switch (this.itemsOrder) {
                case 0: {
                    this.visibleList = this.objects.subList(0, this.objects.size());
                    break;
                }
                case 1: {
                    this.visibleList = this.alphabeticallyOrdered.subList(0, this.alphabeticallyOrdered.size());
                    break;
                }
                case 2: {
                    if (this.stringComparator.isCaseSensitive()) {
                        this.visibleList = this.lookUpAgent.doLookUpConsideringCaseSensitive("", this.alphabeticallyOrdered, this.stringComparator);
                        break;
                    }
                    this.visibleList = this.lookUpAgent.doLookUpIgnoringCaseSensitive("", this.alphabeticallyOrdered, this.stringComparator);
                    break;
                }
                default: {
                    this.visibleList = this.alphabeticallyOrdered.subList(0, this.alphabeticallyOrdered.size());
                }
            }
            if (this.visibleList != null && this.visibleList.size() > 0) {
                List<Object> list = this.lookUp();
                if (list != null && list.size() > 0) {
                    this.selectedObject = list.get(0);
                    this.textWritten = this.selectedObject.toString();
                } else {
                    this.selectedObject = null;
                }
            }
        } else {
            this.visibleList = this.lookUp();
            switch (this.itemsOrder) {
                case 0: {
                    if (this.visibleList == null) break;
                    Vector<Object> aux = new Vector<Object>(this.objects.subList(0, this.objects.size()));
                    int size = aux.size();
                    Object obj = new Object();
                    for (int i = size - 1; i >= 0; --i) {
                        obj = aux.get(i);
                        if (this.visibleList.contains(obj)) {
                            this.visibleList.remove(obj);
                            continue;
                        }
                        aux.remove(i);
                    }
                    this.visibleList = aux.subList(0, aux.size());
                    break;
                }
                case 1: {
                    if (this.visibleList == null) break;
                    Collections.sort(this.visibleList, this.stringComparator);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    protected List<Object> lookUp() {
        if (this.stringComparator.isCaseSensitive()) {
            return this.lookUpAgent.doLookUpConsideringCaseSensitive(this.textWritten, this.alphabeticallyOrdered, this.stringComparator);
        }
        return this.lookUpAgent.doLookUpIgnoringCaseSensitive(this.textWritten, this.alphabeticallyOrdered, this.stringComparator);
    }

    public ILookUp getLookUpAgent() {
        return this.lookUpAgent;
    }

    public void setLookUpAgent(ILookUp agent) {
        this.lookUpAgent = agent;
        this.updateVisibleList();
    }

    public void setEventNotificationEnabled(boolean b) {
        this.eventNotificationEnabled = b;
    }

    public boolean getEventNotificationEnabled() {
        return this.eventNotificationEnabled;
    }

    @Override
    public void setTextWritten(String text) {
        this.textWritten = text;
        this.updateVisibleList();
    }

    public class VectorUtilities {
        public synchronized void addAlphabeticallyOrdered(Vector<Object> v, Object obj) {
            int size = v.size();
            int lowIndex = 0;
            int highIndex = size - 1;
            int maxNumberOfIterations = (int)this.log2(size);
            if (size == 0) {
                v.add(obj);
                return;
            }
            for (int currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
                int aux_index;
                int index = (lowIndex + highIndex) / 2;
                if (v.get(index).toString().compareTo(obj.toString()) == 0) {
                    v.add(index, obj);
                    return;
                }
                if (v.get(index).toString().compareTo(obj.toString()) < 0) {
                    aux_index = index + 1;
                    if (aux_index >= size) {
                        v.add(v.size(), obj);
                        return;
                    }
                    if (v.get(aux_index).toString().compareTo(obj.toString()) > 0) {
                        v.add(aux_index, obj);
                        return;
                    }
                    lowIndex = aux_index;
                    continue;
                }
                if (v.get(index).toString().compareTo(obj.toString()) <= 0) continue;
                aux_index = index - 1;
                if (aux_index < 0) {
                    v.add(0, obj);
                    return;
                }
                if (v.get(aux_index).toString().compareTo(obj.toString()) < 0) {
                    v.add(index, obj);
                    return;
                }
                highIndex = aux_index;
            }
        }

        public synchronized void addAlphabeticallyOrdered(Vector<Object> v, Object obj, Comparator<Object> comp) {
            int size = v.size();
            int lowIndex = 0;
            int highIndex = size - 1;
            int maxNumberOfIterations = (int)this.log2(size);
            if (size == 0) {
                v.add(obj);
                return;
            }
            for (int currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
                int aux_index;
                int index = (lowIndex + highIndex) / 2;
                if (comp.compare(v.get(index), obj) == 0) {
                    v.add(index, obj);
                    return;
                }
                if (comp.compare(v.get(index), obj) < 0) {
                    aux_index = index + 1;
                    if (aux_index >= size) {
                        v.add(v.size(), obj);
                        return;
                    }
                    if (comp.compare(v.get(aux_index), obj) > 0) {
                        v.add(aux_index, obj);
                        return;
                    }
                    lowIndex = aux_index;
                    continue;
                }
                if (comp.compare(v.get(index), obj) <= 0) continue;
                aux_index = index - 1;
                if (aux_index < 0) {
                    v.add(0, obj);
                    return;
                }
                if (comp.compare(v.get(aux_index), obj) < 0) {
                    v.add(index, obj);
                    return;
                }
                highIndex = aux_index;
            }
        }

        public double log2(double a) {
            return Math.log(a) / Math.log(2.0);
        }

        public int log2Integer(double a) {
            return (int)Math.floor(this.log2(a));
        }
    }
}

