/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.comboboxconfigurablelookup;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.gvsig.gui.beans.comboboxconfigurablelookup.DefaultComboBoxConfigurableLookUpModel;
import org.gvsig.gui.beans.comboboxconfigurablelookup.ILookUp;
import org.gvsig.gui.beans.editabletextcomponent.IEditableText;
import org.gvsig.gui.beans.editabletextcomponent.event.UndoRedoEditEvent;
import org.gvsig.gui.beans.editabletextcomponent.event.UndoRedoEditListener;

public class JComboBoxConfigurableLookUp
extends JComboBox
implements Serializable {
    public static final boolean DEFAULT_ONLY_ONE_COLOR_ON_TEXT_CONFIGURATION = false;
    public static final boolean DEFAULT_BEEP_ENABLED_CONFIGURATION = false;
    public static final boolean DEFAULT_HIDE_POPUP_IF_THERE_ARE_NO_ITEMS_CONFIGURATION = true;
    public static final boolean DEFAULT_TO_FORCE_SELECT_AN_ITEM_CONFIGURATION = true;
    public static final boolean DEFAULT_COMPLETE_ARROW_KEY_SELECTION_CONFIGURATION = false;
    public static final boolean DEFAULT_DISPLAY_ALL_ITEMS_WITH_ARROW_BUTTON_CONFIGURATION = true;
    private PlainDocumentTextFormatter document;
    private DefaultComboBoxConfigurableLookUpModel model;
    private boolean hidePopupOnFocusLoss;
    private boolean popupItemSelected;
    private boolean arrowKeyPressed;
    private boolean arrowButtonClicked;
    private boolean showingAllItemsTemporally;
    private boolean selectingItem = false;
    private Object previousSelected;
    private boolean updatedUI = true;
    private boolean blockPopupHided = false;
    private KeyListener editorKeyListener;
    private FocusListener editorFocusListener;
    private PopupMenuListener popupMenuListener;
    private MouseListener arrowMouseListener;
    private boolean onlyOneColorOnText;
    private boolean beepEnabled;
    private boolean hidePopupIfThereAreNoItems;
    private boolean toForceSelectAnItem;
    private boolean completeArrowKeySelection;
    private boolean displayAllItemsWithArrowButton;

    public JComboBoxConfigurableLookUp() {
        this.initialize();
    }

    public JComboBoxConfigurableLookUp(DefaultComboBoxConfigurableLookUpModel aModel) {
        super(aModel);
        this.initialize();
    }

    public JComboBoxConfigurableLookUp(Object[] items) {
        super(items);
        this.initialize();
    }

    public JComboBoxConfigurableLookUp(Vector<Object> items) {
        super(items);
        this.initialize();
    }

    protected void initialize() {
        this.popupItemSelected = false;
        this.arrowKeyPressed = false;
        this.arrowButtonClicked = false;
        this.showingAllItemsTemporally = false;
        this.previousSelected = null;
        this.setDefaultBehaviorFlagsConfiguration();
        super.setEditable(true);
        this.configure();
        if (this.toForceSelectAnItem && this.model.getData().size() > 0) {
            this.model.setSelectedItem(this.model.getData().elementAt(0));
        }
        this.updateUI();
    }

    protected void configure() {
        this.defineEditorKeyListener(this);
        this.defineEditorFocusListener(this);
        this.configureDocument();
        this.configureEditor(this.getEditor());
        this.configurePopUp(this);
    }

    protected void configureEditor(ComboBoxEditor newEditor) {
        if (newEditor != null) {
            JTextComponent jTextComponentOfEditor = (JTextComponent)newEditor.getEditorComponent();
            jTextComponentOfEditor.setDocument(this.document);
            jTextComponentOfEditor.removeKeyListener(this.editorKeyListener);
            jTextComponentOfEditor.addKeyListener(this.editorKeyListener);
            jTextComponentOfEditor.removeFocusListener(this.editorFocusListener);
            jTextComponentOfEditor.addFocusListener(this.editorFocusListener);
        }
    }

    protected void configureDocument() {
        this.document = new PlainDocumentTextFormatter();
        this.document.setJComboBoxReference(this);
    }

    protected void configurePopUp(JComboBoxConfigurableLookUp comboBox) {
        JComboBoxConfigurableLookUp comboBoxReference = comboBox;
        this.addPopupMenuListener(this.popupMenuListener);
        BasicComboBoxUI comboBoxUi = (BasicComboBoxUI)comboBoxReference.getUI();
        Accessible aC = comboBoxUi.getAccessibleChild(comboBoxReference, 0);
        if (aC instanceof ComboPopup) {
            JList<Object> jlist = ((ComboPopup)((Object)aC)).getList();
            jlist.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JComboBoxConfigurableLookUp.this.popupItemSelected = true;
                    System.out.println("Pulsado");
                }
            });
            if (aC instanceof BasicComboPopup) {
                ((BasicComboPopup)aC).addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                        if (JComboBoxConfigurableLookUp.this.arrowButtonClicked) {
                            JComboBoxConfigurableLookUp.this.arrowButtonClicked = false;
                        }
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        if (JComboBoxConfigurableLookUp.this.arrowButtonClicked) {
                            JComboBoxConfigurableLookUp.this.arrowButtonClicked = false;
                        }
                    }

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        if (JComboBoxConfigurableLookUp.this.arrowButtonClicked) {
                            JComboBoxConfigurableLookUp.this.arrowButtonClicked = false;
                        }
                    }
                });
            }
        }
    }

    public MouseListener getArrowMouseListener() {
        if (this.arrowMouseListener == null) {
            this.arrowMouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JComboBoxConfigurableLookUp.this.arrowButtonClicked = true;
                    boolean popupVisible = JComboBoxConfigurableLookUp.this.updatedUI ? false : JComboBoxConfigurableLookUp.this.isPopupVisible();
                    if (!JComboBoxConfigurableLookUp.this.model.isShowAllItemsInListBox() && JComboBoxConfigurableLookUp.this.displayAllItemsWithArrowButton && !popupVisible) {
                        JComboBoxConfigurableLookUp.this.showingAllItemsTemporally = true;
                        int itemsOrderFlag = JComboBoxConfigurableLookUp.this.model.getItemsOrder();
                        String languageRules = JComboBoxConfigurableLookUp.this.model.getLocaleRules();
                        boolean caseSensitive = JComboBoxConfigurableLookUp.this.model.isCaseSensitive();
                        ILookUp lookUpAgent = JComboBoxConfigurableLookUp.this.model.getLookUpAgent();
                        JComboBoxConfigurableLookUp.this.setModel((ComboBoxModel)new DefaultComboBoxConfigurableLookUpModel(JComboBoxConfigurableLookUp.this.model.getData()));
                        JComboBoxConfigurableLookUp.this.model.setItemsOrder(itemsOrderFlag);
                        JComboBoxConfigurableLookUp.this.model.setShowAllItemsInListBox(true);
                        JComboBoxConfigurableLookUp.this.model.setLocaleRules(languageRules);
                        JComboBoxConfigurableLookUp.this.model.setCaseSensitive(caseSensitive);
                        JComboBoxConfigurableLookUp.this.model.setLookUpAgent(lookUpAgent);
                        JComboBoxConfigurableLookUp.this.model.setTextWritten(JComboBoxConfigurableLookUp.this.document.textWritten);
                        if (JComboBoxConfigurableLookUp.this.updatedUI) {
                            JComboBoxConfigurableLookUp.this.updatedUI = false;
                            JComboBoxConfigurableLookUp.this.showPopup();
                        }
                    }
                }
            };
        }
        return this.arrowMouseListener;
    }

    protected void setDefaultBehaviorFlagsConfiguration() {
        this.onlyOneColorOnText = false;
        this.beepEnabled = false;
        this.hidePopupIfThereAreNoItems = true;
        this.toForceSelectAnItem = true;
        this.completeArrowKeySelection = false;
        this.displayAllItemsWithArrowButton = true;
    }

    private void defineEditorKeyListener(JComboBoxConfigurableLookUp comboBox) {
        final JComboBoxConfigurableLookUp comboBoxReference = comboBox;
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (JComboBoxConfigurableLookUp.this.showingAllItemsTemporally) {
                    JComboBoxConfigurableLookUp.this.showingAllItemsTemporally = false;
                    int itemsOrderFlag = JComboBoxConfigurableLookUp.this.model.getItemsOrder();
                    String languageRules = JComboBoxConfigurableLookUp.this.model.getLocaleRules();
                    boolean caseSensitive = JComboBoxConfigurableLookUp.this.model.isCaseSensitive();
                    ILookUp lookUpAgent = JComboBoxConfigurableLookUp.this.model.getLookUpAgent();
                    comboBoxReference.setModel((ComboBoxModel)new DefaultComboBoxConfigurableLookUpModel(JComboBoxConfigurableLookUp.this.model.getData()));
                    JComboBoxConfigurableLookUp.this.model.setItemsOrder(itemsOrderFlag);
                    JComboBoxConfigurableLookUp.this.model.setShowAllItemsInListBox(false);
                    JComboBoxConfigurableLookUp.this.model.setLocaleRules(languageRules);
                    JComboBoxConfigurableLookUp.this.model.setCaseSensitive(caseSensitive);
                    JComboBoxConfigurableLookUp.this.model.setLookUpAgent(lookUpAgent);
                    JComboBoxConfigurableLookUp.this.model.setTextWritten(JComboBoxConfigurableLookUp.this.document.textWritten);
                }
                switch (ke.getKeyCode()) {
                    case 10: {
                        ke.consume();
                        ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setCaretPosition(JComboBoxConfigurableLookUp.this.document.getLength());
                        DefaultComboBoxConfigurableLookUpModel c_model = (DefaultComboBoxConfigurableLookUpModel)comboBoxReference.getModel();
                        if (JComboBoxConfigurableLookUp.this.toForceSelectAnItem) {
                            if (c_model.isShowAllItemsInListBox()) {
                                if (c_model.getSelectedItem() == null) {
                                    if (c_model.getData().size() > 0) {
                                        if (JComboBoxConfigurableLookUp.this.previousSelected == null) {
                                            JComboBoxConfigurableLookUp.this.previousSelected = c_model.getDataAccordingItemsOrder().elementAt(0);
                                        } else {
                                            ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setText(JComboBoxConfigurableLookUp.this.previousSelected.toString());
                                        }
                                    } else {
                                        JComboBoxConfigurableLookUp.this.previousSelected = null;
                                    }
                                } else {
                                    JComboBoxConfigurableLookUp.this.previousSelected = c_model.getSelectedItem();
                                    comboBoxReference.setSelectedItem(JComboBoxConfigurableLookUp.this.previousSelected);
                                    ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setText(JComboBoxConfigurableLookUp.this.previousSelected.toString());
                                }
                            } else {
                                switch (comboBoxReference.getModel().getSize()) {
                                    case 0: {
                                        if (JComboBoxConfigurableLookUp.this.previousSelected == null) {
                                            if (c_model.getData().size() > 0) {
                                                JComboBoxConfigurableLookUp.this.previousSelected = c_model.getDataAccordingItemsOrder().elementAt(0);
                                            } else {
                                                JComboBoxConfigurableLookUp.this.previousSelected = null;
                                            }
                                        }
                                        ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setText(JComboBoxConfigurableLookUp.this.previousSelected.toString());
                                        break;
                                    }
                                    case 1: {
                                        JComboBoxConfigurableLookUp.this.previousSelected = comboBoxReference.getItemAt(0);
                                        comboBoxReference.setSelectedIndex(0);
                                        break;
                                    }
                                    default: {
                                        if (JComboBoxConfigurableLookUp.this.previousSelected == null) {
                                            JComboBoxConfigurableLookUp.this.previousSelected = comboBoxReference.getItemAt(0);
                                            comboBoxReference.setSelectedIndex(0);
                                            break;
                                        }
                                        ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setText(JComboBoxConfigurableLookUp.this.previousSelected.toString());
                                    }
                                }
                            }
                        }
                        comboBoxReference.hidePopup();
                        if (!JComboBoxConfigurableLookUp.this.completeArrowKeySelection) break;
                        JComboBoxConfigurableLookUp.this.model.setTextWritten(JComboBoxConfigurableLookUp.this.document.textWritten);
                        break;
                    }
                    case 38: 
                    case 40: {
                        JComboBoxConfigurableLookUp.this.popupItemSelected = true;
                        JComboBoxConfigurableLookUp.this.arrowKeyPressed = true;
                    }
                }
            }
        };
    }

    private void defineEditorFocusListener(JComboBoxConfigurableLookUp comboBox) {
        final JComboBoxConfigurableLookUp comboBoxReference = comboBox;
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (JComboBoxConfigurableLookUp.this.showingAllItemsTemporally) {
                    JComboBoxConfigurableLookUp.this.showingAllItemsTemporally = false;
                    int itemsOrderFlag = JComboBoxConfigurableLookUp.this.model.getItemsOrder();
                    String languageRules = JComboBoxConfigurableLookUp.this.model.getLocaleRules();
                    boolean caseSensitive = JComboBoxConfigurableLookUp.this.model.isCaseSensitive();
                    ILookUp lookUpAgent = JComboBoxConfigurableLookUp.this.model.getLookUpAgent();
                    comboBoxReference.setModel((ComboBoxModel)new DefaultComboBoxConfigurableLookUpModel(JComboBoxConfigurableLookUp.this.model.getData()));
                    JComboBoxConfigurableLookUp.this.model.setItemsOrder(itemsOrderFlag);
                    JComboBoxConfigurableLookUp.this.model.setShowAllItemsInListBox(false);
                    JComboBoxConfigurableLookUp.this.model.setLocaleRules(languageRules);
                    JComboBoxConfigurableLookUp.this.model.setCaseSensitive(caseSensitive);
                    JComboBoxConfigurableLookUp.this.model.setLookUpAgent(lookUpAgent);
                    JComboBoxConfigurableLookUp.this.model.setTextWritten(JComboBoxConfigurableLookUp.this.document.textWritten);
                }
                ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setCaretPosition(JComboBoxConfigurableLookUp.this.document.getLength());
                DefaultComboBoxConfigurableLookUpModel c_model = (DefaultComboBoxConfigurableLookUpModel)comboBoxReference.getModel();
                if (JComboBoxConfigurableLookUp.this.toForceSelectAnItem) {
                    if (c_model.isShowAllItemsInListBox()) {
                        if (c_model.getSelectedItem() == null) {
                            if (c_model.getData().size() > 0) {
                                if (JComboBoxConfigurableLookUp.this.previousSelected == null) {
                                    JComboBoxConfigurableLookUp.this.previousSelected = c_model.getDataAccordingItemsOrder().elementAt(0);
                                } else {
                                    ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setText(JComboBoxConfigurableLookUp.this.previousSelected.toString());
                                }
                            } else {
                                JComboBoxConfigurableLookUp.this.previousSelected = null;
                            }
                        } else {
                            JComboBoxConfigurableLookUp.this.previousSelected = c_model.getSelectedItem();
                            comboBoxReference.setSelectedItem(JComboBoxConfigurableLookUp.this.previousSelected);
                        }
                        ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setText(JComboBoxConfigurableLookUp.this.previousSelected.toString());
                    } else {
                        switch (JComboBoxConfigurableLookUp.this.model.getData().size()) {
                            case 0: {
                                if (JComboBoxConfigurableLookUp.this.previousSelected != null) break;
                                if (c_model.getData().size() > 0) {
                                    JComboBoxConfigurableLookUp.this.previousSelected = c_model.getDataAccordingItemsOrder().elementAt(0);
                                    ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setText(JComboBoxConfigurableLookUp.this.previousSelected.toString());
                                    break;
                                }
                                JComboBoxConfigurableLookUp.this.previousSelected = null;
                                break;
                            }
                            default: {
                                if (JComboBoxConfigurableLookUp.this.previousSelected == null) {
                                    JComboBoxConfigurableLookUp.this.previousSelected = comboBoxReference.getItemAt(0);
                                    comboBoxReference.setSelectedIndex(0);
                                    break;
                                }
                                ((JTextComponent)comboBoxReference.getEditor().getEditorComponent()).setText(JComboBoxConfigurableLookUp.this.previousSelected.toString());
                            }
                        }
                    }
                }
                comboBoxReference.hidePopup();
                if (JComboBoxConfigurableLookUp.this.hidePopupOnFocusLoss) {
                    comboBoxReference.setPopupVisible(false);
                }
            }
        };
    }

    @Override
    public void setEditor(ComboBoxEditor anEditor) {
        DocumentListener[] removableDocumentListeners;
        if (anEditor == null) {
            super.setEditor(anEditor);
            return;
        }
        JTextComponent jTextComponentOfEditor = (JTextComponent)anEditor.getEditorComponent();
        PlainDocument old_document = (PlainDocument)jTextComponentOfEditor.getDocument();
        DocumentListener[] documentListeners = old_document.getDocumentListeners();
        UndoableEditListener[] undoableEditListeners = old_document.getUndoableEditListeners();
        this.defineEditorKeyListener(this);
        jTextComponentOfEditor.addKeyListener(this.editorKeyListener);
        this.defineEditorFocusListener(this);
        jTextComponentOfEditor.addFocusListener(this.editorFocusListener);
        this.document = new PlainDocumentTextFormatter();
        this.document.setJComboBoxReference(this);
        for (DocumentListener dL : removableDocumentListeners = this.document.getDocumentListeners()) {
            this.document.removeDocumentListener(dL);
        }
        UndoableEditListener[] removableUndoableEditListeners = this.document.getUndoableEditListeners();
        for (UndoableEditListener undoableEditListener : removableUndoableEditListeners) {
            this.document.removeUndoableEditListener(undoableEditListener);
        }
        for (EventListener eventListener : documentListeners) {
            this.document.addDocumentListener((DocumentListener)eventListener);
        }
        for (EventListener eventListener : undoableEditListeners) {
            this.document.addUndoableEditListener((UndoableEditListener)eventListener);
        }
        if (undoableEditListeners.length > 0 && jTextComponentOfEditor instanceof IEditableText) {
            ((IEditableText)((Object)jTextComponentOfEditor)).addUndoRedoEditListener(new UndoRedoEditListener(){

                @Override
                public void operationExecuted(UndoRedoEditEvent e) {
                    JComboBoxConfigurableLookUp.this.model.setTextWritten(e.getNewText());
                    JComboBoxConfigurableLookUp.this.document.updateOnlyTextColor();
                }
            });
        }
        jTextComponentOfEditor.setDocument(this.document);
        super.setEditor(anEditor);
    }

    public void setModel(ComboBoxModel aModel) {
        if (!(aModel instanceof DefaultComboBoxConfigurableLookUpModel)) {
            Vector<Object> data = new Vector<Object>(aModel.getSize());
            for (int i = 0; i < aModel.getSize(); ++i) {
                data.add(aModel.getElementAt(i));
            }
            aModel = new DefaultComboBoxConfigurableLookUpModel(data);
        }
        super.setModel(aModel);
        this.model = (DefaultComboBoxConfigurableLookUpModel)super.getModel();
    }

    @Override
    public void setSelectedIndex(int anIndex) {
        if (anIndex < -1 || anIndex >= this.model.getSize()) {
            throw new IllegalArgumentException("setSelectedIndex: " + anIndex + " out of bounds");
        }
        this.setSelectedItem(anIndex == -1 ? null : this.model.getElementAt(anIndex));
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.selectedItemReminder == null || !this.selectedItemReminder.equals(anObject)) {
            if (this.arrowKeyPressed) {
                this.selectingItem = true;
                this.model.setSelectedItem(anObject);
                this.selectingItem = false;
                if (this.model.getSize() > 0) {
                    this.previousSelected = anObject;
                }
            } else {
                this.selectingItem = true;
                this.model.setSelectedItem(anObject);
                this.selectingItem = false;
                this.editor.setItem(anObject);
                if (this.model.getSize() > 0) {
                    this.previousSelected = anObject;
                }
            }
            if (this.selectedItemReminder != this.model.getSelectedItem()) {
                this.selectedItemChanged();
            }
        }
        this.fireActionEvent();
        this.document.updateOnlyTextColor();
    }

    @Override
    public void setEditable(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllItems() {
        if (!(this.model instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data dataModel.");
        }
        this.model.setTextWritten("");
        this.model.removeAllElements();
        this.selectedItemReminder = null;
        if (this.isEditable()) {
            this.editor.setItem(null);
        }
        this.document.updateTextColorAndRingBeep();
        this.updateUI();
    }

    public void addItem(Object anObject) {
        super.addItem(anObject);
        if (this.toForceSelectAnItem && this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
        this.document.updateTextColorAndRingBeep();
    }

    @Override
    public void removeItem(Object anObject) {
        super.removeItem(anObject);
        this.document.updateTextColorAndRingBeep();
    }

    @Override
    public void removeItemAt(int anIndex) {
        super.removeItemAt(anIndex);
        this.document.updateTextColorAndRingBeep();
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        ComponentUI oldUI = newUI;
        super.setKeySelectionManager(null);
        this.firePropertyChange("UI", oldUI, newUI);
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean selectWithKeyChar(char keyChar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected JComboBox.KeySelectionManager createDefaultKeySelectionManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String paramString() {
        return super.paramString() + "onlyOneColorOnText" + this.onlyOneColorOnText + "beepEnabled" + this.beepEnabled + "hidePopupIfThereAreNoItems" + this.hidePopupIfThereAreNoItems + "toForceSelectAnItem" + this.toForceSelectAnItem + "completeArrowKeySelection" + this.completeArrowKeySelection + "displayAllItemsWithArrowButton" + this.displayAllItemsWithArrowButton + "itemsOrder" + this.model.getItemsOrder() + "showAllItemsInListBox" + this.model.isShowAllItemsInListBox() + "localeRules" + this.model.getLocaleRules() + "caseSensitive" + this.model.isCaseSensitive();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updatedUI = true;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof JButton)) continue;
            ((JButton)this.getComponent(i)).addMouseListener(this.getArrowMouseListener());
            return;
        }
    }

    @Override
    public void showPopup() {
        if (this.isShowing() && !this.blockPopupHided) {
            this.setPopupVisible(true);
        }
    }

    public void setBlockPopupHided(boolean b) {
        this.blockPopupHided = b;
    }

    public boolean isBlockPopupHided() {
        return this.blockPopupHided;
    }

    public boolean isOnlyOneColorOnText() {
        return this.onlyOneColorOnText;
    }

    public void setOnlyOneColorOnText(boolean b) {
        this.onlyOneColorOnText = b;
    }

    public boolean isBeepEnabled() {
        return this.beepEnabled;
    }

    public void setBeepEnabled(boolean b) {
        this.beepEnabled = b;
    }

    public boolean isHidePopupIfThereAreNoItems() {
        return this.hidePopupIfThereAreNoItems;
    }

    public void setHidePopupIfThereAreNoItems(boolean b) {
        this.hidePopupIfThereAreNoItems = b;
    }

    public boolean isToForceSelectAnItem() {
        return this.toForceSelectAnItem;
    }

    public void setToForceSelectAnItem(boolean b) {
        this.toForceSelectAnItem = b;
    }

    public boolean isCompleteArrowKeySelection() {
        return this.completeArrowKeySelection;
    }

    public void setCompleteArrowKeySelection(boolean b) {
        this.completeArrowKeySelection = b;
    }

    public boolean isDisplayAllItemsWithArrowButton() {
        return this.displayAllItemsWithArrowButton;
    }

    public void setDisplayAllItemsWithArrowButton(boolean b) {
        this.displayAllItemsWithArrowButton = b;
    }

    public class PlainDocumentTextFormatter
    extends PlainDocument {
        private static final long serialVersionUID = -1858441733547527816L;
        private JComboBoxConfigurableLookUp comboBoxReference;
        private String textWritten;
        private boolean updatedModel;
        private String textOfReplacement;
        private boolean textInRedColor;
        private int old_caretPosition;
        private String completeArrowKeySelectionValue;

        public PlainDocumentTextFormatter() {
            this.initialize();
        }

        protected void initialize() {
            this.textWritten = "";
            this.textOfReplacement = "";
            this.textInRedColor = false;
            this.completeArrowKeySelectionValue = null;
        }

        protected void setJComboBoxReference(JComboBoxConfigurableLookUp comboBox) {
            this.comboBoxReference = comboBox;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.updatedModel) {
                JComboBoxConfigurableLookUp.this.model.setTextWritten(this.textWritten);
                super.insertString(offs, this.textWritten, a);
                return;
            }
            JComboBoxConfigurableLookUp.this.hidePopup();
            boolean caretToEnd = true;
            if (this.textWritten.length() > 0) {
                if (offs < this.textWritten.length()) {
                    String old_textWritten = this.textWritten;
                    this.textWritten = this.textWritten.substring(offs, this.textWritten.length());
                    if (offs > 0) {
                        this.textWritten = old_textWritten.substring(0, offs) + str + this.textWritten;
                    } else {
                        if (offs == 0) {
                            caretToEnd = false;
                        }
                        this.textWritten = str + this.textWritten;
                    }
                } else {
                    this.textWritten = this.textWritten.substring(0, offs) + str;
                }
            } else {
                this.textWritten = str;
            }
            if (this.completeArrowKeySelectionValue == null) {
                JComboBoxConfigurableLookUp.this.model.setTextWritten(this.textWritten);
            } else {
                JComboBoxConfigurableLookUp.this.model.setTextWritten(this.completeArrowKeySelectionValue);
            }
            super.insertString(offs, str, a);
            this.updateTextColorAndRingBeep();
            if (JComboBoxConfigurableLookUp.this.model.getSize() > 0) {
                if (JComboBoxConfigurableLookUp.this.isShowing()) {
                    JComboBoxConfigurableLookUp.this.showPopup();
                }
            } else if (this.textWritten.compareTo("") != 0 && !JComboBoxConfigurableLookUp.this.hidePopupIfThereAreNoItems) {
                JComboBoxConfigurableLookUp.this.showPopup();
            }
            if (caretToEnd) {
                this.updateCaretPosition(this.textWritten.length());
            } else {
                this.updateCaretPosition(str.length());
            }
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (JComboBoxConfigurableLookUp.this.arrowKeyPressed) {
                if (!JComboBoxConfigurableLookUp.this.model.isShowAllItemsInListBox()) {
                    if (JComboBoxConfigurableLookUp.this.completeArrowKeySelection) {
                        String currentText = ((JTextComponent)this.comboBoxReference.getEditor().getEditorComponent()).getText();
                        String old_textWritten = this.textWritten;
                        this.old_caretPosition = ((JTextComponent)this.comboBoxReference.getEditor().getEditorComponent()).getCaretPosition() + text.length();
                        this.textWritten = "";
                        super.remove(0, old_textWritten.length());
                        if (this.completeArrowKeySelectionValue == null || !currentText.equals(old_textWritten)) {
                            this.completeArrowKeySelectionValue = old_textWritten;
                        }
                        this.insertString(0, text, null);
                    } else {
                        this.insertString(0, "", null);
                    }
                }
                JComboBoxConfigurableLookUp.this.previousSelected = text;
                JComboBoxConfigurableLookUp.this.arrowKeyPressed = false;
                return;
            }
            this.completeArrowKeySelectionValue = null;
            if (text.compareTo("") == 0 && length == this.textWritten.length()) {
                return;
            }
            if (length > 0) {
                this.textOfReplacement = text;
                this.remove(offset, length);
            } else if (offset > 0 && offset != this.textWritten.length()) {
                JComboBoxConfigurableLookUp.this.hidePopup();
                this.updatedModel = true;
                String old_textWritten = this.textWritten;
                this.old_caretPosition = ((JTextComponent)this.comboBoxReference.getEditor().getEditorComponent()).getCaretPosition() + text.length();
                this.textWritten = "";
                JComboBoxConfigurableLookUp.this.model.setTextWritten(this.textWritten);
                super.remove(0, old_textWritten.length());
                int itemsOrderFlag = JComboBoxConfigurableLookUp.this.model.getItemsOrder();
                boolean showAllItemsInListBox = JComboBoxConfigurableLookUp.this.model.isShowAllItemsInListBox();
                String languageRules = JComboBoxConfigurableLookUp.this.model.getLocaleRules();
                boolean caseSensitive = JComboBoxConfigurableLookUp.this.model.isCaseSensitive();
                ILookUp lookUpAgent = JComboBoxConfigurableLookUp.this.model.getLookUpAgent();
                this.comboBoxReference.setModel((ComboBoxModel)new DefaultComboBoxConfigurableLookUpModel(JComboBoxConfigurableLookUp.this.model.getData()));
                JComboBoxConfigurableLookUp.this.model.setItemsOrder(itemsOrderFlag);
                JComboBoxConfigurableLookUp.this.model.setShowAllItemsInListBox(showAllItemsInListBox);
                JComboBoxConfigurableLookUp.this.model.setLocaleRules(languageRules);
                JComboBoxConfigurableLookUp.this.model.setCaseSensitive(caseSensitive);
                JComboBoxConfigurableLookUp.this.model.setLookUpAgent(lookUpAgent);
                this.insertString(0, this.textWritten, null);
                this.textWritten = old_textWritten.substring(0, offset) + text + old_textWritten.substring(offset, old_textWritten.length());
                this.insertString(0, this.textWritten, null);
                this.updatedModel = false;
                this.updateTextColorAndRingBeep();
                this.updateCaretPosition(this.old_caretPosition);
                if (JComboBoxConfigurableLookUp.this.model.getSize() > 0) {
                    JComboBoxConfigurableLookUp.this.showPopup();
                } else if (this.textWritten.compareTo("") != 0 && !JComboBoxConfigurableLookUp.this.hidePopupIfThereAreNoItems) {
                    JComboBoxConfigurableLookUp.this.showPopup();
                }
            } else {
                super.replace(offset, length, text, attrs);
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            JComboBoxConfigurableLookUp.this.hidePopup();
            this.updatedModel = true;
            String old_textWritten = this.textWritten;
            this.old_caretPosition = Math.min(((JTextComponent)this.comboBoxReference.getEditor().getEditorComponent()).getCaretPosition(), offs);
            this.textWritten = "";
            JComboBoxConfigurableLookUp.this.model.setTextWritten(this.textWritten);
            super.remove(0, old_textWritten.length());
            int itemsOrderFlag = JComboBoxConfigurableLookUp.this.model.getItemsOrder();
            boolean showAllItemsInListBox = JComboBoxConfigurableLookUp.this.model.isShowAllItemsInListBox();
            String languageRules = JComboBoxConfigurableLookUp.this.model.getLocaleRules();
            boolean caseSensitive = JComboBoxConfigurableLookUp.this.model.isCaseSensitive();
            ILookUp lookUpAgent = JComboBoxConfigurableLookUp.this.model.getLookUpAgent();
            this.comboBoxReference.setModel((ComboBoxModel)new DefaultComboBoxConfigurableLookUpModel(JComboBoxConfigurableLookUp.this.model.getData()));
            JComboBoxConfigurableLookUp.this.model.setItemsOrder(itemsOrderFlag);
            JComboBoxConfigurableLookUp.this.model.setShowAllItemsInListBox(showAllItemsInListBox);
            JComboBoxConfigurableLookUp.this.model.setLocaleRules(languageRules);
            JComboBoxConfigurableLookUp.this.model.setCaseSensitive(caseSensitive);
            JComboBoxConfigurableLookUp.this.model.setLookUpAgent(lookUpAgent);
            this.insertString(0, this.textWritten, null);
            this.textWritten = old_textWritten.substring(0, offs) + this.textOfReplacement + old_textWritten.substring(offs + len, old_textWritten.length());
            this.insertString(0, this.textWritten, null);
            this.updatedModel = false;
            this.updateTextColorAndRingBeep();
            if (JComboBoxConfigurableLookUp.this.model.getSize() > 0) {
                JComboBoxConfigurableLookUp.this.showPopup();
            } else if (this.textWritten.compareTo("") != 0 && !JComboBoxConfigurableLookUp.this.hidePopupIfThereAreNoItems) {
                JComboBoxConfigurableLookUp.this.showPopup();
            }
            this.updateCaretPosition(this.old_caretPosition + this.textOfReplacement.length());
            this.textOfReplacement = "";
        }

        public void updateTextColorAndRingBeep() {
            if (!this.comboBoxReference.isOnlyOneColorOnText()) {
                if (JComboBoxConfigurableLookUp.this.model.isShowAllItemsInListBox()) {
                    if (this.textWritten.compareTo("") != 0) {
                        if (JComboBoxConfigurableLookUp.this.model.getSelectedItem() == null) {
                            this.comboBoxReference.getEditor().getEditorComponent().setForeground(Color.RED);
                            this.textInRedColor = true;
                            if (JComboBoxConfigurableLookUp.this.beepEnabled) {
                                this.comboBoxReference.getToolkit().beep();
                            }
                        } else {
                            this.comboBoxReference.getEditor().getEditorComponent().setForeground(Color.BLACK);
                            this.textInRedColor = false;
                        }
                    } else if (this.textInRedColor) {
                        this.comboBoxReference.getEditor().getEditorComponent().setForeground(Color.BLACK);
                        this.textInRedColor = false;
                    }
                } else if (this.textWritten.compareTo("") != 0) {
                    if (JComboBoxConfigurableLookUp.this.model.getSize() == 0) {
                        this.comboBoxReference.getEditor().getEditorComponent().setForeground(Color.RED);
                        this.textInRedColor = true;
                        if (JComboBoxConfigurableLookUp.this.beepEnabled) {
                            this.comboBoxReference.getToolkit().beep();
                        }
                    } else {
                        this.comboBoxReference.getEditor().getEditorComponent().setForeground(Color.BLACK);
                        this.textInRedColor = false;
                    }
                } else if (this.textInRedColor) {
                    this.comboBoxReference.getEditor().getEditorComponent().setForeground(Color.BLACK);
                    this.textInRedColor = false;
                }
            } else if (this.textWritten.compareTo("") != 0 && JComboBoxConfigurableLookUp.this.model.getSize() == 0 && JComboBoxConfigurableLookUp.this.beepEnabled) {
                this.comboBoxReference.getToolkit().beep();
            }
        }

        public void updateCaretPosition(int position) {
            if (JComboBoxConfigurableLookUp.this.popupItemSelected) {
                ((JTextComponent)this.comboBoxReference.getEditor().getEditorComponent()).setCaretPosition(this.textWritten.length());
                JComboBoxConfigurableLookUp.this.popupItemSelected = false;
                return;
            }
            if (position > this.textWritten.length()) {
                ((JTextComponent)this.comboBoxReference.getEditor().getEditorComponent()).setCaretPosition(this.textWritten.length());
            } else {
                ((JTextComponent)this.comboBoxReference.getEditor().getEditorComponent()).setCaretPosition(position);
            }
        }

        public void updateOnlyTextColor() {
            boolean isBeepEnabled = JComboBoxConfigurableLookUp.this.isBeepEnabled();
            JComboBoxConfigurableLookUp.this.setBeepEnabled(false);
            this.updateTextColorAndRingBeep();
            JComboBoxConfigurableLookUp.this.setBeepEnabled(isBeepEnabled);
        }
    }
}

