/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.coordinatespanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.gui.beans.coordinatespanel.CoordinatesEvent;
import org.gvsig.gui.beans.coordinatespanel.CoordinatesListener;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;

public class CoordinatesPanel
extends JPanel
implements DataInputContainerListener {
    private static final long serialVersionUID = 3336324382874763427L;
    private String pathToImages = "images/";
    private ArrayList actionChangedListeners = new ArrayList();
    private JPanel pCoord = null;
    private JLabel lTitulo1 = null;
    private JLabel lTitulo2 = null;
    private DataInputContainer dataInputContainer11 = null;
    private DataInputContainer dataInputContainer12 = null;
    private DataInputContainer dataInputContainer21 = null;
    private DataInputContainer dataInputContainer22 = null;
    private int maximumFractionDigits = 3;

    public CoordinatesPanel(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
        this.initialize();
    }

    public CoordinatesPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPCoord(), "Center");
    }

    private JPanel getPCoord() {
        if (this.pCoord == null) {
            this.pCoord = new JPanel();
            this.pCoord.setLayout(new GridBagLayout());
            int y = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y;
            gridBagConstraints.insets = new Insets(5, 5, 2, 2);
            this.pCoord.add((Component)this.getLTitulo1(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 2, 2, 2);
            this.pCoord.add((Component)this.getDataInputContainer11(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 2, 2, 5);
            this.pCoord.add((Component)this.getDataInputContainer12(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y;
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
            this.pCoord.add((Component)this.getLTitulo2(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 5, 2);
            this.pCoord.add((Component)this.getDataInputContainer21(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 5, 5);
            this.pCoord.add((Component)this.getDataInputContainer22(), gridBagConstraints);
        }
        return this.pCoord;
    }

    private JLabel getLTitulo1() {
        if (this.lTitulo1 == null) {
            URL resource = this.getClass().getResource(this.pathToImages + "upleft.png");
            if (resource != null) {
                ImageIcon icon = new ImageIcon(resource);
                this.lTitulo1 = new JLabel(icon);
            } else {
                this.lTitulo1 = new JLabel();
            }
        }
        return this.lTitulo1;
    }

    private JLabel getLTitulo2() {
        if (this.lTitulo2 == null && this.lTitulo2 == null) {
            URL resource = this.getClass().getResource(this.pathToImages + "downright.png");
            if (resource != null) {
                ImageIcon icon = new ImageIcon(resource);
                this.lTitulo2 = new JLabel(icon);
            } else {
                this.lTitulo2 = new JLabel();
            }
        }
        return this.lTitulo2;
    }

    public DataInputContainer getDataInputContainer11() {
        if (this.dataInputContainer11 == null) {
            this.dataInputContainer11 = new DataInputContainer(this.maximumFractionDigits);
            this.dataInputContainer11.setLabelText("X");
            this.dataInputContainer11.addValueChangedListener(this);
        }
        return this.dataInputContainer11;
    }

    public DataInputContainer getDataInputContainer12() {
        if (this.dataInputContainer12 == null) {
            this.dataInputContainer12 = new DataInputContainer(this.maximumFractionDigits);
            this.dataInputContainer12.setLabelText("Y");
            this.dataInputContainer12.addValueChangedListener(this);
        }
        return this.dataInputContainer12;
    }

    public DataInputContainer getDataInputContainer21() {
        if (this.dataInputContainer21 == null) {
            this.dataInputContainer21 = new DataInputContainer(this.maximumFractionDigits);
            this.dataInputContainer21.setLabelText("X");
            this.dataInputContainer21.addValueChangedListener(this);
        }
        return this.dataInputContainer21;
    }

    public DataInputContainer getDataInputContainer22() {
        if (this.dataInputContainer22 == null) {
            this.dataInputContainer22 = new DataInputContainer(this.maximumFractionDigits);
            this.dataInputContainer22.setLabelText("Y");
            this.dataInputContainer22.addValueChangedListener(this);
        }
        return this.dataInputContainer22;
    }

    public void setTitlePanel(String titlePanel) {
        this.getPCoord().setBorder(BorderFactory.createTitledBorder(null, titlePanel, 0, 0, new Font("Dialog", 0, 12), null));
    }

    public String[] getValues() {
        String[] values = new String[]{this.getDataInputContainer11().getValue(), this.getDataInputContainer12().getValue(), this.getDataInputContainer21().getValue(), this.getDataInputContainer22().getValue()};
        return values;
    }

    public void setValues(String[] values) {
        this.getDataInputContainer11().setValue(values[0]);
        this.getDataInputContainer12().setValue(values[1]);
        this.getDataInputContainer21().setValue(values[2]);
        this.getDataInputContainer22().setValue(values[3]);
    }

    public void addValueChangedListener(CoordinatesListener listener) {
        if (!this.actionChangedListeners.contains(listener)) {
            this.actionChangedListeners.add(listener);
        }
    }

    public void removeValueChangedListener(CoordinatesListener listener) {
        this.actionChangedListeners.remove(listener);
    }

    private void callValueChangedListeners(String component) {
        for (CoordinatesListener listener : this.actionChangedListeners) {
            listener.actionValueChanged(new CoordinatesEvent(this, component));
        }
    }

    @Override
    public void actionValueChanged(EventObject e) {
        if (e.getSource() == this.getDataInputContainer11().getDataInputField()) {
            this.callValueChangedListeners("11");
            return;
        }
        if (e.getSource() == this.getDataInputContainer12().getDataInputField()) {
            this.callValueChangedListeners("12");
            return;
        }
        if (e.getSource() == this.getDataInputContainer21().getDataInputField()) {
            this.callValueChangedListeners("21");
            return;
        }
        if (e.getSource() == this.getDataInputContainer22().getDataInputField()) {
            this.callValueChangedListeners("22");
            return;
        }
    }

    public String getValue11() {
        return this.getDataInputContainer11().getValue();
    }

    public String getValue12() {
        return this.getDataInputContainer12().getValue();
    }

    public String getValue21() {
        return this.getDataInputContainer21().getValue();
    }

    public String getValue22() {
        return this.getDataInputContainer22().getValue();
    }

    public void setValue11(String value) {
        this.getDataInputContainer11().setValue(value);
    }

    public void setValue12(String value) {
        this.getDataInputContainer12().setValue(value);
    }

    public void setValue21(String value) {
        this.getDataInputContainer21().setValue(value);
    }

    public void setValue22(String value) {
        this.getDataInputContainer22().setValue(value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getPCoord().setEnabled(enabled);
        this.getLTitulo1().setEnabled(enabled);
        this.getLTitulo2().setEnabled(enabled);
        this.getDataInputContainer11().setControlEnabled(enabled);
        this.getDataInputContainer12().setControlEnabled(enabled);
        this.getDataInputContainer21().setControlEnabled(enabled);
        this.getDataInputContainer22().setControlEnabled(enabled);
    }
}

