/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.incrementabletask;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.incrementabletask.Cancel;
import org.gvsig.gui.beans.incrementabletask.Cancellable;
import org.gvsig.gui.beans.incrementabletask.IIncrementable;
import org.gvsig.gui.beans.incrementabletask.IncrementableEvent;
import org.gvsig.gui.beans.incrementabletask.IncrementableListener;
import org.gvsig.gui.beans.incrementabletask.IncrementableTask;
import org.gvsig.gui.beans.progresspanel.LogControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IncrementableProcess
implements IIncrementable,
IncrementableListener,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementableProcess.class);
    protected IncrementableTask iTask = null;
    protected LogControl log = new LogControl();
    protected int percentage = 0;
    protected boolean ended = false;
    protected volatile boolean threadSuspended = false;
    protected volatile Thread blinker = null;
    protected long t0 = 0L;
    protected static Cancellable cancelProcess = null;
    protected boolean isCancellable = true;
    protected boolean isPausable = false;
    protected String title = "";
    protected String label = "";

    public IncrementableProcess(String title) {
        this.title = title;
        cancelProcess = new Cancel();
    }

    public IncrementableProcess(String title, String label) {
        this.title = title;
        this.label = label;
        cancelProcess = new Cancel();
    }

    public IncrementableProcess(String title, String label, boolean cancellable, boolean pausable) {
        this.title = title;
        this.label = label;
        cancelProcess = new Cancel();
        this.isCancellable = cancellable;
        this.isPausable = pausable;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected void insertLineLog(String line) {
        this.log.addLine(line);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLog() {
        return this.log.getText();
    }

    @Override
    public int getPercent() {
        if (this.percentage > 100) {
            this.percentage = 100;
        }
        if (this.percentage == 100) {
            this.ended = true;
        }
        return this.percentage;
    }

    public void start() {
        this.blinker = new Thread(this);
        this.blinker.start();
    }

    public synchronized void stop() {
        this.ended = true;
        this.blinker = null;
        this.notify();
    }

    public boolean isAlive() {
        return this.blinker.isAlive();
    }

    protected void processFinalize() {
        this.iTask.processFinalize();
    }

    public void setIncrementableTask(IncrementableTask iTask) {
        this.iTask = iTask;
        iTask.setAskCancel(true);
        iTask.getButtonsPanel().addAccept();
        iTask.getButtonsPanel().setEnabled(1, false);
        JButton jButton = iTask.getButtonsPanel().getButton(1);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IncrementableProcess.this.processFinalize();
            }
        });
    }

    public boolean isSuspended() {
        return this.threadSuspended;
    }

    @Override
    public void run() {
        String text = null;
        try {
            this.process();
            while (!this.ended) {
                this.t0 += 500L;
                Thread.currentThread();
                Thread.sleep(150L);
            }
        }
        catch (Exception ie) {
            if (!cancelProcess.isCanceled()) {
                LOG.error("", (Throwable)ie);
                this.label = Messages.getText("Process_failed");
                this.iTask.getProgressPanel().setLabel(this.label);
                text = Messages.getText("Failed_the_process");
            } else {
                this.label = Messages.getText("Process_canceled");
                this.iTask.getProgressPanel().setLabel(this.label);
                text = Messages.getText("Process_canceled");
            }
        }
        finally {
            this.iTask.setAskCancel(false);
            this.iTask.getButtonsPanel().setEnabled(1, true);
            this.iTask.getButtonsPanel().setEnabled(2, false);
            if (text != null) {
                this.log.addLine(Messages.getText("Percent") + ": " + this.getPercent());
                this.log.addLine(text);
                if (cancelProcess.isCanceled()) {
                    JOptionPane.showMessageDialog(this.iTask.getButtonsPanel(), text, Messages.getText("Information"), 1);
                } else {
                    JOptionPane.showMessageDialog(this.iTask.getButtonsPanel(), text, Messages.getText("Error"), 0);
                }
            }
            if (this.percentage == 100) {
                this.label = Messages.getText("Process_finished");
                this.iTask.getProgressPanel().setLabel(this.label);
            }
            this.ended = true;
            this.iTask.stop();
        }
    }

    @Override
    public void actionCanceled(IncrementableEvent e) {
        if (this.percentage < 100) {
            if (this.ended) {
                this.processFinalize();
            }
            if (this.isCancellable) {
                cancelProcess.setCanceled(true);
            } else {
                JOptionPane.showMessageDialog(null, Messages.getText("The_process_cant_be_cancelled"), Messages.getText("Warning"), 2);
            }
        } else {
            LOG.warn(Messages.getText("Process_finished_wont_be_cancelled"));
            this.processFinalize();
        }
    }

    @Override
    public void actionResumed(IncrementableEvent e) {
        if (this.isPausable && this.threadSuspended) {
            this.threadSuspended = false;
            this.blinker.resume();
        }
    }

    @Override
    public void actionSuspended(IncrementableEvent e) {
        try {
            if (this.isPausable) {
                if (!this.threadSuspended) {
                    this.threadSuspended = true;
                    this.blinker.suspend();
                }
            } else {
                JOptionPane.showMessageDialog(null, Messages.getText("The_process_cant_be_paused"), Messages.getText("Warning"), 2);
            }
        }
        catch (Exception iex) {
            LOG.error("", (Throwable)iex);
            JOptionPane.showMessageDialog(null, Messages.getText("Failed_pausing_the_process"), Messages.getText("Error"), 0);
        }
    }

    @Override
    public boolean isCancelable() {
        return this.isCancellable;
    }

    public void setCancelable(boolean b) {
        this.isCancellable = b;
    }

    @Override
    public boolean isPausable() {
        return this.isPausable;
    }

    public void setPausable(boolean b) {
        this.isPausable = b;
    }

    public abstract void process() throws InterruptedException, Exception;
}

