/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.incrementabletask;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanel;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.incrementabletask.IIncrementable;
import org.gvsig.gui.beans.incrementabletask.IncrementableEvent;
import org.gvsig.gui.beans.incrementabletask.IncrementableListener;
import org.gvsig.gui.beans.progresspanel.ProgressPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementableTask
implements Runnable,
ButtonsPanelListener {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementableTask.class);
    IIncrementable iIncrementable = null;
    private volatile ProgressPanel progressPanel = null;
    private volatile Thread blinker = null;
    private boolean threadSuspended = false;
    private boolean ended = false;
    private boolean askOnCancel = true;
    private ArrayList<IncrementableListener> actionCommandListeners = new ArrayList();
    private boolean bDoCallListeners = true;
    private static int eventId = Integer.MIN_VALUE;

    public IncrementableTask(IIncrementable incrementable, ProgressPanel dialog) {
        this.iIncrementable = incrementable;
        this.progressPanel = dialog;
        this.configureProgressPanel();
    }

    public IncrementableTask(IIncrementable incrementable) {
        this.iIncrementable = incrementable;
        this.configureProgressPanel();
    }

    public void start() {
        this.blinker = new Thread(this);
        this.blinker.start();
    }

    public void stop() {
        this.ended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (!this.ended) {
            try {
                this.getProgressPanel().setLabel(this.iIncrementable.getLabel());
                this.getProgressPanel().setPercent(this.iIncrementable.getPercent());
                this.getProgressPanel().setTitle(this.iIncrementable.getTitle());
                this.getProgressPanel().setLog(this.iIncrementable.getLog());
                Thread.sleep(100L);
                IncrementableTask incrementableTask = this;
                synchronized (incrementableTask) {
                    while (this.threadSuspended && !this.ended) {
                        this.wait(500L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.getProgressPanel().setLog(this.iIncrementable.getLog());
    }

    public void processFinalize() {
        this.stop();
        while (this.isAlive()) {
        }
        this.hide();
    }

    private void hide() {
        this.hideWindow();
        this.progressPanel = null;
        this.blinker = null;
    }

    public void hideWindow() {
        this.getProgressPanel().setVisible(false);
    }

    public boolean isAlive() {
        if (this.blinker == null) {
            return false;
        }
        return this.blinker.isAlive();
    }

    public void showWindow() {
        this.getProgressPanel().setTitle(this.iIncrementable.getTitle());
        this.getProgressPanel().showLog(false);
        this.getProgressPanel().setVisible(true);
    }

    public ProgressPanel getProgressPanel() {
        if (this.progressPanel == null) {
            this.progressPanel = new ProgressPanel(false);
        }
        return this.progressPanel;
    }

    protected void configureProgressPanel() {
        this.getProgressPanel().setAlwaysOnTop(true);
        this.getProgressPanel().addButtonPressedListener(this);
        this.getProgressPanel().setDefaultCloseOperation(0);
        this.getProgressPanel().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IncrementableTask.this.actionButtonPressed(new ButtonsPanelEvent(IncrementableTask.this.getProgressPanel(), 2));
            }
        });
    }

    private void callActionCommandListeners(int actions) {
        if (!this.bDoCallListeners) {
            return;
        }
        for (IncrementableListener listener : this.actionCommandListeners) {
            switch (actions) {
                case 1: {
                    listener.actionResumed(new IncrementableEvent(this));
                    break;
                }
                case 2: {
                    listener.actionSuspended(new IncrementableEvent(this));
                    break;
                }
                case 3: {
                    listener.actionCanceled(new IncrementableEvent(this));
                }
            }
        }
        ++eventId;
    }

    public void addIncrementableListener(IncrementableListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeIncrementableListener(IncrementableListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    public void setAskCancel(boolean value) {
        this.askOnCancel = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionButtonPressed(ButtonsPanelEvent e) {
        switch (e.getButton()) {
            case 2: {
                cancelled = true;
                if (!this.askOnCancel) ** GOTO lbl40
                if (!this.iIncrementable.isCancelable()) {
                    JOptionPane.showMessageDialog(null, Messages.getText("The_process_cant_be_cancelled"), Messages.getText("Information"), 1);
                    return;
                }
                if (this.iIncrementable.isPausable()) {
                    try {
                        this.callActionCommandListeners(2);
                    }
                    catch (Exception iex) {
                        IncrementableTask.LOG.error("", (Throwable)iex);
                        JOptionPane.showMessageDialog(null, Messages.getText("Failed_pausing_the_process"), Messages.getText("Error"), 0);
                    }
                }
                cancelled = false;
                string1 = Messages.getText("Yes");
                string2 = Messages.getText("No");
                options = new Object[]{string1, string2};
                answer = JOptionPane.showOptionDialog(this.getProgressPanel(), Messages.getText("msg_cancel_incrementable"), Messages.getText("title_cancel_incrementable"), 0, 3, null, options, string1);
                if (answer != 0) ** GOTO lbl32
                cancelled = true;
                try {
                    if (this.iIncrementable.isPausable()) {
                        this.callActionCommandListeners(1);
                    }
                    ** GOTO lbl40
                }
                catch (Exception e2) {
                    IncrementableTask.LOG.error("", (Throwable)e2);
                    Messages.getText("Failed_resuming_the_process");
                }
                ** GOTO lbl40
lbl32:
                // 1 sources

                try {
                    if (this.iIncrementable.isPausable()) {
                        this.callActionCommandListeners(1);
                    }
                }
                catch (Exception e2) {
                    IncrementableTask.LOG.error("", (Throwable)e2);
                    Messages.getText("Failed_resuming_the_process");
                }
lbl40:
                // 6 sources

                if (!cancelled) break;
                this.callActionCommandListeners(3);
                break;
            }
            case 10: {
                this.threadSuspended = true;
                try {
                    if (!this.iIncrementable.isPausable()) {
                        JOptionPane.showMessageDialog(null, Messages.getText("The_process_cant_be_paused"), Messages.getText("Information"), 1);
                        break;
                    }
                    this.callActionCommandListeners(2);
                }
                catch (Exception iex) {
                    IncrementableTask.LOG.error("", (Throwable)iex);
                    JOptionPane.showMessageDialog(null, Messages.getText("Failed_pausing_the_process"), Messages.getText("Error"), 0);
                }
                break;
            }
            case 11: {
                this.threadSuspended = false;
                this.callActionCommandListeners(1);
            }
        }
    }

    public ButtonsPanel getButtonsPanel() {
        return this.getProgressPanel().getButtonsPanel();
    }
}

