/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.listview.painters;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import org.gvsig.gui.beans.listview.IListViewPainter;
import org.gvsig.gui.beans.listview.ListViewItem;
import org.gvsig.i18n.Messages;

public class PaintList
implements IListViewPainter {
    ArrayList items = null;
    int iconsWidth = 35;
    int minIconsWidth = 35;
    Dimension lastDimension = new Dimension(0, 0);

    public PaintList(ArrayList items) {
        this.items = items;
    }

    @Override
    public String getName() {
        return Messages.getText((String)"list");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.lastDimension;
    }

    @Override
    public void paint(Graphics2D g, Rectangle visibleRect) {
        FontMetrics fm = g.getFontMetrics();
        int minAux = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            int auxWidth = g.getFontMetrics().stringWidth(((ListViewItem)this.items.get(i)).getName()) + 8;
            if (minAux >= auxWidth) continue;
            minAux = auxWidth;
        }
        if ((minAux = visibleRect.width - minAux) < this.minIconsWidth) {
            minAux = this.minIconsWidth;
        }
        this.iconsWidth = minAux;
        int height2 = 0;
        int width2 = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            ((ListViewItem)this.items.get(i)).setNameRectangle(null);
            int auxWidth = g.getFontMetrics().stringWidth(((ListViewItem)this.items.get(i)).getName());
            if (this.minIconsWidth + 3 + auxWidth - visibleRect.x > visibleRect.width) {
                ((ListViewItem)this.items.get(i)).setShowTooltip(true);
            } else {
                ((ListViewItem)this.items.get(i)).setShowTooltip(false);
            }
            if (width2 < auxWidth) {
                width2 = auxWidth;
            }
            ((ListViewItem)this.items.get(i)).getItemRectangle().setBounds(visibleRect.x, i * 17, visibleRect.width, 17);
            if (!((ListViewItem)this.items.get(i)).getItemRectangle().intersects(visibleRect)) continue;
            int upper = fm.getLeading() + fm.getAscent() + (17 - fm.getHeight()) / 2;
            if (((ListViewItem)this.items.get(i)).isSelected()) {
                Color color1 = new Color(89, 153, 229);
                Color color2 = new Color(31, 92, 207);
                g.setPaint(new GradientPaint(0.0f, i * 17 + 1, color1, 0.0f, i * 17 + 16, color2, false));
                g.fillRect(visibleRect.x, i * 17 + 1, visibleRect.width, 16);
                g.setColor(new Color(61, 123, 218));
                g.drawLine(visibleRect.x, i * 17, visibleRect.x + visibleRect.width, i * 17);
                g.setColor(Color.white);
            } else {
                g.setColor(Color.black);
            }
            g.drawString(((ListViewItem)this.items.get(i)).getName(), this.iconsWidth + 3, i * 17 + upper);
            ((ListViewItem)this.items.get(i)).setNameRectangle(new Rectangle(this.iconsWidth + 2, i * 17 - 1, visibleRect.width - (this.iconsWidth + 2), 20));
            Shape clip = g.getClip();
            g.translate(1, i * 17 + 1);
            g.setClip(0, 0, this.iconsWidth, 15);
            if (((ListViewItem)this.items.get(i)).getIcon() != null) {
                ((ListViewItem)this.items.get(i)).getIcon().paint(g, ((ListViewItem)this.items.get(i)).isSelected());
            }
            g.setClip(clip);
            g.translate(-1, -(i * 17 + 1));
        }
        height2 = this.items.size() * 17;
        this.lastDimension = new Dimension(this.minIconsWidth + 3 + width2, height2);
    }
}

