/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.textBoxWithCalendar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.freixas.jcalendar.JCalendarCombo;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.controls.MultiLineToolTip;
import org.gvsig.gui.beans.swing.textBoxWithCalendar.IMethodsForGraphicalCalendarComponents;

public class JCalendarCDatePanel
extends JPanel
implements IMethodsForGraphicalCalendarComponents,
Serializable {
    private static final long serialVersionUID = -1698696825218186886L;
    private final int defaultWidth = 120;
    private final int defaultHeight = 19;
    private JCalendarCombo calendar = null;

    public JCalendarCDatePanel() {
        try {
            this.setPreferredSize(new Dimension(120, 19));
            this.setLayout(new BorderLayout());
            this.add((Component)this.getJCalendarCombo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JCalendarCDatePanel(int width, int height) {
        try {
            this.setPreferredSize(new Dimension(width, height));
            this.setLayout(new BorderLayout());
            this.add((Component)this.getJCalendarCombo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JCalendarCombo getJCalendarCombo() {
        if (this.calendar == null) {
            this.calendar = new JCalendarCombo(Calendar.getInstance(), Locale.getDefault(), 1, true);
            this.calendar.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
            this.calendar.setEditable(false);
            this.calendar.setBackground(Color.WHITE);
            this.calendar.setToolTipText(Messages.getText("calendarSelectDate"));
            this.calendar.setToolTipTextToMonthDecrButton(Messages.getText("calendarBackOneMonth"));
            this.calendar.setToolTipTextToMonthIncrButton(Messages.getText("calendarForwardOneMonth"));
            this.calendar.setToolTipTextToYearDecrButton(Messages.getText("calendarBackOneYear"));
            this.calendar.setToolTipTextToYearIncrButton(Messages.getText("calendarForwardOneYear"));
        }
        return this.calendar;
    }

    public void setPreferredSizeResize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.calendar.setPreferredSize(new Dimension(width, height));
        this.calendar.setSize(new Dimension(width, height));
        this.revalidate();
    }

    @Override
    public void setDate(Date date) {
        this.calendar.setDate(date);
    }

    @Override
    public Date getDate() {
        return this.calendar.getDate();
    }

    public void enableCalendar() {
        this.calendar.setEnabled(true);
    }

    public void disableCalendar() {
        this.calendar.setEnabled(false);
    }

    @Override
    public String getFormattedDate() {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(this.getDate());
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }
}

