/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTreeCellRenderer;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxTree
extends JTree {
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    public static final String PROPERTY_DIG_IN = "digIn";
    protected CheckBoxTreeCellRenderer _treeCellRenderer;
    private CheckBoxTreeSelectionModel _checkBoxTreeSelectionModel;
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;
    private PropertyChangeListener _modelChangeListener;
    private TristateCheckBox _checkBox;
    private boolean _selectPartialOnToggling = true;
    private TreeCellRenderer _defaultRenderer;

    public CheckBoxTree() {
        this.init();
    }

    public CheckBoxTree(Object[] value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(Vector<?> value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(Hashtable<?, ?> value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(TreeNode root) {
        super(root);
        this.init();
    }

    public CheckBoxTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public CheckBoxTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    protected void init() {
        this._checkBoxTreeSelectionModel = this.createCheckBoxTreeSelectionModel(this.getModel());
        this._checkBoxTreeSelectionModel.setTree(this);
        Handler handler = this.createHandler();
        JideSwingUtilities.insertMouseListener(this, handler, 0);
        this.addKeyListener(handler);
        this._checkBoxTreeSelectionModel.addTreeSelectionListener(handler);
        if (this._modelChangeListener == null) {
            this._modelChangeListener = new ModelPropertyChangeListener();
        }
        this.addPropertyChangeListener("selectionModel", this._modelChangeListener);
        this.addPropertyChangeListener("model", this._modelChangeListener);
        this.updateRowMapper();
    }

    protected CheckBoxTreeSelectionModel createCheckBoxTreeSelectionModel(TreeModel model) {
        return new CheckBoxTreeSelectionModel(model);
    }

    private void updateRowMapper() {
        this._checkBoxTreeSelectionModel.setRowMapper(this.getSelectionModel().getRowMapper());
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        TreeCellRenderer cellRenderer = this.getActualCellRenderer();
        if (cellRenderer == null) {
            cellRenderer = this.getDefaultRenderer();
        }
        if (this._treeCellRenderer == null) {
            this._treeCellRenderer = this.createCellRenderer(cellRenderer);
        } else {
            this._treeCellRenderer.setActualTreeRenderer(cellRenderer);
        }
        return this._treeCellRenderer;
    }

    private TreeCellRenderer getDefaultRenderer() {
        if (this._defaultRenderer == null) {
            this._defaultRenderer = new DefaultTreeCellRenderer();
        }
        return this._defaultRenderer;
    }

    public TreeCellRenderer getActualCellRenderer() {
        if (this._treeCellRenderer != null) {
            return this._treeCellRenderer.getActualTreeRenderer();
        }
        return super.getCellRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer x) {
        if (x == null) {
            x = this.getDefaultRenderer();
        }
        super.setCellRenderer(x);
        if (this._treeCellRenderer != null) {
            this._treeCellRenderer.setActualTreeRenderer(x);
        }
    }

    protected CheckBoxTreeCellRenderer createCellRenderer(TreeCellRenderer renderer) {
        CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = new CheckBoxTreeCellRenderer(renderer, this.getCheckBox());
        this.addPropertyChangeListener("cellRenderer", new CellRendererPropertyChangeListener(checkBoxTreeCellRenderer));
        return checkBoxTreeCellRenderer;
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public TristateCheckBox getCheckBox() {
        return this._checkBox;
    }

    public void setCheckBox(TristateCheckBox checkBox) {
        if (this._checkBox != checkBox) {
            this._checkBox = checkBox;
            this._treeCellRenderer = null;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isSelectPartialOnToggling() {
        return this._selectPartialOnToggling || this.selectionModel.getClass().getName().contains("Filter");
    }

    public void setSelectPartialOnToggling(boolean selectPartialOnToggling) {
        this._selectPartialOnToggling = selectPartialOnToggling;
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    public CheckBoxTreeSelectionModel getCheckBoxTreeSelectionModel() {
        return this._checkBoxTreeSelectionModel;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean checkBoxEnabled) {
        if (checkBoxEnabled != this._checkBoxEnabled) {
            Boolean oldValue = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newValue = checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = checkBoxEnabled;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, oldValue, newValue);
            this.repaint();
        }
    }

    public boolean isCheckBoxEnabled(TreePath path) {
        return true;
    }

    public boolean isCheckBoxVisible(TreePath path) {
        return true;
    }

    public boolean isDigIn() {
        return this.getCheckBoxTreeSelectionModel().isDigIn();
    }

    public void setDigIn(boolean digIn) {
        boolean old = this.isDigIn();
        if (old != digIn) {
            this.getCheckBoxTreeSelectionModel().setDigIn(digIn);
            this.firePropertyChange(PROPERTY_DIG_IN, old, digIn);
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean clickInCheckBoxOnly) {
        if (clickInCheckBoxOnly != this._clickInCheckBoxOnly) {
            boolean old = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = clickInCheckBoxOnly;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, old, this._clickInCheckBoxOnly);
        }
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    TreeSelectionListener {
        protected CheckBoxTree _tree;
        int _hotspot;
        private int _toggleCount;

        public Handler(CheckBoxTree tree) {
            this._hotspot = new JCheckBox().getPreferredSize().width;
            this._toggleCount = -1;
            this._tree = tree;
        }

        protected TreePath getTreePathForMouseEvent(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return null;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return null;
            }
            TreePath path = this._tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return null;
            }
            if (this.clicksInCheckBox(e, path) || !this._tree.isClickInCheckBoxOnly()) {
                return path;
            }
            return null;
        }

        protected boolean clicksInCheckBox(MouseEvent e, TreePath path) {
            if (!this._tree.isCheckBoxVisible(path)) {
                return false;
            }
            Rectangle bounds = this._tree.getPathBounds(path);
            if (this._tree.getComponentOrientation().isLeftToRight()) {
                return e.getX() < bounds.x + this._hotspot;
            }
            return e.getX() > bounds.x + bounds.width - this._hotspot;
        }

        private TreePath preventToggleEvent(MouseEvent e) {
            int toggleCount;
            TreePath pathForMouseEvent = this.getTreePathForMouseEvent(e);
            if (pathForMouseEvent != null && (toggleCount = this._tree.getToggleClickCount()) != -1) {
                this._toggleCount = toggleCount;
                this._tree.setToggleClickCount(-1);
            }
            return pathForMouseEvent;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.preventToggleEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            TreePath path = this.preventToggleEvent(e);
            if (path != null) {
                JTree tree;
                this.toggleSelections(new TreePath[]{path});
                Object source = e.getSource();
                if (source instanceof JTree && !(tree = (JTree)source).hasFocus() && tree.isFocusable() && tree.isRequestFocusEnabled()) {
                    tree.requestFocusInWindow();
                }
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            TreePath path = this.preventToggleEvent(e);
            if (path != null) {
                e.consume();
            }
            if (this._toggleCount != -1) {
                this._tree.setToggleClickCount(this._toggleCount);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return;
            }
            if (e.getModifiers() == 0 && e.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void valueChanged(TreeSelectionEvent e) {
            this._tree.treeDidChange();
        }

        protected void toggleSelections() {
            TreePath[] treePaths = this._tree.getSelectionPaths();
            this.toggleSelections(treePaths);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleSelections(TreePath[] treePaths) {
            if (treePaths == null || treePaths.length == 0 || !this._tree.isEnabled()) {
                return;
            }
            CheckBoxTreeSelectionModel selectionModel = this._tree.getCheckBoxTreeSelectionModel();
            ArrayList<TreePath> pathToAdded = new ArrayList<TreePath>();
            ArrayList<TreePath> pathToRemoved = new ArrayList<TreePath>();
            for (TreePath treePath : treePaths) {
                if (!this._tree.isCheckBoxEnabled(treePath)) continue;
                boolean selected = selectionModel.isPathSelected(treePath, selectionModel.isDigIn());
                if (selected) {
                    pathToRemoved.add(treePath);
                    continue;
                }
                if (!this._tree.isSelectPartialOnToggling() && selectionModel.isPartiallySelected(treePath)) {
                    TreePath[] selectionPaths = selectionModel.getSelectionPaths();
                    if (selectionPaths == null) continue;
                    for (TreePath selectionPath : selectionPaths) {
                        if (!selectionModel.isDescendant(selectionPath, treePath)) continue;
                        pathToRemoved.add(selectionPath);
                    }
                    continue;
                }
                pathToAdded.add(treePath);
            }
            selectionModel.removeTreeSelectionListener(this);
            try {
                if (pathToAdded.size() > 0) {
                    selectionModel.addSelectionPaths(pathToAdded.toArray(new TreePath[pathToAdded.size()]));
                }
                if (pathToRemoved.size() > 0) {
                    selectionModel.removeSelectionPaths(pathToRemoved.toArray(new TreePath[pathToRemoved.size()]));
                }
            }
            finally {
                selectionModel.addTreeSelectionListener(this);
                this._tree.treeDidChange();
            }
        }
    }

    private class CellRendererPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -5127656346976320157L;
        private CheckBoxTreeCellRenderer _checkBoxTreeCellRenderer;

        public CellRendererPropertyChangeListener(CheckBoxTreeCellRenderer renderer) {
            this._checkBoxTreeCellRenderer = renderer;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TreeCellRenderer treeCellRenderer = (TreeCellRenderer)evt.getNewValue();
            if (treeCellRenderer != this._checkBoxTreeCellRenderer) {
                this._checkBoxTreeCellRenderer.setActualTreeRenderer(treeCellRenderer);
            } else {
                this._checkBoxTreeCellRenderer.setActualTreeRenderer(null);
            }
        }
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 521336220746879977L;

        private ModelPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectionModel".equals(evt.getPropertyName())) {
                CheckBoxTree.this.updateRowMapper();
            }
            if ("model".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TreeModel) {
                CheckBoxTree.this._checkBoxTreeSelectionModel.setModel((TreeModel)evt.getNewValue());
            }
        }
    }
}

