/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.util;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.swingbox.util.CSSBoxAnalyzer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DefaultAnalyzer
implements CSSBoxAnalyzer {
    protected Document w3cdoc;
    protected BrowserCanvas canvas;

    @Override
    public Viewport analyze(DocumentSource docSource, Dimension dim) throws Exception {
        DefaultDOMSource parser = new DefaultDOMSource(docSource);
        this.w3cdoc = parser.parse();
        DOMAnalyzer da = new DOMAnalyzer(this.w3cdoc, docSource.getURL());
        da.attributesToStyles();
        da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.getStyleSheets();
        BufferedImage tmpImg = new BufferedImage(1, 1, 1);
        this.canvas = new BrowserCanvas(da.getRoot(), da, docSource.getURL());
        this.canvas.setImage(tmpImg);
        this.canvas.getConfig().setLoadImages(true);
        this.canvas.getConfig().setLoadBackgroundImages(true);
        this.canvas.createLayout(dim);
        return this.canvas.getViewport();
    }

    @Override
    public Viewport update(Dimension dim) throws Exception {
        this.canvas.createLayout(dim);
        return this.canvas.getViewport();
    }

    @Override
    public Document getDocument() {
        return this.w3cdoc;
    }

    @Override
    public String getDocumentTitle() {
        NodeList titles = this.w3cdoc.getElementsByTagName("title");
        if (titles.getLength() > 0) {
            return titles.item(0).getTextContent();
        }
        return null;
    }
}

