/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.view;

import cz.vutbr.web.css.CSSProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.swingbox.util.Anchor;
import org.fit.cssbox.swingbox.view.CSSBoxView;
import org.w3c.dom.Element;

public class TextBoxView
extends View
implements CSSBoxView {
    private TextBox box;
    private Font font;
    private Color foreground;
    private List<CSSProperty.TextDecoration> textDecoration;
    private String fontVariant;
    private TextLayout layout;
    private AffineTransform transform;
    private int order;
    private AttributeSet attributes;
    private boolean refreshAttributes;
    private boolean refreshProperties;
    private boolean refreshTextLayout;
    private boolean underline;
    private boolean strike;
    private boolean overline;
    private Container container;
    private Anchor anchor;

    public TextBoxView(javax.swing.text.Element elem) {
        super(elem);
        AttributeSet tmpAttr = elem.getAttributes();
        Object obj = tmpAttr.getAttribute("attribute_box_reference");
        this.anchor = (Anchor)tmpAttr.getAttribute("attribute_anchor_reference");
        Integer i = (Integer)tmpAttr.getAttribute("attribute_drawing_order");
        int n = this.order = i == null ? -1 : i;
        if (!(obj instanceof TextBox)) {
            throw new IllegalArgumentException("Box reference is not an instance of TextBox");
        }
        this.box = (TextBox)obj;
        if (this.box.getNode() != null && this.box.getNode().getParentNode() instanceof Element) {
            Element pelem = Anchor.findAnchorElement((Element)this.box.getNode().getParentNode());
            Map<String, String> elementAttributes = this.anchor.getProperties();
            if (pelem != null) {
                this.anchor.setActive(true);
                elementAttributes.put("a_href", pelem.getAttribute("href"));
                elementAttributes.put("a_name", pelem.getAttribute("name"));
                elementAttributes.put("a_title", pelem.getAttribute("title"));
                String target = pelem.getAttribute("target");
                if ("".equals(target)) {
                    target = "_self";
                }
                elementAttributes.put("a_target", target);
            } else {
                this.anchor.setActive(false);
                elementAttributes.clear();
            }
        }
    }

    @Override
    public int getDrawingOrder() {
        return this.order;
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.transform = new AffineTransform();
            this.setPropertiesFromAttributes(this.getElement().getAttributes());
            this.refreshAttributes = true;
            this.refreshProperties = false;
            this.container = this.getContainer();
        } else {
            this.anchor = null;
            this.transform = null;
            this.container = null;
        }
    }

    @Override
    public View createFragment(int p0, int p1) {
        return this;
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.invalidateProperties();
        this.syncProperties();
        this.invalidateTextLayout();
        super.changedUpdate(e, a, f);
    }

    @Override
    public float getMaximumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 0: {
                return 10.0f;
            }
            case 1: {
                return 10.0f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public boolean isVisible() {
        return this.box.isVisible();
    }

    @Override
    public int getResizeWeight(int axis) {
        return 0;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        TextLayout layout = this.getTextLayout();
        int offs = pos - this.getStartOffset();
        Rectangle alloc = new Rectangle(TextBoxView.toRect(a));
        TextHitInfo hit = b == Position.Bias.Forward ? TextHitInfo.afterOffset(offs) : TextHitInfo.beforeOffset(offs);
        float[] locs = layout.getCaretInfo(hit);
        alloc.setRect(alloc.getX() + (double)locs[0], alloc.getY(), 1.0, alloc.getHeight());
        return alloc;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        Rectangle alloc = TextBoxView.toRect(a);
        TextLayout layout = this.getTextLayout();
        TextHitInfo hit = layout.hitTestChar(x - (float)alloc.getX(), 0.0f);
        int pos = hit.getInsertionIndex();
        biasReturn[0] = hit.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
        return pos + this.getStartOffset();
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.refreshAttributes) {
            this.attributes = this.createAttributes();
            this.refreshAttributes = false;
            this.refreshProperties = false;
        }
        return this.attributes;
    }

    private AttributeSet createAttributes() {
        SimpleAttributeSet res = new SimpleAttributeSet();
        res.addAttribute("attribute_box_reference", this.box);
        res.addAttribute("attribute_anchor_reference", this.anchor);
        res.addAttribute("attribute_font_variant", this.fontVariant);
        res.addAttribute("attribute_text_decoration", this.textDecoration);
        res.addAttribute("attribute_font", this.font);
        res.addAttribute("attribute_foreground", this.foreground);
        return res;
    }

    @Override
    public String getToolTipText(float x, float y, Shape allocation) {
        if (this.anchor.isActive()) {
            Map<String, String> elementAttributes = this.anchor.getProperties();
            String val = "";
            String tmp = elementAttributes.get("a_title");
            if (tmp != null && !"".equals(tmp)) {
                val = val + "<i>" + tmp + "</i><br>";
            }
            if ((tmp = elementAttributes.get("a_href")) != null && !"".equals(tmp)) {
                val = val + tmp;
            }
            return "".equals(val) ? null : "<html>" + val + "</html>";
        }
        return null;
    }

    @Override
    public void paint(Graphics gg, Shape a) {
        if (this.isVisible()) {
            this.processPaint(gg, a);
        }
    }

    protected void processPaint(Graphics gg, Shape a) {
        Graphics2D g = (Graphics2D)gg;
        AffineTransform tmpTransform = g.getTransform();
        if (!tmpTransform.equals(this.transform)) {
            this.transform = tmpTransform;
            this.invalidateTextLayout();
        }
        Container c = this.container;
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        Color fg = this.getForeground();
        if (c instanceof JTextComponent) {
            Highlighter highLighter;
            JTextComponent tc = (JTextComponent)c;
            if (!tc.isEnabled()) {
                fg = tc.getDisabledTextColor();
            }
            if ((highLighter = tc.getHighlighter()) instanceof LayeredHighlighter) {
                ((LayeredHighlighter)highLighter).paintLayeredHighlights(g, p0, p1, this.box.getAbsoluteContentBounds(), tc, this);
            }
        }
        if (!this.box.isEmpty() && !this.getText().isEmpty()) {
            this.renderContent(g, a, fg, p0, p1);
        }
    }

    protected void renderContent(Graphics2D g, Shape a, Color fg, int p0, int p1) {
        TextLayout layout = this.getTextLayout();
        Rectangle absoluteBounds = this.box.getAbsoluteBounds();
        Rectangle absoluteContentBounds = this.box.getAbsoluteContentBounds();
        int pStart = this.getStartOffset();
        int pEnd = this.getEndOffset();
        int x = absoluteBounds.x;
        int y = absoluteBounds.y;
        Shape oldclip = g.getClip();
        BlockBox clipblock = this.box.getClipBlock();
        if (clipblock != null) {
            Rectangle newclip = clipblock.getClippedContentBounds();
            Rectangle clip = TextBoxView.toRect(oldclip).intersection(newclip);
            g.setClip(clip);
        }
        g.setFont(this.getFont());
        g.setColor(fg);
        if (p0 > pStart || p1 < pEnd) {
            try {
                Shape s = this.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, a);
                absoluteContentBounds = absoluteContentBounds.intersection(TextBoxView.toRect(s));
            }
            catch (BadLocationException ignored) {
                // empty catch block
            }
        }
        layout.draw(g, x, (float)y + layout.getAscent());
        if (this.underline || this.strike || this.overline) {
            int yy;
            Stroke origStroke = g.getStroke();
            int w = this.getFont().isBold() ? this.getFont().getSize() / 8 : this.getFont().getSize() / 10;
            if (w < 1) {
                w = 1;
            }
            y += w / 2;
            g.setStroke(new BasicStroke(w));
            int xx = absoluteContentBounds.x + absoluteContentBounds.width;
            if (this.overline) {
                g.drawLine(absoluteContentBounds.x, y, xx, y);
            }
            if (this.underline) {
                yy = y + absoluteContentBounds.height - (int)layout.getDescent();
                g.drawLine(absoluteContentBounds.x, yy, xx, yy);
            }
            if (this.strike) {
                yy = y + absoluteContentBounds.height / 2;
                g.drawLine(absoluteContentBounds.x, yy, xx, yy);
            }
            g.setStroke(origStroke);
        }
        g.setClip(oldclip);
    }

    protected void repaint(int ms, Rectangle bounds) {
        if (this.container != null) {
            this.container.repaint(ms, bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    protected Rectangle2D getStringBounds(TextLayout tl) {
        return new Rectangle2D.Float(0.0f, -tl.getAscent(), tl.getAdvance(), tl.getAscent() + tl.getDescent() + tl.getLeading());
    }

    protected String getText() {
        return this.getText(this.getStartOffset(), this.getEndOffset());
    }

    protected String getText(int p0, int p1) {
        return this.getTextEx(p0, p1 - p0);
    }

    protected String getTextEx(int position, int len) {
        try {
            return this.getDocument().getText(position, len);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void setPropertiesFromAttributes(AttributeSet attr) {
        if (attr != null) {
            Font newFont = (Font)attr.getAttribute("attribute_font");
            if (newFont == null) {
                throw new IllegalStateException("Font can not be null !");
            }
            this.setFont(newFont);
            this.setForeground((Color)attr.getAttribute("attribute_foreground"));
            this.setFontVariant((String)attr.getAttribute("attribute_font_variant"));
            List attribute = (List)attr.getAttribute("attribute_text_decoration");
            this.setTextDecoration(attribute);
        }
    }

    public String toString() {
        return this.getText();
    }

    public void updateProperties() {
        this.invalidateProperties();
    }

    private void invalidateCache() {
        this.refreshAttributes = true;
    }

    private void invalidateProperties() {
        this.refreshProperties = true;
    }

    private void invalidateTextLayout() {
        this.refreshTextLayout = true;
    }

    private void syncProperties() {
        if (this.refreshProperties) {
            this.setPropertiesFromAttributes(this.attributes);
            this.refreshProperties = false;
            this.refreshAttributes = false;
        }
    }

    protected void setFont(Font newFont) {
        if (this.font == null || !this.font.equals(newFont)) {
            this.font = new Font(newFont.getAttributes());
            this.invalidateCache();
            this.invalidateTextLayout();
        }
    }

    protected void setForeground(Color newColor) {
        if (this.foreground == null || !this.foreground.equals(newColor)) {
            this.foreground = new Color(newColor.getRGB());
            this.invalidateCache();
        }
    }

    protected void setFontVariant(CSSProperty.FontVariant newFontVariant) {
        this.setFontVariant(newFontVariant.toString());
    }

    protected void setFontVariant(String newFontVariant) {
        if (this.fontVariant == null || !this.fontVariant.equals(newFontVariant)) {
            CSSProperty.FontVariant[] val = CSSProperty.FontVariant.values();
            for (int i = 0; i < val.length; ++i) {
                if (!val[i].toString().equals(newFontVariant)) continue;
                this.fontVariant = newFontVariant;
                this.invalidateCache();
                return;
            }
        }
    }

    protected void setTextDecoration(List<CSSProperty.TextDecoration> newTextDecoration) {
        if (this.textDecoration == null || !this.textDecoration.equals(newTextDecoration)) {
            this.textDecoration = newTextDecoration;
            this.reflectTextDecoration(this.textDecoration);
            this.invalidateCache();
        }
    }

    private void reflectTextDecoration(List<CSSProperty.TextDecoration> decor) {
        this.underline = false;
        this.strike = false;
        this.overline = false;
        for (int i = 0; i < decor.size(); ++i) {
            CSSProperty.TextDecoration val = decor.get(i);
            if (CSSProperty.TextDecoration.UNDERLINE == val) {
                this.underline = true;
                continue;
            }
            if (CSSProperty.TextDecoration.LINE_THROUGH == val) {
                this.strike = true;
                continue;
            }
            if (CSSProperty.TextDecoration.OVERLINE != val) continue;
            this.overline = true;
        }
    }

    protected TextLayout getTextLayout() {
        if (this.refreshTextLayout) {
            this.refreshTextLayout = false;
            this.layout = new TextLayout(this.getText(), this.getFont(), new FontRenderContext(this.transform, true, false));
        }
        return this.layout;
    }

    public Font getFont() {
        this.syncProperties();
        return this.font;
    }

    public Color getForeground() {
        this.syncProperties();
        return this.foreground;
    }

    public String getFontVariant() {
        this.syncProperties();
        return this.fontVariant;
    }

    public List<CSSProperty.TextDecoration> getTextDecoration() {
        this.syncProperties();
        return this.textDecoration;
    }

    public static final Rectangle toRect(Shape a) {
        return a instanceof Rectangle ? (Rectangle)a : a.getBounds();
    }
}

