/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Connection;
import org.hibernate.spatial.dialect.AbstractJTSGeometryValueBinder;
import org.hibernate.spatial.jts.JTS;
import org.hibernate.spatial.jts.mgeom.MCoordinate;
import org.hibernate.spatial.jts.mgeom.MGeometry;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.PGgeometry;
import org.postgis.Point;

public class PGGeometryValueBinder
extends AbstractJTSGeometryValueBinder {
    @Override
    protected Object toNative(com.vividsolutions.jts.geom.Geometry jtsGeom, Connection connection) {
        Point geom = null;
        if ((jtsGeom = this.forceEmptyToGeometryCollection(jtsGeom)) instanceof com.vividsolutions.jts.geom.Point) {
            geom = this.convertJTSPoint((com.vividsolutions.jts.geom.Point)jtsGeom);
        } else if (jtsGeom instanceof com.vividsolutions.jts.geom.LineString) {
            geom = this.convertJTSLineString((com.vividsolutions.jts.geom.LineString)jtsGeom);
        } else if (jtsGeom instanceof com.vividsolutions.jts.geom.MultiLineString) {
            geom = this.convertJTSMultiLineString((com.vividsolutions.jts.geom.MultiLineString)jtsGeom);
        } else if (jtsGeom instanceof Polygon) {
            geom = this.convertJTSPolygon((Polygon)jtsGeom);
        } else if (jtsGeom instanceof MultiPoint) {
            geom = this.convertJTSMultiPoint((MultiPoint)jtsGeom);
        } else if (jtsGeom instanceof com.vividsolutions.jts.geom.MultiPolygon) {
            geom = this.convertJTSMultiPolygon((com.vividsolutions.jts.geom.MultiPolygon)jtsGeom);
        } else if (jtsGeom instanceof GeometryCollection) {
            geom = this.convertJTSGeometryCollection((GeometryCollection)jtsGeom);
        }
        if (geom != null) {
            return new PGgeometry((Geometry)geom);
        }
        throw new UnsupportedOperationException("Conversion of " + jtsGeom.getClass().getSimpleName() + " to PGgeometry not supported");
    }

    private com.vividsolutions.jts.geom.Geometry forceEmptyToGeometryCollection(com.vividsolutions.jts.geom.Geometry jtsGeom) {
        com.vividsolutions.jts.geom.Geometry forced = jtsGeom;
        if (forced.isEmpty()) {
            GeometryFactory factory = jtsGeom.getFactory();
            if (factory == null) {
                factory = JTS.getDefaultGeomFactory();
            }
            forced = factory.createGeometryCollection(null);
            forced.setSRID(jtsGeom.getSRID());
        }
        return forced;
    }

    private MultiPolygon convertJTSMultiPolygon(com.vividsolutions.jts.geom.MultiPolygon multiPolygon) {
        org.postgis.Polygon[] pgPolygons = new org.postgis.Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < pgPolygons.length; ++i) {
            pgPolygons[i] = this.convertJTSPolygon((Polygon)multiPolygon.getGeometryN(i));
        }
        MultiPolygon mpg = new MultiPolygon(pgPolygons);
        mpg.setSrid(multiPolygon.getSRID());
        return mpg;
    }

    private org.postgis.MultiPoint convertJTSMultiPoint(MultiPoint multiPoint) {
        Point[] pgPoints = new Point[multiPoint.getNumGeometries()];
        for (int i = 0; i < pgPoints.length; ++i) {
            pgPoints[i] = this.convertJTSPoint((com.vividsolutions.jts.geom.Point)multiPoint.getGeometryN(i));
        }
        org.postgis.MultiPoint mp = new org.postgis.MultiPoint(pgPoints);
        mp.setSrid(multiPoint.getSRID());
        return mp;
    }

    private org.postgis.Polygon convertJTSPolygon(Polygon jtsPolygon) {
        int numRings = jtsPolygon.getNumInteriorRing();
        org.postgis.LinearRing[] rings = new org.postgis.LinearRing[numRings + 1];
        rings[0] = this.convertJTSLineStringToLinearRing(jtsPolygon.getExteriorRing());
        for (int i = 0; i < numRings; ++i) {
            rings[i + 1] = this.convertJTSLineStringToLinearRing(jtsPolygon.getInteriorRingN(i));
        }
        org.postgis.Polygon polygon = new org.postgis.Polygon(rings);
        polygon.setSrid(jtsPolygon.getSRID());
        return polygon;
    }

    private org.postgis.LinearRing convertJTSLineStringToLinearRing(com.vividsolutions.jts.geom.LineString lineString) {
        org.postgis.LinearRing lr = new org.postgis.LinearRing(this.toPoints(lineString.getCoordinates()));
        lr.setSrid(lineString.getSRID());
        return lr;
    }

    private LineString convertJTSLineString(com.vividsolutions.jts.geom.LineString string) {
        LineString ls = new LineString(this.toPoints(string.getCoordinates()));
        if (string instanceof MGeometry) {
            ls.haveMeasure = true;
        }
        ls.setSrid(string.getSRID());
        return ls;
    }

    private MultiLineString convertJTSMultiLineString(com.vividsolutions.jts.geom.MultiLineString string) {
        LineString[] lines = new LineString[string.getNumGeometries()];
        for (int i = 0; i < string.getNumGeometries(); ++i) {
            lines[i] = new LineString(this.toPoints(string.getGeometryN(i).getCoordinates()));
        }
        MultiLineString mls = new MultiLineString(lines);
        if (string instanceof MGeometry) {
            mls.haveMeasure = true;
        }
        mls.setSrid(string.getSRID());
        return mls;
    }

    private Point convertJTSPoint(com.vividsolutions.jts.geom.Point point) {
        Point pgPoint = new Point();
        pgPoint.srid = point.getSRID();
        pgPoint.x = point.getX();
        pgPoint.y = point.getY();
        Coordinate coordinate = point.getCoordinate();
        if (Double.isNaN(coordinate.z)) {
            pgPoint.dimension = 2;
        } else {
            pgPoint.z = coordinate.z;
            pgPoint.dimension = 3;
        }
        pgPoint.haveMeasure = false;
        if (coordinate instanceof MCoordinate && !Double.isNaN(((MCoordinate)coordinate).m)) {
            pgPoint.m = ((MCoordinate)coordinate).m;
            pgPoint.haveMeasure = true;
        }
        return pgPoint;
    }

    private org.postgis.GeometryCollection convertJTSGeometryCollection(GeometryCollection collection) {
        Geometry[] pgCollections = new Geometry[collection.getNumGeometries()];
        for (int i = 0; i < pgCollections.length; ++i) {
            com.vividsolutions.jts.geom.Geometry currentGeom = collection.getGeometryN(i);
            if ((currentGeom = this.forceEmptyToGeometryCollection(currentGeom)).getClass() == com.vividsolutions.jts.geom.LineString.class) {
                pgCollections[i] = this.convertJTSLineString((com.vividsolutions.jts.geom.LineString)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == LinearRing.class) {
                pgCollections[i] = this.convertJTSLineStringToLinearRing((com.vividsolutions.jts.geom.LineString)((LinearRing)currentGeom));
                continue;
            }
            if (currentGeom.getClass() == com.vividsolutions.jts.geom.MultiLineString.class) {
                pgCollections[i] = this.convertJTSMultiLineString((com.vividsolutions.jts.geom.MultiLineString)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == MultiPoint.class) {
                pgCollections[i] = this.convertJTSMultiPoint((MultiPoint)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == com.vividsolutions.jts.geom.MultiPolygon.class) {
                pgCollections[i] = this.convertJTSMultiPolygon((com.vividsolutions.jts.geom.MultiPolygon)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == com.vividsolutions.jts.geom.Point.class) {
                pgCollections[i] = this.convertJTSPoint((com.vividsolutions.jts.geom.Point)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == Polygon.class) {
                pgCollections[i] = this.convertJTSPolygon((Polygon)currentGeom);
                continue;
            }
            if (currentGeom.getClass() != GeometryCollection.class) continue;
            pgCollections[i] = this.convertJTSGeometryCollection((GeometryCollection)currentGeom);
        }
        org.postgis.GeometryCollection gc = new org.postgis.GeometryCollection(pgCollections);
        gc.setSrid(collection.getSRID());
        return gc;
    }

    private Point[] toPoints(Coordinate[] coordinates) {
        Point[] points = new Point[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate c = coordinates[i];
            Point pt = Double.isNaN(c.z) ? new Point(c.x, c.y) : new Point(c.x, c.y, c.z);
            if (c instanceof MCoordinate) {
                MCoordinate mc = (MCoordinate)c;
                if (!Double.isNaN(mc.m)) {
                    pt.setM(mc.m);
                }
            }
            points[i] = pt;
        }
        return points;
    }
}

