/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.util.List;
import org.hibernate.spatial.dialect.sqlserver.convertors.AbstractEncoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.Encoders;
import org.hibernate.spatial.dialect.sqlserver.convertors.Figure;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.Shape;

class GeometryCollectionEncoder<T extends GeometryCollection>
extends AbstractEncoder<T> {
    private final OpenGisType openGisType;

    GeometryCollectionEncoder(OpenGisType openGisType) {
        this.openGisType = openGisType;
    }

    @Override
    public boolean accepts(Geometry geom) {
        return this.openGisType.typeOf(geom);
    }

    @Override
    protected void encode(Geometry geom, int parentShapeIndex, List<Coordinate> coordinates, List<Figure> figures, List<Shape> shapes) {
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentShapeIndex, -1, this.openGisType));
            return;
        }
        int thisShapeIndex = shapes.size();
        Shape thisShape = this.createShape(parentShapeIndex, figures);
        shapes.add(thisShape);
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry component = geom.getGeometryN(i);
            this.encodeComponent(component, thisShapeIndex, coordinates, figures, shapes);
        }
    }

    protected Shape createShape(int parentShapeIndex, List<Figure> figures) {
        Shape thisShape = new Shape(parentShapeIndex, figures.size(), this.openGisType);
        return thisShape;
    }

    protected void encodeComponent(Geometry geom, int thisShapeIndex, List<Coordinate> coordinates, List<Figure> figures, List<Shape> shapes) {
        AbstractEncoder encoder = (AbstractEncoder)Encoders.encoderFor(geom);
        encoder.encode(geom, thisShapeIndex, coordinates, figures, shapes);
    }
}

