/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import org.hibernate.spatial.dialect.sqlserver.convertors.AbstractEncoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.Figure;
import org.hibernate.spatial.dialect.sqlserver.convertors.FigureAttribute;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.Shape;

class PolygonEncoder
extends AbstractEncoder<Polygon> {
    PolygonEncoder() {
    }

    @Override
    public boolean accepts(Geometry geom) {
        return geom instanceof Polygon;
    }

    @Override
    protected void encode(Geometry geom, int parentShapeIndex, List<Coordinate> coordinates, List<Figure> figures, List<Shape> shapes) {
        if (!(geom instanceof Polygon)) {
            throw new IllegalArgumentException("Polygon geometry expected.");
        }
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentShapeIndex, -1, OpenGisType.POLYGON));
            return;
        }
        Polygon polygon = (Polygon)geom;
        int figureOffset = figures.size();
        shapes.add(new Shape(parentShapeIndex, figureOffset, OpenGisType.POLYGON));
        int pointOffset = coordinates.size();
        this.addExteriorRing(polygon, coordinates, figures);
        this.addInteriorRings(polygon, coordinates, figures);
    }

    private void addInteriorRings(Polygon geom, List<Coordinate> coordinates, List<Figure> figures) {
        for (int idx = 0; idx < geom.getNumInteriorRing(); ++idx) {
            this.addInteriorRing(geom.getInteriorRingN(idx), coordinates, figures);
        }
    }

    private void addInteriorRing(LineString ring, List<Coordinate> coordinates, List<Figure> figures) {
        int pointOffset = coordinates.size();
        this.addPoints(ring, coordinates);
        Figure figure = new Figure(FigureAttribute.InteriorRing, pointOffset);
        figures.add(figure);
    }

    private void addPoints(LineString ring, List<Coordinate> coordinates) {
        for (Coordinate c : ring.getCoordinates()) {
            coordinates.add(c);
        }
    }

    private void addExteriorRing(Polygon geom, List<Coordinate> coordinates, List<Figure> figures) {
        LineString shell = geom.getExteriorRing();
        int offset = coordinates.size();
        this.addPoints(shell, coordinates);
        Figure exterior = new Figure(FigureAttribute.ExteriorRing, offset);
        figures.add(exterior);
    }
}

