/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlschema.lib.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.xmlschema.lib.api.XMLSchemaManager;
import org.gvsig.xmlschema.lib.api.exceptions.SchemaCreationException;
import org.gvsig.xmlschema.lib.api.som.IXSSchema;
import org.gvsig.xmlschema.lib.api.som.IXSTypeDefinition;
import org.gvsig.xmlschema.lib.impl.DefaultGeometryTypeDefinition;
import org.gvsig.xmlschema.lib.impl.DefaultSimpleTypeDefinition;
import org.gvsig.xmlschema.lib.spi.XmlSchemaProvider;
import org.gvsig.xmlschema.lib.spi.XmlSchemaProviderLocator;
import org.gvsig.xmlschema.lib.spi.XmlSchemaProviderManager;

public class DefaultXMLSchemaManager
implements XMLSchemaManager {
    private Map mimeTypes = new HashMap();
    private Map formats = new HashMap();
    private Map appToGpeGeometryTypes = new HashMap();
    private Map gpeToAppGeometryTypes = new HashMap();
    private Map appToGpeDataTypes = new HashMap();
    private Map gpeToAppDataTypes = new HashMap();
    private static DataTypesManager dataTypesManager = null;

    public DefaultXMLSchemaManager() {
        dataTypesManager = ToolsLocator.getDataTypesManager();
        this.registerFormat("default", "default");
    }

    public Object getApplicationDataTypeByFormat(String format, Object parserDataType) {
        return this.getApplicationDataType(this.getTypesByformat(format), parserDataType);
    }

    public Object getApplicationDataTypeByMimeType(String mimeType, Object parserDataType) {
        return this.getApplicationDataType(this.getTypesByMimeType(mimeType), parserDataType);
    }

    private Object getApplicationDataType(TypesByformat typesByformat, Object parserDataType) {
        if (typesByformat == null) {
            return null;
        }
        IXSTypeDefinition gpeformat = typesByformat.getGpeDataType(parserDataType);
        if (gpeformat != null) {
            return this.gpeToAppDataTypes.get(gpeformat);
        }
        return null;
    }

    public String getFormat(String mimeType) {
        if (this.mimeTypes.containsKey(mimeType)) {
            return ((TypesByformat)this.mimeTypes.get(mimeType)).getName();
        }
        return null;
    }

    public void registerFormat(String mimeType, String format) {
        TypesByformat typesByformat = new TypesByformat(format);
        this.mimeTypes.put(mimeType, typesByformat);
        this.formats.put(format, typesByformat);
    }

    public void addParserGeometryType(String format, Object type, int gpeGeometryType) {
        TypesByformat typesByformat = this.getTypesByformat(format);
        typesByformat.addParserGeometryType(type, gpeGeometryType);
    }

    public void addParserDataType(String format, Object type, int gpeDataType) {
        TypesByformat typesByformat = this.getTypesByformat(format);
        typesByformat.addParserDataType(type, gpeDataType);
    }

    public void addParserDataType(Object type, int gpeDataType) {
        for (String format : this.formats.keySet()) {
            TypesByformat typesByformat = (TypesByformat)this.formats.get(format);
            typesByformat.addParserDataType(type, gpeDataType);
        }
    }

    public void registerAppGeometryType(Object appGeometryType, int gpeGeometryType) {
        Integer gpeGeoemtryTypeInt = new Integer(gpeGeometryType);
        this.gpeToAppGeometryTypes.put(gpeGeoemtryTypeInt, appGeometryType);
        this.appToGpeGeometryTypes.put(appGeometryType, gpeGeoemtryTypeInt);
    }

    public void registerAppDataType(Object appDataType, int gpeDataType) {
        Integer gpeDataTypeInt = new Integer(gpeDataType);
        this.gpeToAppDataTypes.put(gpeDataTypeInt, appDataType);
        this.appToGpeDataTypes.put(appDataType, gpeDataTypeInt);
    }

    public void registerAppDataType(int appDataType, int gpeDataType) {
        this.registerAppDataType(new Integer(appDataType), gpeDataType);
    }

    public void registerAppGeometryType(int appGeometrytype, int gpeGeometryType) {
        this.registerAppGeometryType(new Integer(appGeometrytype), gpeGeometryType);
    }

    private TypesByformat getTypesByformat(String format) {
        if (this.formats.containsKey(format)) {
            return (TypesByformat)this.formats.get(format);
        }
        TypesByformat typesByformat = new TypesByformat(format);
        this.formats.put(format, typesByformat);
        return typesByformat;
    }

    private TypesByformat getTypesByMimeType(String mimeType) {
        if (!this.mimeTypes.containsKey(mimeType)) {
            return null;
        }
        return (TypesByformat)this.mimeTypes.get(mimeType);
    }

    public Object getParserDataTypeByFormat(String format, Object applicationDataType) {
        return this.getParserDataType(this.getTypesByformat(format), applicationDataType);
    }

    public Object getParserDataTypeByMimeType(String mimeType, Object applicationDataType) {
        return this.getParserDataType(this.getTypesByMimeType(mimeType), applicationDataType);
    }

    private Object getParserDataType(TypesByformat typesByformat, Object applicationDataType) {
        if (!this.appToGpeDataTypes.containsKey(applicationDataType)) {
            return null;
        }
        Integer gpeDatatype = (Integer)this.appToGpeDataTypes.get(applicationDataType);
        return typesByformat.getParserDataType(gpeDatatype);
    }

    public Object getApplicationGeometryTypeByMimeType(String mimeType, Object parserGeometryType) {
        return this.getApplicationGeometry(this.getTypesByMimeType(mimeType), parserGeometryType);
    }

    public Object getApplicationGeometryTypeByFormat(String format, Object parserGeometryType) {
        return this.getApplicationGeometry(this.getTypesByformat(format), parserGeometryType);
    }

    private Object getApplicationGeometry(TypesByformat typesByformat, Object parserGeometryType) {
        int gpeGeometryCode = typesByformat.getGpeGeometryCode(parserGeometryType);
        if (gpeGeometryCode == -1) {
            return null;
        }
        return this.gpeToAppGeometryTypes.get(gpeGeometryCode);
    }

    public Object getParserGeometryTypeByFormat(String format, Object applicationGeometryType) {
        return this.getParserGeometryType(this.getTypesByformat(format), applicationGeometryType);
    }

    public Object getParserGeometryTypeByMimeType(String mimeType, Object applicationGeometryType) {
        return this.getParserGeometryType(this.getTypesByMimeType(mimeType), applicationGeometryType);
    }

    public Object getParserGeometryType(TypesByformat typesByformat, Object applicationGeometryType) {
        if (!this.appToGpeGeometryTypes.containsKey(applicationGeometryType)) {
            return null;
        }
        IXSTypeDefinition gpeGeometryType = (IXSTypeDefinition)this.appToGpeGeometryTypes.get(applicationGeometryType);
        return typesByformat.getParserGeometryType(gpeGeometryType);
    }

    public IXSSchema createXSSchema(String providerName, String namespaceURI, String namespacePrefix) throws SchemaCreationException {
        XmlSchemaProvider xmlSchemaProvider;
        XmlSchemaProviderManager xmlSchemaProviderManager = XmlSchemaProviderLocator.getXMLSchemaProviderManager();
        try {
            xmlSchemaProvider = xmlSchemaProviderManager.createXmlSchemaProvider(providerName);
        }
        catch (ServiceException e) {
            throw new SchemaCreationException((Throwable)e);
        }
        return xmlSchemaProvider.createXSSchema(namespaceURI, namespacePrefix);
    }

    public IXSSchema parse(String providerName, InputStream is) throws SchemaCreationException {
        XmlSchemaProvider xmlSchemaProvider;
        XmlSchemaProviderManager xmlSchemaProviderManager = XmlSchemaProviderLocator.getXMLSchemaProviderManager();
        try {
            xmlSchemaProvider = xmlSchemaProviderManager.createXmlSchemaProvider(providerName);
        }
        catch (ServiceException e) {
            throw new SchemaCreationException((Throwable)e);
        }
        return xmlSchemaProvider.parse(is);
    }

    public IXSTypeDefinition getTypeDefinition(String typeName) {
        for (String format : this.formats.keySet()) {
            IXSTypeDefinition typeDefinition = this.getTypeDefinition(format, typeName);
            if (typeDefinition == null) continue;
            return typeDefinition;
        }
        return null;
    }

    public IXSTypeDefinition getTypeDefinition(String format, String typeName) {
        TypesByformat typesByformat = (TypesByformat)this.formats.get(format);
        IXSTypeDefinition typeDefinition = typesByformat.getGpeDataType(typeName);
        if (typeDefinition == null) {
            typeDefinition = typesByformat.getGpeGeometryType(typeName);
        }
        return typeDefinition;
    }

    private class TypesByformat {
        private Map parserToGpeGeometryType = new HashMap();
        private Map gpeToParserGeometryType = new HashMap();
        private Map parserToGpeDataType = new HashMap();
        private Map gpeToParserDataType = new HashMap();
        private Map gpeNameToGeometryType = new HashMap();
        private DataType geometryDataType = null;
        private String name = null;

        public TypesByformat(String name) {
            this.name = name;
            int type = dataTypesManager.getType("Geometry");
            this.geometryDataType = type != 0 ? dataTypesManager.get(type) : dataTypesManager.get(64);
        }

        void addParserGeometryType(Object type, int gpeGeometryType) {
            DefaultGeometryTypeDefinition typeDefinition = new DefaultGeometryTypeDefinition(type.toString(), this.geometryDataType, this.name);
            this.gpeNameToGeometryType.put(typeDefinition, new Integer(gpeGeometryType));
            this.parserToGpeGeometryType.put(type, typeDefinition);
            ArrayList geometryTypes = null;
            if (this.gpeToParserGeometryType.containsKey(typeDefinition)) {
                geometryTypes = (ArrayList)this.gpeToParserGeometryType.get(typeDefinition);
            } else {
                geometryTypes = new ArrayList();
                this.gpeToParserGeometryType.put(typeDefinition, geometryTypes);
            }
            geometryTypes.add(typeDefinition);
        }

        void addParserDataType(Object type, int gpeDataType) {
            DefaultSimpleTypeDefinition typeDefinition = new DefaultSimpleTypeDefinition(type.toString(), dataTypesManager.get(gpeDataType));
            this.parserToGpeDataType.put(type, typeDefinition);
            ArrayList dataTypes = null;
            if (this.gpeToParserDataType.containsKey(typeDefinition)) {
                dataTypes = (ArrayList)this.gpeToParserDataType.get(typeDefinition);
            } else {
                dataTypes = new ArrayList();
                this.gpeToParserDataType.put(typeDefinition, dataTypes);
            }
            dataTypes.add(typeDefinition);
        }

        IXSTypeDefinition getGpeDataType(Object parserDataType) {
            if (this.parserToGpeDataType.containsKey(parserDataType)) {
                return (IXSTypeDefinition)this.parserToGpeDataType.get(parserDataType);
            }
            return this.getGpeTypeWithOutNameSpace(this.parserToGpeDataType, parserDataType);
        }

        IXSTypeDefinition getGpeTypeWithOutNameSpace(Map mapTypes, Object parserDataType) {
            Set keys = mapTypes.keySet();
            Iterator it = keys.iterator();
            String[] typeParts = parserDataType.toString().split(":");
            String typeAux = parserDataType.toString();
            if (typeParts.length > 1) {
                typeAux = typeParts[1];
            }
            while (it.hasNext()) {
                String key = (String)it.next();
                String[] parts = key.split(":");
                if (!(parts.length == 1 ? parts[0].compareTo(typeAux.toUpperCase()) == 0 : parts.length > 1 && parts[parts.length - 1].toUpperCase().compareTo(typeAux.toUpperCase()) == 0)) continue;
                return (IXSTypeDefinition)mapTypes.get(key);
            }
            return null;
        }

        int getGpeGeometryCode(Object parserGeometryType) {
            IXSTypeDefinition typeDefinition = this.getGpeGeometryType(parserGeometryType);
            if (typeDefinition == null) {
                return -1;
            }
            Integer gpeGeometry = (Integer)this.gpeNameToGeometryType.get(typeDefinition);
            if (gpeGeometry != null) {
                return gpeGeometry;
            }
            return -1;
        }

        IXSTypeDefinition getGpeGeometryType(Object parserGeometryType) {
            if (this.parserToGpeGeometryType.containsKey(parserGeometryType)) {
                return (IXSTypeDefinition)this.parserToGpeGeometryType.get(parserGeometryType);
            }
            return this.getGpeTypeWithOutNameSpace(this.parserToGpeGeometryType, parserGeometryType);
        }

        Object getParserDataType(Integer gpeDataType) {
            return this.gpeToParserDataType.get(gpeDataType);
        }

        Object getParserGeometryType(IXSTypeDefinition gpeGeometryType) {
            return this.gpeToParserGeometryType.get(gpeGeometryType);
        }

        public String getName() {
            return this.name;
        }
    }
}

