/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient;

import java.awt.Component;
import javax.swing.Icon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.app.georeferencingclient.Georeferencing;
import org.gvsig.raster.georeferencing.app.georeferencingclient.GeoreferencingTocMenuEntry;
import org.gvsig.raster.georeferencing.swing.GeoreferencingPanel;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.WindowPanel;

public class GeoreferencingExtension
extends Extension
implements IGenericToolBarMenuItem {
    public void execute(String actionCommand) {
        if (actionCommand.equals("GEOREFERENCING")) {
            if (this.isAlreadyOpenGeoreferencing()) {
                ApplicationManager application = ApplicationLocator.getApplicationManager();
                I18nManager i18n = ToolsLocator.getI18nManager();
                application.messageDialog(i18n.getTranslation("_Georeferencing_already_open"), i18n.getTranslation("georeferencing"), 1);
                return;
            }
            Georeferencing georef = new Georeferencing();
            georef.initialize();
        }
    }

    private boolean isAlreadyOpenGeoreferencing() {
        IWindow[] wins;
        ApplicationManager application = ApplicationLocator.getManager();
        for (IWindow win : wins = application.getUIManager().getAllWindows()) {
            Component contents;
            if (!(win instanceof WindowPanel) || !((contents = ((WindowPanel)win).getContents()) instanceof GeoreferencingPanel)) continue;
            application.getUIManager().moveToFrom(win);
            return true;
        }
        return false;
    }

    public void initialize() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("GenericToolBarMenu");
        point.append("Georreferencing", "", (ExtensionBuilder)GeoreferencingTocMenuEntry.getSingleton());
        GeoreferencingTocMenuEntry.setExtension(this);
        this.registerIcons();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"menu-layer-georeferencing", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"save-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"reset-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"load-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"selectzoomarea-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"prevzoom-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"fullview-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"increase-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"decrease-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"exporttoascii-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"exporttocsv-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"exit-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"process-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"endprocess-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"options-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"add-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"centerpoint-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"hand-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"centerlocator-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"arrow_horiz-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"arrow_vert-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"arrow_move-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"crux_red-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"crux_blue-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"drag-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"move-icon", (Object)((Object)this));
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        this.execute("GEOREFERENCING");
    }

    public String getGroup() {
        return "GeoRaster";
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"menu-layer-georeferencing");
    }

    public int getOrder() {
        return 0;
    }

    public String getText() {
        return Messages.getText((String)"georreferenciacion");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        return this.isEnabled();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        return this.isVisible();
    }

    public int getGroupOrder() {
        return 0;
    }
}

