/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient.listener;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.ViewMapRequestManager;
import org.gvsig.raster.georeferencing.lib.impl.GeoTransformDataResult;
import org.gvsig.raster.georeferencing.swing.exception.InvalidRequestException;
import org.gvsig.raster.georeferencing.swing.impl.GeoreferencingSwingImplLibrary;
import org.gvsig.raster.swing.RasterSwingLibrary;

public class GeoreferencingProcessActions
implements IProcessActions {
    private ViewMapRequestManager viewMapRequestManager = null;
    private String fileName = null;
    private FLyrRaster lastTestLyr = null;

    public void setViewMapRequest(ViewMapRequestManager vMap) {
        this.viewMapRequestManager = vMap;
    }

    public void addTestRasterLayer(RasterDataStore store, int algorithm, int method, int order, String file, double cellsizeX, double cellsizeY, GeoTransformDataResult result, IProjection proj) throws LoadLayerException {
        if (result != null && !this.testNumberOfPoints(order, result.getGpcs())) {
            return;
        }
        this.fileName = file;
        RasterDataStore storeClon = null;
        try {
            storeClon = store.cloneDataStore();
        }
        catch (Exception e1) {
            RasterSwingLibrary.messageBoxError((String)"error_clone_layer", (Object)this, (Exception)e1);
            return;
        }
        if (algorithm == 1) {
            if (result == null) {
                RasterSwingLibrary.messageBoxInfo((String)"error_georef", (Object)this);
                return;
            }
            AffineTransform at = new AffineTransform(result.getPixelToMapCoefX()[1], result.getPixelToMapCoefY()[1], result.getPixelToMapCoefX()[2], result.getPixelToMapCoefY()[2], result.getPixelToMapCoefX()[0], result.getPixelToMapCoefY()[0]);
            storeClon.setAffineTransform(at);
        }
        DefaultFLyrRaster lyr = new DefaultFLyrRaster();
        lyr.setDataStore((DataStore)storeClon);
        this.lastTestLyr = lyr;
        if (algorithm == 0) {
            try {
                DataProcess process = RasterBaseAlgorithmLibrary.getManager().createRasterTask("GeoreferencingProcess");
                process.addParam("RasterStore", (Object)lyr.getDataStore());
                process.addParam("FileName", (Object)file);
                process.addParam("InterpolationMethod", (Object)new Integer(method));
                process.addParam("gcps", (Object)result.getGpcs());
                process.addParam("Order", (Object)new Integer(order));
                process.addParam("xCellSize", (Object)new Double(cellsizeX));
                process.addParam("yCellSize", (Object)new Double(cellsizeY));
                process.addParam("projection", (Object)proj);
                process.setActions((IProcessActions)this);
                process.start();
            }
            catch (ProcessException e) {
                GeoreferencingSwingImplLibrary.messageBoxError((String)"error_georef_process", null, (Exception)((Object)e));
            }
        }
        if (this.viewMapRequestManager != null && algorithm == 1) {
            try {
                URI[] names = lyr.getDataStore().getURIByProvider();
                String fname = this.fileName;
                if (names != null && names.length >= 1) {
                    fname = new File(names[0]).getAbsolutePath();
                }
                fname = FilenameUtils.getBaseName((String)fname);
                lyr.setName(fname);
                this.viewMapRequestManager.addTestRasterLayer((FLyrRaster)lyr);
            }
            catch (InvalidRequestException e) {
                GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null, (Exception)((Object)e));
            }
        }
    }

    private boolean testNumberOfPoints(int order, GeoPointList gpList) {
        if (gpList != null) {
            if (gpList.size() <= 0) {
                GeoreferencingSwingImplLibrary.messageBoxError((String)"no_selected_points", null);
                return false;
            }
            int nPointsActive = 0;
            for (int i = 0; i < gpList.size(); ++i) {
                if (!((GeoPoint)gpList.get(i)).isActive()) continue;
                ++nPointsActive;
            }
            int nPoints = (order + 1) * (order + 2) / 2;
            if (nPointsActive < nPoints) {
                GeoreferencingSwingImplLibrary.messageBoxError((String)(Messages.getText((String)"more_points") + (int)Math.ceil(nPoints)), null);
                return false;
            }
        }
        return true;
    }

    public void removeTestRasterLayer() {
        if (this.viewMapRequestManager != null) {
            try {
                if (this.getLastTestLayer() != null) {
                    this.getLastTestLayer().setRemoveRasterFlag(false);
                }
                this.viewMapRequestManager.removeTestRasterLayer();
                this.lastTestLyr = null;
            }
            catch (InvalidRequestException e) {
                GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null);
            }
        }
    }

    public void end(Object param) {
        try {
            String f = RasterLocator.getManager().getFileUtils().getLastPart(this.fileName, File.separator);
            DefaultFLyrRaster lyr = DefaultFLyrRaster.createLayer((String)f, (File)new File(this.fileName));
            this.lastTestLyr = lyr;
            if (this.viewMapRequestManager != null) {
                this.viewMapRequestManager.addTestRasterLayer((FLyrRaster)lyr);
            }
        }
        catch (InvalidRequestException e) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null, (Exception)((Object)e));
        }
        catch (LoadLayerException e) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null, (Exception)((Object)e));
        }
    }

    public void interrupted() {
    }

    public FLyrRaster getLastTestLayer() {
        return this.lastTestLyr;
    }

    public void updateProgress(int current, int total) {
    }
}

