/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient.listener;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.AbstractViewRequestManager;
import org.gvsig.raster.georeferencing.swing.exception.InvalidRequestException;
import org.gvsig.raster.georeferencing.swing.impl.GeoreferencingSwingImplLibrary;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.tools.task.Cancellable;

public class ViewRasterRequestManager
extends AbstractViewRequestManager {
    private GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private FLyrRaster lyr = null;

    public ViewRasterRequestManager(GeoreferencingView view, RasterDataStore store) {
        this.view = view;
        this.lyr = new DefaultFLyrRaster();
        try {
            AffineTransform modifiedAT = store.getAffineTransform();
            ((DefaultFLyrRaster)this.lyr).setDataStore((DataStore)store);
            this.lyr.setAffineTransform(modifiedAT);
        }
        catch (LoadLayerException e) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null, (Exception)((Object)e));
        }
    }

    public Rectangle2D getRasterExtent() {
        Extent ex = this.lyr.getDataStore().getExtent();
        return ex.toRectangle2D();
    }

    public void fullExtent() throws InvalidRequestException {
        this.initRequest(this.lyr.getDataStore().getExtent());
    }

    public BufferedImage request(Rectangle2D req, Cancellable cancel) throws InvalidRequestException {
        if (req != null) {
            return this.request(RasterLocator.getManager().getDataStructFactory().createExtent(req), cancel);
        }
        return null;
    }

    public BufferedImage request(Extent req, Cancellable cancel) throws InvalidRequestException {
        if (req == null || this.view.getCanvasWidth() == 0 || this.view.getCanvasHeight() == 0) {
            return null;
        }
        if (this.lyr.getDataStore().getExtent() == null) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"error_set_view", (Object)this, null);
            return null;
        }
        try {
            ViewPort vp = new ViewPort();
            vp.setImageSize(new Dimension(this.view.getCanvasWidth(), this.view.getCanvasHeight()));
            Envelope env = this.geomManager.createEnvelope(req.getMin().getX(), this.getRasterExtent().getHeight() - req.getMax().getY(), req.getMax().getX(), this.getRasterExtent().getHeight() - req.getMin().getY(), 0);
            vp.setEnvelope(env);
            BufferedImage buf = this.getBufferedImage();
            Graphics2D g2d = this.getCleanGraphics();
            this.lyr.draw(buf, g2d, vp, cancel, 1.0);
            if (cancel == null || cancel != null && !cancel.isCanceled()) {
                this.setDrawParams(buf, req.toRectangle2D());
            }
            return this.getBufferedImage();
        }
        catch (ReadException e) {
            throw new InvalidRequestException("Error en al acceso al fichero", (Throwable)e);
        }
        catch (CreateEnvelopeException e) {
            throw new InvalidRequestException("Error asignando el \u00e1rea de la petici\u00f3n", (Throwable)e);
        }
    }
}

