/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.stretch.operation;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperation;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperationUtils;

public class LineStretchOperation
implements StretchOperation {
    @Override
    public Geometry transform(AffineTransform at, Primitive geom, Geometry roi) throws GeometryOperationNotSupportedException, GeometryOperationException {
        OrientablePrimitive primitive = (OrientablePrimitive)geom.cloneGeometry();
        for (int j = 0; j < primitive.getNumVertices(); ++j) {
            Point point = primitive.getVertex(j);
            if (!roi.intersects((Geometry)point) && !roi.contains((Geometry)point)) continue;
            point.transform(at);
            StretchOperationUtils.setVertex(primitive, j, point);
        }
        return primitive;
    }

    @Override
    public List<Point> getSelectedVertex(Primitive geom, Geometry roi) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        OrientablePrimitive primitive = (OrientablePrimitive)geom.cloneGeometry();
        ArrayList<Point> vertexList = new ArrayList<Point>();
        for (int j = 0; j < primitive.getNumVertices(); ++j) {
            Point point = primitive.getVertex(j);
            if (!roi.intersects((Geometry)point) && !roi.contains((Geometry)point)) continue;
            vertexList.add(point);
        }
        return vertexList;
    }
}

