/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.prefs.Preferences;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.dynobject.DynObject;

public class DisableSnappingExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        if (actionCommand.equals("edit-disable-snapping")) {
            PluginsManager pluginManager = PluginsLocator.getManager();
            PluginServices plugin = pluginManager.getPlugin((Object)this);
            DynObject pluginProperties = plugin.getPluginProperties();
            IView view = this.getActiveView();
            MapControl mc = view.getMapControl();
            mc.setRefentEnabled(false);
            pluginProperties.setDynValue("applySnappers", (Object)mc.isRefentEnabled());
            plugin.savePluginProperties();
            Preferences prefs = Preferences.userRoot().node("snappers");
            prefs.putBoolean("apply-snappers", mc.isRefentEnabled());
            ApplicationLocator.getManager().refreshMenusAndToolBars();
        }
    }

    public boolean isEnabled() {
        MapControl mc;
        IView view = this.getActiveView();
        if (view != null && (mc = view.getMapControl()) != null) {
            FLyrVect layer = this.getActiveLayer(view);
            return mc.isRefentEnabled() && layer != null && layer.isEditing();
        }
        return false;
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    private IView getActiveView() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        return view;
    }

    private FLyrVect getActiveLayer(IView vista) {
        ViewDocument viewDocument;
        FLayer[] actives;
        if (vista != null && (actives = (viewDocument = vista.getViewDocument()).getMapContext().getLayers().getActives()).length == 1 && actives[0] instanceof FLyrVect) {
            return (FLyrVect)actives[0];
        }
        return null;
    }
}

