/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners.snapping.snappers;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.PrimitivesDrawer;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapperVectorial;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.impl.AbstractSnapper;
import org.gvsig.i18n.Messages;

public class QuadrantPointSnapper
extends AbstractSnapper
implements ISnapperVectorial {
    public Point2D getSnapPoint(Point2D point, Geometry geom, double tolerance, Point2D lastPointEntered) {
        Point2D resul = null;
        Envelope envelope = geom.getEnvelope();
        double minX = envelope.getMinimum(0);
        double centerX = envelope.getCenter(0);
        double maxX = envelope.getMaximum(0);
        double minY = envelope.getMinimum(1);
        double centerY = envelope.getCenter(1);
        double maxY = envelope.getMaximum(1);
        ArrayList<Point2D.Double> pointHandlers = new ArrayList<Point2D.Double>();
        pointHandlers.add(new Point2D.Double(minX, minY));
        pointHandlers.add(new Point2D.Double(centerX, minY));
        pointHandlers.add(new Point2D.Double(maxX, minY));
        pointHandlers.add(new Point2D.Double(minX, centerY));
        pointHandlers.add(new Point2D.Double(maxX, centerY));
        pointHandlers.add(new Point2D.Double(maxX, maxY));
        pointHandlers.add(new Point2D.Double(maxX, maxY));
        pointHandlers.add(new Point2D.Double(maxX, maxY));
        double minDist = tolerance;
        for (Point2D point2D : pointHandlers) {
            double dist = point2D.distance(point);
            if (!(dist < minDist)) continue;
            resul = point2D;
            minDist = dist;
        }
        return resul;
    }

    public String getToolTipText() {
        return Messages.getText((String)"Quadrant_point");
    }

    public void draw(PrimitivesDrawer primitivesDrawer, Point2D pPixels) {
        primitivesDrawer.setColor(this.getColor());
        int half = this.getSizePixels() / 2;
        int x1 = (int)(pPixels.getX() - (double)half);
        int x2 = (int)(pPixels.getX() + (double)half);
        int x3 = (int)pPixels.getX();
        int y1 = (int)(pPixels.getY() - (double)half);
        int y2 = (int)(pPixels.getY() + (double)half);
        int y3 = (int)pPixels.getY();
        primitivesDrawer.drawLine(x1, y3, x3, y1);
        primitivesDrawer.drawLine(x1, y3, x3, y2);
        primitivesDrawer.drawLine(x2, y3, x3, y1);
        primitivesDrawer.drawLine(x2, y3, x3, y2);
    }
}

