/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.geo.Projected;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.LayersToSnap;
import org.gvsig.fmap.mapcontext.MapContextDrawer;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.ErrorEvent;
import org.gvsig.fmap.mapcontext.events.listeners.AtomicEventListener;
import org.gvsig.fmap.mapcontext.events.listeners.ErrorListener;
import org.gvsig.fmap.mapcontext.events.listeners.EventBuffer;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.impl.DefaultMapContextManager;
import org.gvsig.fmap.mapcontext.layers.BaseLayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerDrawEvent;
import org.gvsig.fmap.mapcontext.layers.LayerDrawingListener;
import org.gvsig.fmap.mapcontext.layers.LayerPositionEvent;
import org.gvsig.fmap.mapcontext.layers.operations.Classifiable;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.layers.order.LayerOrderManager;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.events.listeners.LegendListener;
import org.gvsig.fmap.mapcontext.rendering.strategies.SelectedEnvelopeVisitor;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInterval;
import org.gvsig.timesupport.AbsoluteIntervalTypeNotRegisteredException;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.Interval;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContext
extends AbstractDisposable
implements Projected,
Persistent,
Observer,
Iterable<FLayer> {
    public static final double[] CHANGEM = new double[]{1000.0, 1.0, 0.01, 0.001, 1609.344, 0.9144, 0.3048, 0.0254, 111319.49079327358};
    public static ArrayList AREANAMES = new ArrayList();
    public static ArrayList AREAABBR = new ArrayList();
    public static ArrayList AREATRANS2METER = new ArrayList();
    public static ArrayList DISTANCENAMES = new ArrayList();
    public static ArrayList DISTANCEABBR = new ArrayList();
    public static ArrayList DISTANCETRANS2METER = new ArrayList();
    public static final Color DEFAULT_SELECTION_COLOR = new Color(Color.YELLOW.getRed(), Color.YELLOW.getGreen(), Color.YELLOW.getBlue(), 127);
    private static final GeometryManager GEOM_MANAGER;
    private static final MapContextManager MAPCONTEXT_MANAGER;
    private static final Logger LOGGER;
    private long scaleToUseWhenEnvelopeCollapse = 10000000L;
    private boolean printGraphicsLayer;
    private static int drawFrameRate;
    public static final double[] CHANGE;
    public static final int EQUALS = 0;
    public static final int DISJOINT = 1;
    public static final int INTERSECTS = 2;
    public static final int TOUCHES = 3;
    public static final int CROSSES = 4;
    public static final int WITHIN = 5;
    public static final int CONTAINS = 6;
    public static final int OVERLAPS = 7;
    protected FLayers layers;
    private static final String DEFAULT_TRACTLAYER = "Default";
    private Map<String, VectorLayer> tracLayers;
    private ViewPort viewPort;
    private List legendListeners = new ArrayList();
    private final ArrayList layerDrawingListeners;
    private final EventBuffer eventBuffer;
    private LayerEventListener layerEventListener = null;
    private final ArrayList layersError;
    private final ArrayList errorListeners;
    private LayerOrderManager orderManager = null;
    public static double ZOOMINFACTOR;
    public static double ZOOMOUTFACTOR;
    private long drawVersion = 0L;
    private long layersVersion = 0L;
    private long viewPortVersion = 0L;
    private long graphicsLayerVersion = 0L;
    private MapContextDrawer mapContextDrawer = null;
    private Class mapContextDrawerClass = null;
    private final Set<FLyrVect> layersToSnap;

    public static int getDrawFrameRate() {
        return drawFrameRate;
    }

    public static void setDrawFrameRate(int theDrawFrameRate) {
        drawFrameRate = theDrawFrameRate;
    }

    public static void addAreaUnit(String name, String abbr, boolean isLinear, double trans2meter) {
        if (!AREANAMES.contains(name)) {
            AREANAMES.add(name);
            String pow = "";
            if (isLinear) {
                pow = String.valueOf('\u00b2');
            }
            AREAABBR.add(abbr + pow);
            AREATRANS2METER.add(trans2meter);
        }
    }

    public static String[] getAreaNames() {
        return AREANAMES.toArray(new String[0]);
    }

    public static String[] getAreaAbbr() {
        return AREAABBR.toArray(new String[0]);
    }

    public static double[] getAreaTrans2Meter() {
        int size = AREATRANS2METER.size();
        double[] trans2meters = new double[size];
        for (int i = 0; i < size; ++i) {
            trans2meters[i] = (Double)AREATRANS2METER.get(i);
        }
        return trans2meters;
    }

    public static String getOfLinear(int i) {
        if (((String)AREAABBR.get(i)).toLowerCase().endsWith(String.valueOf('\u00b2'))) {
            return String.valueOf('\u00b2');
        }
        return "";
    }

    public static void addDistanceUnit(String name, String abbr, double trans2meter) {
        if (!DISTANCENAMES.contains(name)) {
            DISTANCENAMES.add(name);
            DISTANCEABBR.add(abbr);
            DISTANCETRANS2METER.add(trans2meter);
        }
    }

    public static String[] getDistanceNames() {
        return DISTANCENAMES.toArray(new String[0]);
    }

    public String getDistanceName() {
        return (String)DISTANCENAMES.get(this.getViewPort().getDistanceUnits());
    }

    public static String[] getDistanceAbbr() {
        return DISTANCEABBR.toArray(new String[0]);
    }

    public static double[] getDistanceTrans2Meter() {
        int size = DISTANCETRANS2METER.size();
        double[] trans2meters = new double[size];
        for (int i = 0; i < size; ++i) {
            trans2meters[i] = (Double)DISTANCETRANS2METER.get(i);
        }
        return trans2meters;
    }

    public static int getDistancePosition(String s) {
        for (int i = 0; i < DISTANCENAMES.size(); ++i) {
            if (!DISTANCENAMES.get(i).equals(s)) continue;
            return i;
        }
        return 0;
    }

    public Color getSelectionColor() {
        if (this.viewPort == null) {
            return DEFAULT_SELECTION_COLOR;
        }
        return this.viewPort.getSelectionColor();
    }

    public void setSelectionColor(Color selectionColor) {
        if (this.viewPort == null) {
            return;
        }
        this.viewPort.setSelectionColor(selectionColor);
    }

    public MapContext(ViewPort vp) {
        this(new FLayers(), vp);
    }

    public MapContext() {
        this.tracLayers = new LinkedHashMap<String, VectorLayer>();
        this.layerEventListener = new LayerEventListener();
        this.layerDrawingListeners = new ArrayList();
        this.eventBuffer = new EventBuffer();
        this.layersError = new ArrayList();
        this.layersToSnap = new LayersToSnap();
        this.errorListeners = new ArrayList();
    }

    public MapContext(FLayers fLayers, ViewPort vp) {
        this();
        this.layers = fLayers;
        if (this.layers != null) {
            this.layers.setMapContext(this);
            this.layers.addLayerCollectionListener(this.layerEventListener);
            this.layers.addLayerCollectionListener(this.eventBuffer);
        }
        this.setViewPort(vp);
    }

    public synchronized void reportDriverExceptions(String introductoryText, List driverExceptions) {
        for (int i = 0; i < this.errorListeners.size(); ++i) {
            ((ErrorListener)this.errorListeners.get(i)).reportDriverExceptions(introductoryText, driverExceptions);
        }
    }

    public void addLayerListener(LegendListener listener) {
        this.addLegendListener(listener);
    }

    public void addLegendListener(LegendListener listener) {
        if (!this.legendListeners.contains(listener)) {
            this.legendListeners.add(listener);
        }
    }

    public List getLegendListeners() {
        return this.legendListeners;
    }

    public void addLayerDrawingListener(LayerDrawingListener listener) {
        this.layerDrawingListeners.add(listener);
    }

    public List getLayerDrawingListeners() {
        return this.layerDrawingListeners;
    }

    public void removeLayerDrawListener(LayerDrawingListener listener) {
        this.layerDrawingListeners.remove(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners.add(listener);
    }

    public List getErrorListeners() {
        return this.errorListeners;
    }

    public void removeErrorListener(LegendListener listener) {
        this.legendListeners.remove(listener);
    }

    public synchronized void callLegendChanged() {
        for (int i = 0; i < this.legendListeners.size(); ++i) {
            ((LegendListener)this.legendListeners.get(i)).legendChanged(null);
        }
    }

    public synchronized void fireLayerDrawingEvent(LayerDrawEvent e) {
        block6: for (int i = 0; i < this.layerDrawingListeners.size(); ++i) {
            LayerDrawingListener listener = (LayerDrawingListener)this.layerDrawingListeners.get(i);
            switch (e.getEventType()) {
                case 101: {
                    listener.beforeLayerDraw(e);
                    continue block6;
                }
                case 102: {
                    listener.afterLayerDraw(e);
                    continue block6;
                }
                case 103: {
                    listener.beforeGraphicLayerDraw(e);
                    continue block6;
                }
                case 104: {
                    listener.afterLayerGraphicDraw(e);
                }
            }
        }
    }

    public synchronized void callNewErrorEvent(ErrorEvent e) {
        for (int i = 0; i < this.errorListeners.size(); ++i) {
            ((ErrorListener)this.errorListeners.get(i)).errorThrown(e);
        }
        this.errorListeners.clear();
    }

    public void removeLayerListener(LegendListener listener) {
        this.legendListeners.remove(listener);
    }

    public FLayers getLayers() {
        return this.layers;
    }

    public void drawLabels(BufferedImage b) {
    }

    public void invalidate() {
        this.updateDrawVersion();
        this.viewPort.updateDrawVersion();
        FLayer layer = this.layers.getLayersCount() > 0 ? this.layers.getLayer(this.layers.getLayersCount() - 1) : this.getGraphicsLayer();
        LayerPositionEvent event = LayerPositionEvent.createLayerMovedEvent(layer, 0, 0);
        this.eventBuffer.layerMoved(event);
    }

    public void print(Graphics2D g, double scale, PrintAttributes properties) throws ReadException, MapContextException {
        CompatLocator.getGraphicsUtils().setRenderingHintsForPrinting(g);
        Cancellable cancel = new Cancellable(){

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean canceled) {
            }
        };
        MapContextDrawer drawer = this.getMapContextDrawer();
        drawer.setPrintGraphicsLayer(this.isPrintGraphicsLayer());
        drawer.print(this.layers, g, cancel, scale, properties);
    }

    public MapContext createNewFMap(ViewPort vp) {
        MapContext ret = new MapContext(vp);
        ret.layers = this.layers;
        DisposeUtils.bind((Disposable)ret.layers);
        DisposeUtils.bind((Collection)ret.layers);
        return ret;
    }

    public MapContext cloneFMap() {
        ViewPort vp;
        try {
            vp = (ViewPort)this.getViewPort().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        FLayers antLayers = this.getLayers();
        MapContext ret = new MapContext(vp);
        LayerOrderManager lom = this.getOrderManager();
        try {
            lom = (LayerOrderManager)lom.clone();
            ret.setOrderManager(lom);
        }
        catch (CloneNotSupportedException e1) {
            LOGGER.error("While cloning order manager", (Throwable)e1);
        }
        for (int i = 0; i < antLayers.getLayersCount(); ++i) {
            FLayer lyr = antLayers.getLayer(i);
            try {
                FLayer auxLayer = lyr.cloneLayer();
                ret.layers.addLayer(auxLayer);
                auxLayer.dispose();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    public MapContext cloneToDraw() {
        try {
            ViewPort vp = (ViewPort)this.getViewPort().clone();
            MapContext mapContext = new MapContext(this.getLayers(), vp);
            return mapContext;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void addToTrackLayer(FLayer vectorial) {
    }

    public double getScaleView() {
        double dpi = this.getViewPort().getDPI();
        IProjection proj = this.viewPort.getProjection();
        if (this.viewPort.getImageSize() == null) {
            return -1.0;
        }
        if (this.viewPort.getAdjustedEnvelope() == null) {
            return 0.0;
        }
        double[] trans2Meter = MapContext.getDistanceTrans2Meter();
        int mUnits = this.getViewPort().getMapUnits();
        if (proj == null) {
            double w = (double)this.viewPort.getImageSize().width / dpi * 0.0254;
            return (long)(this.viewPort.getAdjustedEnvelope().getLength(0) / w * trans2Meter[mUnits]);
        }
        return proj.getScale(this.viewPort.getAdjustedEnvelope().getMinimum(0) * trans2Meter[mUnits], this.viewPort.getAdjustedEnvelope().getMaximum(0) * trans2Meter[mUnits], (double)this.viewPort.getImageSize().width, dpi);
    }

    public void setScaleView(double scale) {
        double dpi = this.getViewPort().getDPI();
        if (this.viewPort.getImageSize() == null) {
            return;
        }
        IProjection proj = this.viewPort.getProjection();
        if (this.viewPort.getAdjustedExtent() == null) {
            return;
        }
        double[] trans2Meter = MapContext.getDistanceTrans2Meter();
        Envelope env = this.viewPort.getAdjustedExtent();
        Rectangle2D.Double r = new Rectangle2D.Double(env.getMinimum(0), env.getMinimum(1), env.getLength(0), env.getLength(1));
        Rectangle2D rec = proj.getExtent((Rectangle2D)r, scale, (double)this.viewPort.getImageWidth(), (double)this.viewPort.getImageHeight(), 100.0 * MapContext.getDistanceTrans2Meter()[this.getViewPort().getMapUnits()], trans2Meter[this.getViewPort().getDistanceUnits()], dpi);
        try {
            this.getViewPort().setEnvelope(GEOM_MANAGER.createEnvelope(rec.getX(), rec.getY(), rec.getMaxX(), rec.getMaxY(), 0));
        }
        catch (CreateEnvelopeException e) {
            LOGGER.error("Error seting the bounding box");
        }
    }

    public static double getScreenDPI() {
        return CompatLocator.getGraphicsUtils().getScreenDPI();
    }

    public void process(Visitor visitor) {
    }

    public void processSelected(Visitor visitor) {
    }

    public void select(Visitor visitor) {
    }

    public void selectFromSelection() {
    }

    public void createIndex() {
    }

    public IProjection getProjection() {
        ViewPort vp = this.getViewPort();
        if (vp == null) {
            return null;
        }
        return vp.getProjection();
    }

    public void setProjection(IProjection proj) {
        if (this.getViewPort() != null) {
            this.getViewPort().setProjection(proj);
        }
    }

    public void reProject(ICoordTrans arg0) {
    }

    public Envelope getSelectionBounds() throws BaseException {
        SelectedEnvelopeVisitor visitor = new SelectedEnvelopeVisitor();
        this.layers.accept(visitor);
        Envelope env_in_data_crs = visitor.getSelectioEnvelope();
        return env_in_data_crs;
    }

    public void draw(BufferedImage image, Graphics2D g, Cancellable cancel, double scale) throws ReadException, MapContextException {
        if (this.viewPort.getEnvelope() == null) {
            return;
        }
        CompatLocator.getGraphicsUtils().setRenderingHintsForDrawing(g);
        this.getMapContextDrawer().draw(this.layers, image, g, cancel, scale);
    }

    public void drawGraphics(BufferedImage image, Graphics2D g, Cancellable cancel, double scale) throws ReadException {
        try {
            this.draw(image, g, cancel, scale);
        }
        catch (MapContextException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void draw(BufferedImage image, Graphics2D g, double scale) throws ReadException, MapContextException {
        this.draw(image, g, new Cancellable(){

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean canceled) {
            }
        }, scale);
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }

    public void setViewPort(ViewPort viewPort) {
        if (this.viewPort != null) {
            this.viewPort.removeViewPortListener(this.eventBuffer);
        }
        if (this.mapContextDrawer != null) {
            this.mapContextDrawer.setViewPort(viewPort);
        }
        this.viewPort = viewPort;
        if (viewPort != null) {
            viewPort.addViewPortListener(this.eventBuffer);
        }
    }

    public void zoomToEnvelope(Envelope env) {
        if (env == null || env.isEmpty()) {
            return;
        }
        if (env.isCollapsed(0)) {
            this.setScaleView(this.getScaleToUseWhenEnvelopeCollapse());
            Envelope curenv = this.viewPort.getEnvelope();
            double halfWidth = curenv.getLength(0) / 2.0;
            double halfHeight = curenv.getLength(1) / 2.0;
            double centerx = env.getCenter(0);
            double centery = env.getCenter(1);
            Point lowerCorner = GeometryUtils.createPoint((double)(halfWidth + centerx), (double)(halfHeight + centery));
            Point upperCorner = GeometryUtils.createPoint((double)(halfWidth - centerx), (double)(halfHeight - centery));
            env.setLowerCorner(lowerCorner);
            env.setUpperCorner(upperCorner);
        }
        this.viewPort.setEnvelope(env);
    }

    public Envelope getFullEnvelope() throws ReadException {
        Envelope envelope = this.layers.getFullEnvelope();
        for (VectorLayer tracLayer : this.tracLayers.values()) {
            Envelope graphicsEnvelope;
            if (tracLayer == null || (graphicsEnvelope = tracLayer.getFullEnvelope()) == null) continue;
            if (envelope == null) {
                try {
                    envelope = (Envelope)graphicsEnvelope.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
                continue;
            }
            envelope.add(graphicsEnvelope);
        }
        return envelope;
    }

    public boolean addAtomicEventListener(AtomicEventListener listener) {
        return this.eventBuffer.addAtomicEventListener(listener);
    }

    public List getAtomicEventListeners() {
        return this.eventBuffer.getAtomicEventListeners();
    }

    public boolean removeAtomicEventListener(AtomicEventListener listener) {
        return this.eventBuffer.removeAtomicEventListener(listener);
    }

    public void beginAtomicEvent() {
        this.eventBuffer.beginAtomicEvent();
    }

    public void endAtomicEvent() {
        this.eventBuffer.endAtomicEvent();
    }

    public void addAsCollectionListener(FLayers layers2) {
        layers2.addLayerCollectionListener(this.layerEventListener);
        layers2.addLayerCollectionListener(this.eventBuffer);
    }

    public VectorLayer getGraphicsLayer(String name) {
        return this.tracLayers.get(name);
    }

    public Collection<VectorLayer> getGraphicsLayers() {
        return this.tracLayers.values();
    }

    public void setGraphicsLayer(String name, FLyrVect layer) {
        this.tracLayers.put(name, layer);
    }

    public void removeGraphicsLayer(String name) {
        this.tracLayers.remove(name);
    }

    public GraphicLayer getGraphicsLayer() {
        GraphicLayer tracLayer = (GraphicLayer)this.tracLayers.get(DEFAULT_TRACTLAYER);
        if (DisposeUtils.isNullOrDisposed((Disposable)tracLayer) || tracLayer.getDataStore() == null) {
            tracLayer = this.getViewPort() != null ? MapContextLocator.getMapContextManager().createGraphicsLayer(this.getViewPort().getProjection()) : MapContextLocator.getMapContextManager().createGraphicsLayer(null);
            this.tracLayers.put(DEFAULT_TRACTLAYER, tracLayer);
        }
        return tracLayer;
    }

    public void setGraphicsLayer(GraphicLayer graphicLayer) {
        this.tracLayers.put(DEFAULT_TRACTLAYER, graphicLayer);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof MapContext)) {
            return false;
        }
        MapContext map = (MapContext)arg0;
        if (super.equals(arg0)) {
            return true;
        }
        if (this.getLayers() == map.getLayers()) {
            return true;
        }
        boolean isEqual = true;
        if (map.getLayers().getLayersCount() == this.getLayers().getLayersCount()) {
            for (int i = 0; i < this.getLayers().getLayersCount(); ++i) {
                if (this.getLayers().getLayer(i).getName().equals(map.getLayers().getLayer(i).getName())) continue;
                isEqual = false;
            }
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public void addLayerError(String stringProperty) {
        this.layersError.add(stringProperty);
    }

    public ArrayList getLayersError() {
        return this.layersError;
    }

    public void clearErrors() {
        this.layersError.clear();
    }

    public FLayers getNewGroupLayer(FLayers parent) {
        FLayers group1 = new FLayers();
        group1.setMapContext(this);
        group1.setParentLayer(parent);
        return group1;
    }

    public String getClassName() {
        return null;
    }

    public Set<FLyrVect> getLayersToSnap() {
        return this.layersToSnap;
    }

    public void setLayersToSnap(Set<FLyrVect> layers) {
        this.layersToSnap.removeIf(t -> !layers.contains(t));
        this.layersToSnap.addAll(layers);
    }

    public void update(Observable observable, Object notification) {
        FeatureStoreNotification fsNotification;
        String ntype = null;
        if (notification instanceof FeatureStoreNotification && ((ntype = (fsNotification = (FeatureStoreNotification)notification).getType()).equals("Load_Finished") || ntype.equals("after_SelectionChange_DataStore"))) {
            this.getLayers().moveTo(0, 0);
        }
    }

    public long getDrawVersion() {
        if (this.getViewPort().getDrawVersion() > this.viewPortVersion || this.getLayers().getDrawVersion() > this.layersVersion || this.getGraphicsLayer().getDrawVersion() > this.graphicsLayerVersion) {
            this.updateDrawVersion();
        }
        return this.drawVersion;
    }

    protected void updateDrawVersion() {
        this.layersVersion = this.getLayers().getDrawVersion();
        this.viewPortVersion = this.getViewPort().getDrawVersion();
        this.graphicsLayerVersion = this.getGraphicsLayer().getDrawVersion();
        ++this.drawVersion;
    }

    public MapContextDrawer getMapContextDrawer() throws ReadException, MapContextException {
        if (this.mapContextDrawer == null) {
            this.mapContextDrawer = this.mapContextDrawerClass == null ? MAPCONTEXT_MANAGER.createDefaultMapContextDrawerInstance() : MAPCONTEXT_MANAGER.createMapContextDrawerInstance(this.mapContextDrawerClass);
            this.mapContextDrawer.setMapContext(this);
            this.mapContextDrawer.setViewPort(this.viewPort);
        }
        return this.mapContextDrawer;
    }

    public void setMapContextDrawerClass(Class mapContextDrawerClass) throws MapContextException {
        MAPCONTEXT_MANAGER.validateMapContextDrawer(mapContextDrawerClass);
        this.mapContextDrawerClass = mapContextDrawerClass;
        if (this.mapContextDrawer != null) {
            this.mapContextDrawer.dispose();
            this.mapContextDrawer = null;
        }
    }

    public void setMapContextDrawer(MapContextDrawer drawer) {
        if (this.mapContextDrawer != null) {
            this.mapContextDrawer.dispose();
            this.mapContextDrawer = null;
        }
        this.mapContextDrawer = drawer;
        if (this.mapContextDrawer != null) {
            this.mapContextDrawer.setMapContext(this);
            this.mapContextDrawer.setViewPort(this.viewPort);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        ViewPort vp = (ViewPort)state.get("ViewPort");
        this.setViewPort(vp);
        this.layers = (FLayers)state.get("layers");
        this.layers.setName("root layer");
        this.loadLayers(this.layers);
        this.layers.setMapContext(this);
        this.layerEventListener = new LayerEventListener();
        this.layers.addLayerCollectionListener(this.layerEventListener);
        this.layers.addLayerCollectionListener(this.eventBuffer);
        this.layers.setProjection(vp.getProjection());
        this.addSelectionListener(this.layers);
        if (state.hasValue("orderManager")) {
            LayerOrderManager lom = (LayerOrderManager)state.get("orderManager");
            this.setOrderManager(lom);
        }
        DefaultMapContextManager manager = (DefaultMapContextManager)MapContextLocator.getMapContextManager();
        manager.notifyLoadMapContext(this);
    }

    private void loadLayers(FLayers lyrs) {
        int sz = lyrs.getLayersCount();
        for (int i = 0; i < sz; ++i) {
            try {
                lyrs.getLayer(i).load();
                continue;
            }
            catch (LoadLayerException e) {
                LOGGER.error("While loading layer: " + lyrs.getLayer(i).getName());
            }
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("ViewPort", (Persistent)this.viewPort);
        state.set("layers", (Persistent)this.layers);
        state.set("orderManager", (Persistent)this.getOrderManager());
    }

    protected void doDispose() throws BaseException {
        this.dispose(this.layers);
        for (VectorLayer tracLayer : this.tracLayers.values()) {
            this.dispose(tracLayer);
        }
    }

    public void addSelectionListener(FLayer lyr) {
        lyr.addLayerListener(this.eventBuffer);
        if (lyr instanceof Classifiable) {
            Classifiable c = (Classifiable)((Object)lyr);
            c.addLegendListener(this.eventBuffer);
        }
        if (lyr instanceof FLayers) {
            FLayers lyrs = (FLayers)lyr;
            for (int i = 0; i < lyrs.getLayersCount(); ++i) {
                this.addSelectionListener(lyrs.getLayer(i));
            }
        }
        if (lyr instanceof SingleLayer && ((SingleLayer)lyr).getDataStore() != null) {
            ((SingleLayer)lyr).getDataStore().addObserver((Observer)this);
        }
    }

    public void setOrderManager(LayerOrderManager lom) {
        this.orderManager = lom;
    }

    public LayerOrderManager getOrderManager() {
        if (this.orderManager == null) {
            this.orderManager = MapContextLocator.getDefaultOrderManager();
        }
        return this.orderManager;
    }

    public boolean hasVectorLayers() {
        return this.hasVectorLayers(this.getLayers());
    }

    public boolean hasActiveVectorLayers() {
        FLayer[] theLayers;
        for (FLayer layer : theLayers = this.getLayers().getActives()) {
            if (!layer.isAvailable() || !(layer instanceof FLyrVect)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveLayers() {
        Object[] theLayers = this.getLayers().getActives();
        return !ArrayUtils.isEmpty((Object[])theLayers);
    }

    public boolean hasLayers() {
        return !this.getLayers().isEmpty();
    }

    private boolean hasVectorLayers(FLayers layers) {
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            FLayer lyr = layers.getLayer(i);
            if (!(lyr instanceof FLayers ? this.hasVectorLayers((FLayers)lyr) : lyr instanceof FLyrVect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<FLayer> iterator() {
        return this.layers.iterator();
    }

    public Iterator deepiterator() {
        return this.layers.deepiterator();
    }

    public MapTimeContext getTimeContext() {
        TimeSupportManager timeSupportManager = TimeSupportLocator.getManager();
        AbsoluteInterval interval = null;
        ArrayList times = new ArrayList();
        Instant minInstant = null;
        Instant maxInstant = null;
        FLayers theLayers = this.getLayers();
        Iterator<FLayer> iterator = theLayers.deepiterator();
        while (iterator.hasNext()) {
            DataStore dataStore;
            FLayer layer = iterator.next();
            if (!(layer instanceof SingleLayer) || (dataStore = ((SingleLayer)layer).getDataStore()).getInterval() == null) continue;
            Instant startInstant = dataStore.getInterval().getStart();
            Instant endInstant = dataStore.getInterval().getEnd();
            times.addAll(dataStore.getTimes());
            if (minInstant == null || maxInstant == null) {
                minInstant = startInstant;
                maxInstant = endInstant;
                continue;
            }
            if (minInstant.isAfter(startInstant)) {
                minInstant = startInstant;
            }
            if (!maxInstant.isBefore(endInstant)) continue;
            maxInstant = endInstant;
        }
        if (minInstant != null && maxInstant != null) {
            if (minInstant.isAbsolute()) {
                try {
                    interval = timeSupportManager.createAbsoluteInterval((AbsoluteInstant)minInstant, (AbsoluteInstant)maxInstant);
                }
                catch (AbsoluteIntervalTypeNotRegisteredException e) {
                    LOGGER.warn("Error creating the time interval", (Throwable)e);
                }
            } else {
                interval = timeSupportManager.createRelativeInterval(((RelativeInstant)minInstant).toMillis(), ((RelativeInstant)maxInstant).toMillis());
            }
        }
        AbsoluteInterval tmp_interval = interval;
        return new MapTimeContext((Interval)tmp_interval, times){
            final /* synthetic */ Interval val$tmp_interval;
            final /* synthetic */ List val$times;
            {
                this.val$tmp_interval = interval;
                this.val$times = list;
            }

            @Override
            public Interval getInterval() {
                return this.val$tmp_interval;
            }

            @Override
            public List<Instant> getTimes() {
                return this.val$times;
            }
        };
    }

    public long getScaleToUseWhenEnvelopeCollapse() {
        return this.scaleToUseWhenEnvelopeCollapse;
    }

    public void setScaleToUseWhenEnvelopeCollapse(long scale) {
        this.scaleToUseWhenEnvelopeCollapse = scale;
    }

    public void setPrintGraphicsLayer(boolean b) {
        this.printGraphicsLayer = b;
    }

    public boolean isPrintGraphicsLayer() {
        return this.printGraphicsLayer;
    }

    static {
        MapContext.addDistanceUnit("Kilometros", "Km", 1000.0);
        MapContext.addDistanceUnit("Metros", "m", 1.0);
        MapContext.addDistanceUnit("Centimetros", "cm", 0.01);
        MapContext.addDistanceUnit("Milimetros", "mm", 0.001);
        MapContext.addDistanceUnit("Millas", "mi", 1609.344);
        MapContext.addDistanceUnit("Yardas", "Ya", 0.9144);
        MapContext.addDistanceUnit("Pies", "ft", 0.3048);
        MapContext.addDistanceUnit("Pulgadas", "inche", 0.0254);
        MapContext.addDistanceUnit("Grados", "\u00ba", 111319.49079327358);
        MapContext.addAreaUnit("Kilometros", "Km", true, 1000.0);
        MapContext.addAreaUnit("Metros", "m", true, 1.0);
        MapContext.addAreaUnit("Centimetros", "cm", true, 0.01);
        MapContext.addAreaUnit("Milimetros", "mm", true, 0.001);
        MapContext.addAreaUnit("Millas", "mi", true, 1609.344);
        MapContext.addAreaUnit("Yardas", "Ya", true, 0.9144);
        MapContext.addAreaUnit("Pies", "ft", true, 0.3048);
        MapContext.addAreaUnit("Pulgadas", "inche", true, 0.0254);
        MapContext.addAreaUnit("Grados", "\u00ba", true, 111319.49079327358);
        GEOM_MANAGER = GeometryLocator.getGeometryManager();
        MAPCONTEXT_MANAGER = MapContextLocator.getMapContextManager();
        LOGGER = LoggerFactory.getLogger(MapContext.class);
        drawFrameRate = 3;
        CHANGE = new double[]{100000.0, 100.0, 1.0, 0.1, 160934.4, 91.44, 30.48, 2.54, 1113.1949079327358};
        ZOOMINFACTOR = 2.0;
        ZOOMOUTFACTOR = 0.5;
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(MapContext.class, "MapContext", "MapContext Persistence definition", null, null);
            definition.addDynFieldObject("ViewPort").setClassOfValue(ViewPort.class).setMandatory(true);
            definition.addDynFieldObject("layers").setClassOfValue(FLayers.class).setMandatory(true);
            definition.addDynFieldObject("orderManager").setClassOfValue(LayerOrderManager.class).setMandatory(false);
            return Boolean.TRUE;
        }
    }

    public class LayerEventListener
    extends BaseLayerCollectionListener {
        @Override
        public void layerAdded(LayerCollectionEvent e) {
            FLayer lyr = e.getAffectedLayer();
            MapContext.this.addSelectionListener(lyr);
        }

        @Override
        public void layerRemoved(LayerCollectionEvent e) {
            FLayer lyr = e.getAffectedLayer();
            lyr.removeLayerListener(MapContext.this.eventBuffer);
            if (lyr instanceof Classifiable) {
                Classifiable c = (Classifiable)((Object)lyr);
                c.removeLegendListener(MapContext.this.eventBuffer);
            }
            if (lyr instanceof SingleLayer && ((SingleLayer)lyr).getDataStore() != null) {
                ((SingleLayer)lyr).getDataStore().deleteObserver((Observer)MapContext.this);
            }
        }
    }

    public static interface MapTimeContext {
        public Interval getInterval();

        public List<Instant> getTimes();
    }
}

