/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.vectorial;

import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;

public class ContainsEnvelopeEvaluator
extends AbstractEvaluator {
    private final Envelope envelope;
    private final String geomName;
    private final Envelope envelopeTrans;
    private final boolean isDefault;
    private final GeometryExpressionBuilder builder;
    private final IProjection projection;
    private final FeatureAttributeDescriptor fad;

    ContainsEnvelopeEvaluator(Envelope envelope, IProjection envelopeProjection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        this.fad = (FeatureAttributeDescriptor)featureType.get(geomName);
        this.isDefault = featureType.getDefaultGeometryAttributeName().equals(geomName);
        this.projection = envelopeProjection;
        this.builder = builder;
        this.envelope = envelope;
        this.envelopeTrans = envelope;
        this.geomName = geomName;
        this.getFieldsInfo().addMatchFieldValue(geomName, (Object)this.envelopeTrans);
    }

    public Object evaluate(EvaluatorData data) throws EvaluatorException {
        Envelope featureEnvelope;
        if (this.isDefault) {
            featureEnvelope = ((Feature)data.getContextValue("feature")).getDefaultEnvelope();
        } else {
            Geometry geom = (Geometry)data.getDataValue(this.geomName);
            if (geom == null) {
                return false;
            }
            featureEnvelope = geom.getEnvelope();
        }
        return this.envelopeTrans.contains(featureEnvelope);
    }

    public String getName() {
        return "contains in envelope";
    }

    public String getSQL() {
        ExpressionBuilder.Variable column = this.builder.column(this.fad.getName());
        return this.builder.set((ExpressionBuilder.Value)this.builder.and((ExpressionBuilder.Value)this.builder.not_is_null((ExpressionBuilder.Value)column), (ExpressionBuilder.Value)this.builder.ST_Contains((ExpressionBuilder.Value)this.builder.envelope(this.envelope, this.projection), (ExpressionBuilder.Value)this.builder.column(this.fad.getName())))).toString();
    }
}

