/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.vectorial;

import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;

public class CrossEnvelopeEvaluator
extends AbstractEvaluator {
    private final Envelope envelope;
    private final String geomName;
    private final Envelope envelopeTrans;
    private final boolean isDefault;
    private final GeometryExpressionBuilder builder;
    private final IProjection projection;
    private final FeatureAttributeDescriptor fad;

    CrossEnvelopeEvaluator(Envelope envelope, IProjection envelopeProjection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        this.fad = (FeatureAttributeDescriptor)featureType.get(geomName);
        this.isDefault = featureType.getDefaultGeometryAttributeName().equals(geomName);
        this.envelope = envelope;
        this.projection = envelopeProjection;
        this.builder = builder;
        this.envelopeTrans = envelope;
        this.geomName = geomName;
        this.getFieldsInfo().addMatchFieldValue(geomName, (Object)this.envelopeTrans);
    }

    public Object evaluate(EvaluatorData data) throws EvaluatorException {
        if (this.isDefault) {
            Feature feature = (Feature)data.getContextValue("feature");
            Envelope featureEnvelope = feature.getDefaultEnvelope();
            if (featureEnvelope == null) {
                return Boolean.FALSE;
            }
            Boolean r = this.envelopeTrans.intersects(featureEnvelope);
            return r;
        }
        Geometry geom = (Geometry)data.getDataValue(this.geomName);
        if (geom == null) {
            return Boolean.FALSE;
        }
        return this.envelopeTrans.intersects(geom.getEnvelope());
    }

    public String getName() {
        return "contains in envelope";
    }

    public String getSQL() {
        return this.builder.set((ExpressionBuilder.Value)this.builder.ST_Intersects((ExpressionBuilder.Value)this.builder.envelope(this.envelope, this.projection), (ExpressionBuilder.Value)this.builder.ST_Envelope((ExpressionBuilder.Value)this.builder.column(this.fad.getName())))).toString();
    }
}

