/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.vectorial;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.AbstractFeatureStoreTransform;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class ReprojectDefaultGeometry
extends AbstractFeatureStoreTransform {
    private IProjection targetSRS;
    private ICoordTrans ct;
    private IProjection sourceSRS;
    private FeatureType orgDefFeatureType;
    private List orgFeatureTypes;

    public IProjection getTargetSRS() {
        return this.targetSRS;
    }

    public void setTargetSRS(IProjection targetSRS) {
        this.targetSRS = targetSRS;
    }

    public void applyTransform(Feature source, EditableFeature target) throws DataException {
        Iterator iter = target.getType().iterator();
        int defGeomIndex = target.getType().getDefaultGeometryAttributeIndex();
        while (iter.hasNext()) {
            FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)iter.next();
            if (attr.getIndex() == defGeomIndex) {
                Geometry geom = source.getDefaultGeometry();
                geom.reProject(this.ct);
                target.setDefaultGeometry(geom);
                continue;
            }
            target.set(attr.getIndex(), source.get(attr.getName()));
        }
    }

    public void setUp() {
        try {
            FeatureStore store = this.getFeatureStore();
            this.orgDefFeatureType = store.getDefaultFeatureType();
            this.orgFeatureTypes = store.getFeatureTypes();
            EditableFeatureType defFType = this.orgDefFeatureType.getEditable();
            EditableFeatureAttributeDescriptor attr = (EditableFeatureAttributeDescriptor)defFType.getAttributeDescriptor(defFType.getDefaultGeometryAttributeName());
            this.sourceSRS = attr.getSRS();
            this.ct = this.sourceSRS.getCT(this.targetSRS);
            attr.setSRS(this.targetSRS);
            FeatureType defaultType = defFType.getNotEditableCopy();
            ArrayList<FeatureType> types = new ArrayList<FeatureType>();
            for (FeatureType tmp : this.orgFeatureTypes) {
                if (tmp.getId().equals(defaultType.getId())) {
                    types.add(defaultType);
                    continue;
                }
                types.add(tmp);
            }
            this.setFeatureTypes(types, defaultType);
        }
        catch (DataException e) {
            throw new RuntimeException(e);
        }
    }

    public FeatureType getSourceFeatureTypeFrom(FeatureType targetFeatureType) {
        EditableFeatureType result = null;
        for (FeatureType tmp : this.orgFeatureTypes) {
            if (!tmp.getId().equals(targetFeatureType.getId())) continue;
            result = tmp.getEditable();
            Iterator iterAttr = result.iterator();
            while (iterAttr.hasNext()) {
                EditableFeatureAttributeDescriptor attr = (EditableFeatureAttributeDescriptor)iterAttr.next();
                if (targetFeatureType.getIndex(attr.getName()) >= 0) continue;
                iterAttr.remove();
            }
            break block0;
        }
        return result.getNotEditableCopy();
    }

    public boolean isTransformsOriginalValues() {
        return true;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("source_crs", (Object)this.sourceSRS);
        state.set("source_defaultFeatureType", (Object)this.orgDefFeatureType);
        state.set("source_featureTypes", this.orgFeatureTypes);
        state.set("target_crs", (Object)this.targetSRS);
        state.set("coordtrans", (Object)this.ct);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.sourceSRS = (IProjection)state.get("source_crs");
        this.orgDefFeatureType = (FeatureType)state.get("source_defaultFeatureType");
        this.orgFeatureTypes = new ArrayList((List)state.get("source_featureTypes"));
        this.targetSRS = (IProjection)state.get("target_crs");
        this.ct = (ICoordTrans)state.get("coordtrans");
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(ReprojectDefaultGeometry.class, "ReprojectDefaultGeometry", "ReprojectDefaultGeometry Persistence definition", null, null);
            definition.extend(manager.getDefinition(AbstractFeatureStoreTransform.class));
            definition.addDynFieldObject("source_crs").setClassOfValue(IProjection.class).setMandatory(true);
            definition.addDynFieldObject("source_defaultFeatureType").setClassOfValue(FeatureType.class).setMandatory(true);
            definition.addDynFieldList("source_featureTypes").setClassOfItems(FeatureType.class).setMandatory(true);
            definition.addDynFieldObject("target_crs").setClassOfValue(IProjection.class).setMandatory(true);
            definition.addDynFieldObject("coordtrans").setClassOfValue(ICoordTrans.class).setMandatory(true);
            return Boolean.TRUE;
        }
    }
}

