/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.vectorial.impl;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.exceptions.LegendLayerException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialUniqueValueLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphicLayer
extends FLyrVect
implements GraphicLayer {
    private static final String DEFAULT = "default";
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultGraphicLayer.class);
    private IVectorialUniqueValueLegend legend = null;
    private FeatureStore store = null;
    private long ids = 0L;
    private int symbolId = -1;
    private int featureIdIndex;
    private int groupIdIndex;
    private int geomIndex;
    private int idsymIndex;
    private int labelIndex;
    private int tagIndex;
    private int priorityIndex;

    public void initialize(IProjection projection) throws ValidateDataParametersException, DataException, LoadLayerException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        DataManager dataManager = DALLocator.getDataManager();
        this.store = dataManager.createMemoryStore("priority");
        this.store.edit();
        EditableFeatureType editableFeatureType = this.store.getDefaultFeatureType().getEditable();
        editableFeatureType.add("groupId", 8);
        EditableFeatureAttributeDescriptor geometryDescriptor = editableFeatureType.add("geom", 66);
        try {
            geometryDescriptor.setGeometryType(geomManager.getGeometryType(0, 0));
        }
        catch (Exception e) {
            LOGGER.info("Can't create/assign geomery type to feature type of GraphicLayer.", (Throwable)e);
        }
        geometryDescriptor.setSRS(projection);
        editableFeatureType.setDefaultGeometryAttributeName("geom");
        editableFeatureType.add("idsym", 4);
        editableFeatureType.add("label", 8);
        EditableFeatureAttributeDescriptor featureIdDescriptor = editableFeatureType.add("featureId", 5);
        editableFeatureType.add("tag", 64);
        editableFeatureType.add("priority", 4);
        featureIdDescriptor.setIsPrimaryKey(true);
        editableFeatureType.setHasOID(true);
        this.store.update(editableFeatureType);
        this.store.finishEditing();
        FeatureType ftype = this.store.getDefaultFeatureType();
        this.featureIdIndex = ftype.getIndex("featureId");
        this.groupIdIndex = ftype.getIndex("groupId");
        this.geomIndex = ftype.getIndex("geom");
        this.idsymIndex = ftype.getIndex("idsym");
        this.labelIndex = ftype.getIndex("label");
        this.tagIndex = ftype.getIndex("tag");
        this.priorityIndex = ftype.getIndex("priority");
        this.bindToDataStore((DataStore)this.store);
        this.setName("Graphic Layer");
    }

    @Override
    public void addGraphic(String groupId, Geometry geom, int idsym) {
        this.addGraphic(groupId, geom, idsym, null, null, 100);
    }

    @Override
    public void addGraphic(Geometry geom, int idsym) {
        this.addGraphic(DEFAULT, geom, idsym, null, null, 100);
    }

    @Override
    public void addGraphic(Geometry geom, int idsym, String label) {
        this.addGraphic(DEFAULT, geom, idsym, label, null, 100);
    }

    @Override
    public void addGraphic(String groupId, Geometry geom, int idsym, String label) {
        this.addGraphic(groupId, geom, idsym, label, null, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGraphic(String groupId, Geometry geom, int idsym, String label, Object tag, int priority) {
        try {
            this.store.beginComplexNotification();
            FeatureStore featureStore = this.store;
            synchronized (featureStore) {
                ISymbol symbol;
                if (StringUtils.isNotBlank((CharSequence)label) && (symbol = this.getSymbol(idsym)) instanceof ITextSymbol) {
                    ITextSymbol textSymbol = (ITextSymbol)symbol.clone();
                    textSymbol.setText(label);
                    idsym = this.addSymbol(textSymbol);
                }
                if (this.store.isEditing() || this.store.isAppending()) {
                    this.insertGeometry(groupId, geom, idsym, label, tag, priority);
                } else {
                    this.store.edit(2);
                    try {
                        this.insertGeometry(groupId, geom, idsym, label, tag, priority);
                        this.store.finishEditing();
                    }
                    catch (Throwable th) {
                        try {
                            this.store.cancelEditing();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw th;
                    }
                }
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Error adding a geometry to the graphic layer", th);
        }
        finally {
            try {
                this.store.endComplexNotification();
            }
            catch (Exception exception) {}
        }
    }

    private void insertGeometry(String groupId, Geometry geom, int idsym, String label, Object tag, int priority) throws DataException {
        EditableFeature feature = this.store.createNewFeature().getEditable();
        feature.setString(this.groupIdIndex, groupId);
        feature.setGeometry(this.geomIndex, geom);
        feature.setInt(this.idsymIndex, idsym);
        feature.setString(this.labelIndex, label);
        feature.setLong(this.featureIdIndex, this.ids);
        feature.set(this.tagIndex, tag);
        feature.setInt(this.priorityIndex, priority);
        ++this.ids;
        this.store.insert(feature);
    }

    @Override
    public void addGraphics(String groupId, Iterator geoms, int idsym) {
        this.addGraphics(groupId, geoms, idsym, null, null, 100);
    }

    @Override
    public void addGraphics(String groupId, Iterator geoms, int idsym, String label) {
        this.addGraphics(groupId, geoms, idsym, label, null, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGraphics(String groupId, Iterator geoms, int idsym, String label, Object tag, int priority) {
        try {
            FeatureStore featureStore = this.store;
            synchronized (featureStore) {
                if (this.store.isEditing() || this.store.isAppending()) {
                    this.store.disableNotifications();
                    while (geoms.hasNext()) {
                        Geometry geom = (Geometry)geoms.next();
                        this.insertGeometry(groupId, geom, idsym, label, tag, priority);
                    }
                    this.store.enableNotifications();
                } else {
                    this.store.edit(2);
                    try {
                        this.store.disableNotifications();
                        while (geoms.hasNext()) {
                            Geometry geom = (Geometry)geoms.next();
                            this.insertGeometry(groupId, geom, idsym, label, tag, priority);
                        }
                        this.store.enableNotifications();
                        this.store.finishEditing();
                    }
                    catch (Throwable th) {
                        try {
                            this.store.cancelEditing();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw th;
                    }
                }
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Error adding a geometry to the graphic layer", th);
        }
    }

    @Override
    public int addSymbol(ISymbol newSymbol) {
        ++this.symbolId;
        this.legend.addSymbol(this.symbolId, newSymbol);
        return this.symbolId;
    }

    @Override
    public ISymbol getSymbol(int symbolPos) {
        return this.legend.getSymbolByValue(symbolPos);
    }

    @Override
    public int getSymbolId(ISymbol symbol) {
        Object key = this.legend.getSymbolKey(symbol);
        return key == null ? -1 : ((Number)key).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllGraphics() {
        DisposableIterator iterator = null;
        FeatureSet featureSet = null;
        try {
            if (!this.store.isEditing()) {
                this.store.edit();
                featureSet = this.store.getFeatureSet();
                iterator = featureSet.fastIterator();
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    featureSet.delete(feature);
                }
                this.store.finishEditing();
            } else {
                featureSet = this.store.getFeatureSet();
                iterator = featureSet.fastIterator();
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    featureSet.delete(feature);
                }
            }
        }
        catch (DataException e) {
            LOGGER.warn("Error clearing all the geometry of the graphic layer", (Throwable)e);
        }
        finally {
            if (featureSet != null) {
                featureSet.dispose();
            }
            if (iterator != null) {
                iterator.dispose();
            }
        }
    }

    @Override
    public int clearAllSymbols() {
        this.legend.clear();
        this.symbolId = -1;
        return this.symbolId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeGraphics(String groupId) {
        boolean res = false;
        DisposableIterator iterator = null;
        FeatureSet featureSet = null;
        try {
            this.store.beginComplexNotification();
            if (!this.store.isEditing()) {
                this.store.edit();
                featureSet = this.store.getFeatureSet();
                this.store.beginEditingGroup(groupId);
                iterator = featureSet.fastIterator();
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    if (!feature.get("groupId").equals(groupId)) continue;
                    featureSet.delete(feature);
                    res = true;
                }
                this.store.endEditingGroup();
                this.store.finishEditing();
            } else {
                featureSet = this.store.getFeatureSet();
                this.store.beginEditingGroup(groupId);
                iterator = featureSet.fastIterator();
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    if (!feature.get("groupId").equals(groupId)) continue;
                    featureSet.delete(feature);
                    res = true;
                }
                this.store.endEditingGroup();
            }
            this.store.endComplexNotification();
        }
        catch (DataException e) {
            LOGGER.warn("Error clearing all the geometry of the graphic layer", (Throwable)e);
        }
        finally {
            if (featureSet != null) {
                featureSet.dispose();
            }
            if (iterator != null) {
                iterator.dispose();
            }
        }
        return res;
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        if (this.store != null) {
            this.store.dispose();
            this.store = null;
        }
        try {
            throw new RuntimeException();
        }
        catch (Exception ex) {
            LOGGER.debug("GraphicLayer disposed", (Throwable)ex);
            return;
        }
    }

    @Override
    public void setLegend(IVectorLegend legend) throws LegendLayerException {
        if (legend instanceof IVectorialUniqueValueLegend) {
            super.setLegend(legend);
            this.legend = (IVectorialUniqueValueLegend)legend;
            this.legend.setClassifyingFieldNames(new String[]{"idsym"});
            this.legend.setClassifyingFieldTypes(new int[]{4});
        } else if (this.legend != null) {
            LOGGER.warn("The allocation of legend type '" + (legend == null ? "null" : legend.getClass().getName()) + "' is ignored. Required a legend of type IVectorialUniqueValueLegend.");
        }
    }

    @Override
    public Envelope getFullEnvelope() throws ReadException {
        Envelope rAux;
        try {
            rAux = this.getFeatureStore().getEnvelope();
        }
        catch (BaseException e) {
            throw new ReadException(this.getName(), (Throwable)e);
        }
        if (rAux == null) {
            return null;
        }
        ICoordTrans ct = this.getCoordTrans();
        if (ct != null) {
            rAux = rAux.convert(ct);
        }
        return rAux;
    }
}

