/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.rendering.legend;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.IntervalLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LabelLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendClearEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.ValueLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;

public class ZSort
implements LegendContentsChangedListener {
    private int[][] matrix;
    private boolean usingZSort;
    private Map symbols = new HashMap();

    protected ZSort() {
    }

    public ZSort(ILegend legend) {
        this.initialize(legend);
    }

    private void initialize(ILegend legend) {
        ISymbol[] symbols = legend instanceof IClassifiedLegend ? ((IClassifiedLegend)legend).getSymbols() : new ISymbol[]{legend.getDefaultSymbol()};
        this.matrix = new int[symbols.length][];
        for (int i = 0; i < symbols.length; ++i) {
            this.symbols.put(symbols[i], i);
            int rowLength = symbols[i] instanceof IMultiLayerSymbol ? ((IMultiLayerSymbol)symbols[i]).getLayerCount() : 1;
            this.matrix[i] = new int[rowLength];
        }
        legend.addLegendListener(this);
    }

    private void addSymbol(ISymbol sym) {
        if (!this.symbols.containsKey(sym)) {
            int rowLength = sym instanceof IMultiLayerSymbol ? ((IMultiLayerSymbol)sym).getLayerCount() : 1;
            int[][] auxMatrix = new int[this.matrix.length + 1][];
            int newIndex = this.matrix.length;
            for (int i = 0; i < newIndex; ++i) {
                auxMatrix[i] = this.matrix[i];
            }
            int[] row = new int[rowLength];
            for (int i = 0; i < rowLength; ++i) {
                row[i] = 0;
            }
            auxMatrix[newIndex] = row;
            this.matrix = auxMatrix;
            this.symbols.put(sym, newIndex);
        }
    }

    public void legendChanged(LegendChangedEvent e) throws MapContextException {
        this.symbols.clear();
        this.usingZSort = false;
        this.initialize(e.getNewLegend());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public int getLevelCount() {
        int count = -1;
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[i].length; ++j) {
                count = Math.max(count, this.matrix[i][j]);
            }
        }
        return count + 1;
    }

    public void setUsingZSort(boolean usingZSort) {
        this.usingZSort = usingZSort;
    }

    public void setLevels(ISymbol sym, int[] values) {
        this.setLevels((Integer)this.symbols.get(sym), values);
    }

    public void setLevels(int row, int[] values) {
        this.matrix[row] = values;
    }

    public int[] getLevels(ISymbol sym) {
        Integer row = (Integer)this.symbols.get(sym);
        if (row != null) {
            return this.getLevels(row);
        }
        ISymbol[] theSymbols = this.getSymbols();
        for (int i = 0; i < theSymbols.length; ++i) {
            ISymbol auxSymbol = theSymbols[i];
            if (!auxSymbol.equals(sym)) continue;
            return this.getLevels((Integer)this.symbols.get(auxSymbol));
        }
        return null;
    }

    public int[] getLevels(int row) {
        return this.matrix[row];
    }

    public boolean isUsingZSort() {
        return this.usingZSort;
    }

    public ISymbol[] getSymbols() {
        return this.symbols.keySet().toArray(new ISymbol[0]);
    }

    public String[] getDescriptions() {
        ISymbol[] symbols = this.getSymbols();
        String[] descs = new String[symbols.length];
        for (int i = 0; i < descs.length; ++i) {
            descs[i] = symbols[i].getDescription();
        }
        return descs;
    }

    public int getTopLevelIndexAllowed() {
        ISymbol[] symbols = this.getSymbols();
        int count = 0;
        for (int i = 0; i < symbols.length; ++i) {
            if (symbols[i] instanceof IMultiLayerSymbol) {
                IMultiLayerSymbol mSymbol = (IMultiLayerSymbol)symbols[i];
                count = Math.max(count, mSymbol.getLayerCount());
                continue;
            }
            count = Math.max(count, 1);
        }
        return count;
    }

    public String toString() {
        int i;
        String out = "Symbols:\n---------\n\n";
        ISymbol[] syms = this.getSymbols();
        for (i = 0; i < syms.length; ++i) {
            out = out + syms.getClass() + ":\t" + syms[i].getDescription();
        }
        out = out + "\nMatrix:\n--------\n\n";
        out = out + "    \t";
        for (i = 0; i < this.getTopLevelIndexAllowed(); ++i) {
            out = out + "column" + i + "\t\t";
        }
        out = out + "\n";
        for (i = 0; i < this.matrix.length; ++i) {
            out = out + "row " + i + ":\t";
            for (int j = 0; j < this.matrix[i].length; ++j) {
                out = out + this.matrix[i][j] + "\t\t";
            }
            out = out + "\n";
        }
        return out;
    }

    private void replaceSymbol(ISymbol oldSymbol, ISymbol newSymbol) {
        if (oldSymbol == newSymbol) {
            return;
        }
        if (oldSymbol != null) {
            Integer value = (Integer)this.symbols.get(oldSymbol);
            if (value != null) {
                int intValue = value;
                if (newSymbol == null) {
                    this.symbols.remove(oldSymbol);
                    this.matrix[intValue] = new int[1];
                } else {
                    this.symbols.remove(oldSymbol);
                    this.symbols.put(newSymbol, value);
                    int newArrayLength = newSymbol instanceof IMultiLayerSymbol ? ((IMultiLayerSymbol)newSymbol).getLayerCount() : 1;
                    int[] newRow = new int[newArrayLength];
                    if (this.matrix[intValue].length == newArrayLength) {
                        newRow = this.matrix[intValue];
                    } else if (this.matrix[intValue].length < newArrayLength) {
                        int val = 0;
                        for (int i = 0; i < newRow.length; ++i) {
                            if (i < this.matrix[intValue].length) {
                                val = this.matrix[intValue][i];
                            }
                            newRow[i] = val;
                        }
                    } else if (this.matrix[intValue].length > newArrayLength) {
                        for (int i = 0; i < newRow.length; ++i) {
                            newRow[i] = this.matrix[intValue][i];
                        }
                    }
                    this.matrix[intValue] = newRow;
                }
            }
        } else {
            this.addSymbol(newSymbol);
        }
    }

    @Override
    public boolean symbolChanged(SymbolLegendEvent e) {
        this.replaceSymbol(e.getOldSymbol(), e.getNewSymbol());
        return true;
    }

    public boolean classifiedSymbolChange(SymbolLegendEvent e) {
        this.replaceSymbol(e.getOldSymbol(), e.getNewSymbol());
        return true;
    }

    public boolean intervalChange(IntervalLegendEvent e) {
        return false;
    }

    public boolean valueChange(ValueLegendEvent e) {
        System.out.println("log ValueLegendEvent:" + e.getOldValue() + "->" + e.getNewValue());
        return false;
    }

    public boolean labelFieldChange(LabelLegendEvent e) {
        return false;
    }

    @Override
    public void legendCleared(LegendClearEvent event) {
    }
}

