/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.tools.persistence;

import java.awt.Color;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractSinglePersistenceFactory;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class ColorPersistenceFactory
extends AbstractSinglePersistenceFactory {
    static final String FIELD_RED = "red";
    static final String FIELD_GREEN = "green";
    static final String FIELD_BLUE = "blue";
    static final String FIELD_ALPHA = "alpha";
    private static final String DYNCLASS_NAME = "AwtColor";
    private static final String DYNCLASS_DESCRIPTION = "Awt Color";

    public ColorPersistenceFactory() {
        super(Color.class, DYNCLASS_NAME, DYNCLASS_DESCRIPTION, null, null);
        DynStruct definition = this.getDefinition();
        definition.addDynFieldInt(FIELD_RED).setMandatory(true);
        definition.addDynFieldInt(FIELD_GREEN).setMandatory(true);
        definition.addDynFieldInt(FIELD_BLUE).setMandatory(true);
        definition.addDynFieldInt(FIELD_ALPHA).setMandatory(true);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        int red = state.getInt(FIELD_RED);
        int green = state.getInt(FIELD_GREEN);
        int blue = state.getInt(FIELD_BLUE);
        int alpha = state.getInt(FIELD_ALPHA);
        return new Color(red, green, blue, alpha);
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        Color color = (Color)obj;
        state.set(FIELD_RED, color.getRed());
        state.set(FIELD_GREEN, color.getGreen());
        state.set(FIELD_BLUE, color.getBlue());
        state.set(FIELD_ALPHA, color.getAlpha());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            persistenceManager.registerFactory((PersistenceFactory)new ColorPersistenceFactory());
            return Boolean.TRUE;
        }
    }
}

