/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.tools.persistence;

import java.awt.Dimension;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractSinglePersistenceFactory;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class DimensionPersistenceFactory
extends AbstractSinglePersistenceFactory {
    private static final String DYNCLASS_NAME = "AwtDimension";
    private static final String DYNCLASS_DESCRIPTION = "Dimension in AWT";
    public static final String FIELD_HEIGHT = "height";
    public static final String FIELD_WIDTH = "width";

    public DimensionPersistenceFactory() {
        super(Dimension.class, DYNCLASS_NAME, DYNCLASS_DESCRIPTION, null, null);
        DynStruct definition = this.getDefinition();
        definition.addDynFieldInt(FIELD_WIDTH).setMandatory(true);
        definition.addDynFieldInt(FIELD_HEIGHT).setMandatory(true);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        Dimension dimension = new Dimension();
        dimension.width = state.getInt(FIELD_WIDTH);
        dimension.height = state.getInt(FIELD_HEIGHT);
        return dimension;
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        Dimension dim = (Dimension)obj;
        state.set(FIELD_HEIGHT, dim.height);
        state.set(FIELD_WIDTH, dim.width);
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            persistenceManager.registerFactory((PersistenceFactory)new DimensionPersistenceFactory());
            return Boolean.TRUE;
        }
    }
}

