/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.lib.impl;

import java.util.Iterator;
import java.util.Map;
import javax.json.JsonObject;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.gvsig.topology.lib.api.CancelOperationException;
import org.gvsig.topology.lib.api.PerformOperationException;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.lib.api.TopologyServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTopologyDataSet
implements TopologyDataSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTopologyDataSet.class);
    private TopologyServices services;
    private String name;
    private DataStore store;
    private boolean needFinishEditing;
    private String fullName;
    private PropertiesSupportHelper propertiesHelper;
    private MutableObject<SpatialIndex> spatialIndex = null;

    public DefaultTopologyDataSet() {
        this.services = null;
        this.name = null;
        this.store = null;
        this.needFinishEditing = false;
        this.fullName = null;
        this.propertiesHelper = new PropertiesSupportHelper();
    }

    public DefaultTopologyDataSet(TopologyServices services, String name, DataStore store) {
        this.services = services;
        this.name = name;
        this.store = store;
        this.needFinishEditing = false;
        if (store != null) {
            this.fullName = store.getFullName();
        }
    }

    public void restart() {
        this.store = null;
        this.spatialIndex = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultTopologyDataSet)) {
            return false;
        }
        DefaultTopologyDataSet other = (DefaultTopologyDataSet)obj;
        if (this.store != other.store) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getName(), (CharSequence)other.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        try {
            FeatureAttributeDescriptor attr = this.getFeatureStore().getDefaultFeatureType().getDefaultGeometryAttribute();
            String geomType = attr.getGeomType().getName();
            return this.name + " (" + geomType + ")";
        }
        catch (Exception ex) {
            return this.name;
        }
    }

    public void setStore(DataStore store) {
        this.store = store;
    }

    public DataStore getStore() {
        if (this.store == null) {
            this.store = this.services.getFeatureStore((TopologyDataSet)this);
        }
        return this.store;
    }

    public FeatureStore getFeatureStore() {
        if (this.store == null) {
            this.store = this.services.getFeatureStore((TopologyDataSet)this);
        }
        return (FeatureStore)this.store;
    }

    public long getSize() {
        try {
            long size = this.getFeatureStore().getFeatureCount();
            return size;
        }
        catch (DataException ex) {
            return 0L;
        }
    }

    public boolean isThisStore(FeatureStore store) {
        if (store == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.fullName, (CharSequence)store.getFullName());
    }

    public int getGeometryType() {
        try {
            FeatureStore theStore = this.getFeatureStore();
            FeatureType featureType = theStore.getDefaultFeatureType();
            FeatureAttributeDescriptor attr = featureType.getDefaultGeometryAttribute();
            GeometryType geomType = attr.getGeomType();
            return geomType.getType();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public void accept(Visitor visitor) throws VisitCanceledException {
        FeatureStore st = this.getFeatureStore();
        try {
            st.accept(visitor);
        }
        catch (VisitCanceledException ex) {
            throw ex;
        }
        catch (BaseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void edit() throws DataException {
        FeatureStore theStore = this.getFeatureStore();
        if (!theStore.isEditing()) {
            theStore.edit();
            this.needFinishEditing = true;
        }
    }

    public void finishEditing() throws DataException {
        if (this.needFinishEditing) {
            this.getFeatureStore().finishEditing();
        }
    }

    public EditableFeature createNewFeature() throws DataException {
        EditableFeature f = this.getFeatureStore().createNewFeature();
        return f;
    }

    public void perform(String operation, Feature feature) throws DataException {
        this.edit();
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        FeatureStore theStore = this.getFeatureStore();
        EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, operation, null, null, (DataStore)theStore, feature);
        if (notification.isCanceled()) {
            String msg = String.format("Can't insert feature into %1$s, canceled by some observer.", this.getName());
            throw new CancelOperationException(msg);
        }
        String after = null;
        if (operation.equalsIgnoreCase("BEFORE_REMOVE_FEATURE")) {
            theStore.delete(feature);
            after = "AFTER_REMOVE_FEATURE";
        } else {
            if (notification.shouldValidateTheFeature() && !editingNotificationManager.validateFeature(feature)) {
                String msg = String.format("%1$s is not valid", feature.toString());
                throw new PerformOperationException(msg);
            }
            switch (operation) {
                case "BEFORE_UPDATE_FEATURE": {
                    theStore.update((EditableFeature)feature);
                    after = "AFTER_UPDATE_FEATURE";
                    break;
                }
                case "BEFORE_INSERT_FEATURE": {
                    theStore.insert((EditableFeature)feature);
                    after = "AFTER_INSERT_FEATURE";
                }
            }
        }
        editingNotificationManager.notifyObservers((Object)this, after, null, null, (DataStore)theStore, feature);
    }

    public void insert(EditableFeature feature) throws DataException {
        this.perform("BEFORE_INSERT_FEATURE", (Feature)feature);
    }

    public void update(EditableFeature feature) throws DataException {
        this.perform("BEFORE_UPDATE_FEATURE", (Feature)feature);
    }

    public void delete(Feature feature) throws DataException {
        this.perform("BEFORE_REMOVE_FEATURE", feature);
    }

    public void delete(FeatureReference feature) throws DataException {
        this.perform("BEFORE_REMOVE_FEATURE", feature.getFeature());
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder jsonDataSet = Json.createObjectBuilder();
        jsonDataSet.add("name", this.name);
        jsonDataSet.add("fullName", this.fullName);
        return jsonDataSet;
    }

    public void fromJson(JsonObject json) {
        TopologyManager manager = TopologyLocator.getTopologyManager();
        this.name = json.getString("name");
        this.fullName = null;
        if (json.containsKey((Object)"fullName")) {
            this.fullName = json.getString("fullName");
        }
        this.store = null;
        this.needFinishEditing = false;
        this.services = manager.getDefaultServices();
    }

    public Object getProperty(String string) {
        return this.propertiesHelper.getProperty(this.name);
    }

    public void setProperty(String string, Object o) {
        this.propertiesHelper.setProperty(this.name, o);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }

    public SpatialIndex getSpatialIndex() {
        if (this.spatialIndex == null) {
            this.spatialIndex = new MutableObject();
            FeatureStore theStore = this.getFeatureStore();
            FeatureStoreProviderFactory storeFactory = (FeatureStoreProviderFactory)theStore.getProviderFactory();
            if (storeFactory.useLocalIndexesCanImprovePerformance() == 1) {
                try {
                    GeometryManager geomManager = GeometryLocator.getGeometryManager();
                    SpatialIndex geomIndex = geomManager.createSpatialIndex("JTSQuadtree", null);
                    SpatialIndex dataIndex = theStore.wrapSpatialIndex(geomIndex);
                    try {
                        this.store.accept(o -> {
                            Feature f = (Feature)o;
                            Geometry geom = f.getDefaultGeometry();
                            if (geom != null) {
                                dataIndex.insert(geom, (Object)f);
                            }
                        });
                    }
                    catch (VisitCanceledException visitCanceledException) {
                        // empty catch block
                    }
                    this.spatialIndex.setValue((Object)dataIndex);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't create spatial index", (Throwable)ex);
                }
            }
        }
        return (SpatialIndex)this.spatialIndex.getValue();
    }

    public Iterable<FeatureReference> query(Geometry geom) {
        return this.queryReferences(geom);
    }

    public Iterable<FeatureReference> queryReferences(Geometry geom) {
        SpatialIndex index = this.getSpatialIndex();
        if (index == null) {
            try {
                FeatureStore theStore = (FeatureStore)this.getStore();
                Expression expression = ExpressionUtils.createExpression();
                GeometryExpressionBuilder expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                String geomName = theStore.getDefaultFeatureType().getDefaultGeometryAttributeName();
                if (GeometryUtils.isSubtype((int)1, (int)geom.getType())) {
                    expression.setPhrase(expressionBuilder.ifnull((ExpressionBuilder.Value)expressionBuilder.column(geomName), (ExpressionBuilder.Value)expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)expressionBuilder.ST_Intersects((ExpressionBuilder.Value)expressionBuilder.column(geomName), (ExpressionBuilder.Value)expressionBuilder.geometry(geom))).toString());
                } else {
                    expression.setPhrase(expressionBuilder.ifnull((ExpressionBuilder.Value)expressionBuilder.column(geomName), (ExpressionBuilder.Value)expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)expressionBuilder.ST_Overlaps((ExpressionBuilder.Value)expressionBuilder.column(geomName), (ExpressionBuilder.Value)expressionBuilder.envelope(geom.getEnvelope()))).toString());
                }
                FeatureSet set = theStore.getFeatureSet(expression);
                final DisposableIterator it = set.fastIterator();
                return () -> new Iterator<FeatureReference>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public FeatureReference next() {
                        Feature f = (Feature)it.next();
                        return f.getReference();
                    }
                };
            }
            catch (Exception ex) {
                return (Iterable)IteratorUtils.EMPTY_ITERATOR;
            }
        }
        Iterator it = index.query(geom);
        if (it == null) {
            return (Iterable)IteratorUtils.EMPTY_ITERATOR;
        }
        return () -> it;
    }

    public Iterable<Feature> queryFeatures(Geometry geom) {
        SpatialIndex index = this.getSpatialIndex();
        if (index == null) {
            try {
                FeatureStore theStore = (FeatureStore)this.getStore();
                Expression expression = ExpressionUtils.createExpression();
                GeometryExpressionBuilder expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                String geomName = theStore.getDefaultFeatureType().getDefaultGeometryAttributeName();
                if (GeometryUtils.isSubtype((int)1, (int)geom.getType())) {
                    expression.setPhrase(expressionBuilder.ifnull((ExpressionBuilder.Value)expressionBuilder.column(geomName), (ExpressionBuilder.Value)expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)expressionBuilder.ST_Intersects((ExpressionBuilder.Value)expressionBuilder.column(geomName), (ExpressionBuilder.Value)expressionBuilder.geometry(geom))).toString());
                } else {
                    expression.setPhrase(expressionBuilder.ifnull((ExpressionBuilder.Value)expressionBuilder.column(geomName), (ExpressionBuilder.Value)expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)expressionBuilder.ST_Overlaps((ExpressionBuilder.Value)expressionBuilder.column(geomName), (ExpressionBuilder.Value)expressionBuilder.envelope(geom.getEnvelope()))).toString());
                }
                FeatureSet set = theStore.getFeatureSet(expression);
                DisposableIterator it = set.fastIterator();
                return () -> it;
            }
            catch (Exception ex) {
                return (Iterable)IteratorUtils.EMPTY_ITERATOR;
            }
        }
        final Iterator it = index.query(geom);
        if (it == null) {
            return (Iterable)IteratorUtils.EMPTY_ITERATOR;
        }
        return () -> new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Feature next() {
                FeatureReference ref = (FeatureReference)it.next();
                try {
                    return ref.getFeature();
                }
                catch (DataException ex) {
                    return null;
                }
            }
        };
    }

    public Feature findFirst(Expression filter) {
        try {
            return this.getFeatureStore().findFirst(filter);
        }
        catch (Exception ex) {
            return null;
        }
    }

    void setTopologyServices(TopologyServices services) {
        this.services = services;
        this.restart();
    }
}

