/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.lib.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.api.TopologyServices;
import org.gvsig.topology.lib.impl.DefaultTopologyDataSet;
import org.gvsig.topology.lib.impl.DefaultTopologyPlan;

public class DefaultTopologyManager
implements TopologyManager {
    private final Map<String, TopologyRuleFactory> factories = new HashMap<String, TopologyRuleFactory>();
    private TopologyServices services;

    public TopologyPlan createTopologyPlan() {
        DefaultTopologyPlan plan = new DefaultTopologyPlan(this, this.services);
        return plan;
    }

    public List<TopologyRuleFactory> getRuleFactories() {
        ArrayList<TopologyRuleFactory> l = new ArrayList<TopologyRuleFactory>(this.factories.values());
        return Collections.unmodifiableList(l);
    }

    public List<TopologyRuleFactory> getRuleFactories(TopologyDataSet dataSet) {
        ArrayList<TopologyRuleFactory> f = new ArrayList<TopologyRuleFactory>();
        for (TopologyRuleFactory factory : this.factories.values()) {
            if (!factory.canApplyToDataSet(dataSet)) continue;
            f.add(factory);
        }
        return f;
    }

    public TopologyRuleFactory getRulefactory(String id) {
        if (id == null) {
            return null;
        }
        TopologyRuleFactory factory = this.factories.get(id.toLowerCase());
        return factory;
    }

    public void addRuleFactories(TopologyRuleFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Invalid null value.");
        }
        this.factories.put(factory.getId().toLowerCase(), factory);
    }

    public TopologyDataSet createDataSet(String name, DataStore store) {
        DefaultTopologyDataSet dataSet = new DefaultTopologyDataSet(this.services, name, store);
        return dataSet;
    }

    public void setDefaultServices(TopologyServices services) {
        this.services = services;
    }

    public TopologyServices getDefaultServices() {
        return this.services;
    }
}

