/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.rule;

import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.AbstractTopologyRule;

public class PolygonContainsPolygonRule
extends AbstractTopologyRule {
    private String geomName;
    private Expression expression = null;
    private GeometryExpressionBuilder expressionBuilder = null;

    public PolygonContainsPolygonRule() {
    }

    public PolygonContainsPolygonRule(TopologyRuleFactory factory, double tolerance, String dataSet1, String dataSet2) {
        super(factory, tolerance, dataSet1, dataSet2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature1) throws Exception {
        Object set = null;
        try {
            TopologyDataSet theDataSet;
            FeatureStore store2 = this.getDataSet2().getFeatureStore();
            if (this.expression == null) {
                this.expression = ExpressionUtils.createExpression();
                this.expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                this.geomName = store2.getDefaultFeatureType().getDefaultGeometryAttributeName();
            }
            double theTolerance = this.getTolerance();
            Geometry polygon = feature1.getDefaultGeometry();
            if (theTolerance > 0.0) {
                polygon = polygon.buffer(theTolerance);
            }
            if ((theDataSet = this.getDataSet2()).getSpatialIndex() != null) {
                boolean contains = false;
                for (FeatureReference featureReference : theDataSet.query(polygon)) {
                    Feature feature2 = featureReference.getFeature();
                    Geometry otherPolygon = feature2.getDefaultGeometry();
                    if (otherPolygon == null || !polygon.contains(otherPolygon)) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), polygon, polygon, feature1.getReference(), null, false, i18n.getTranslation("_The_polygon_does_not_contain_any_polygons"));
                }
            } else {
                this.expression.setPhrase(this.expressionBuilder.ifnull((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)this.expressionBuilder.ST_Contains((ExpressionBuilder.Value)this.expressionBuilder.geometry(polygon), (ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName))).toString());
                if (theDataSet.findFirst(this.expression) == null) {
                    polygon = feature1.getDefaultGeometry();
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), polygon, polygon, feature1.getReference(), null, false, i18n.getTranslation("_The_polygon_does_not_contain_any_polygons"));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check feature.", (Throwable)ex);
            this.addCodeException(report, feature1, ex);
        }
        finally {
            if (set != null) {
                set.dispose();
            }
        }
    }
}

