/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.rule;

import org.gvsig.json.Json;
import org.gvsig.tools.util.ListBuilder;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.AbstractTopologyRuleFactory;
import org.gvsig.topology.rule.PolygonMustNotOverlapPolygonRule;

public class PolygonMustNotOverlapPolygonRuleFactory
extends AbstractTopologyRuleFactory {
    public static final String NAME = "PolygonMustNotOverlapPolygon";

    public PolygonMustNotOverlapPolygonRuleFactory() {
        super(NAME, "Must Not Overlap", "Requires that the interior of polygons in the dataset not overlap. The polygons can share edges or vertices. This rule is used when an area cannot belong to two or more polygons. It is useful for modeling administrative boundaries, such as ZIP Codes or voting districts, and mutually exclusive area classifications, such as land cover or landform type.", new ListBuilder().add((Object)3).add((Object)9).asList());
    }

    public TopologyRule createRule(String dataSet1, String dataSet2, double tolerance) {
        PolygonMustNotOverlapPolygonRule rule = new PolygonMustNotOverlapPolygonRule((TopologyRuleFactory)this, tolerance, dataSet1);
        return rule;
    }

    public static void selfRegister() {
        try {
            TopologyManager manager = TopologyLocator.getTopologyManager();
            manager.addRuleFactories((TopologyRuleFactory)new PolygonMustNotOverlapPolygonRuleFactory());
            Json.registerSerializer(PolygonMustNotOverlapPolygonRule.class);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't register topology rule from " + PolygonMustNotOverlapPolygonRuleFactory.class.getSimpleName(), (Throwable)ex);
        }
    }
}

