/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.AlphaDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.GraphicsStateCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InkAnnotation
extends MarkupAnnotation {
    private static final Logger logger = Logger.getLogger(InkAnnotation.class.toString());
    public static final Name INK_LIST_KEY = new Name("InkList");
    protected Shape inkPath;

    public InkAnnotation(Library l, HashMap h) {
        super(l, h);
    }

    @Override
    public void init() throws InterruptedException {
        super.init();
        List inkLists = this.library.getArray(this.entries, INK_LIST_KEY);
        GeneralPath inkPaths = new GeneralPath();
        if (inkLists != null) {
            this.inkPath = new GeneralPath();
            for (List inkList : inkLists) {
                GeneralPath inkPath = null;
                int max = inkList.size() - 1;
                for (int i = 0; i < max; i += 2) {
                    if (inkPath == null) {
                        inkPath = new GeneralPath();
                        inkPath.moveTo(((Number)inkList.get(i)).floatValue(), ((Number)inkList.get(i + 1)).floatValue());
                        continue;
                    }
                    inkPath.lineTo(((Number)inkList.get(i)).floatValue(), ((Number)inkList.get(i + 1)).floatValue());
                }
                inkPaths.append(inkPath, false);
            }
        }
        this.inkPath = inkPaths;
        if (!this.hasAppearanceStream() && this.inkPath != null) {
            Object tmp = this.getObject(RECTANGLE_KEY);
            RectangularShape rectangle = null;
            if (tmp instanceof List) {
                rectangle = this.library.getRectangle(this.entries, RECTANGLE_KEY);
            }
            if (rectangle != null) {
                this.setBBox(rectangle.getBounds());
            }
            this.resetAppearanceStream(new AffineTransform());
        }
        this.resetNullAppearanceStream();
    }

    private List<List<Float>> convertPathToArray(Shape inkPath) {
        ArrayList<List<Float>> inkLists = new ArrayList<List<Float>>();
        ArrayList<Float> segment = null;
        if (inkPath != null) {
            PathIterator pathIterator = inkPath.getPathIterator(null);
            float[] inkSegment = new float[6];
            while (!pathIterator.isDone()) {
                int segmentType = pathIterator.currentSegment(inkSegment);
                if (segmentType == 0) {
                    segment = new ArrayList<Float>();
                    segment.add(Float.valueOf(inkSegment[0]));
                    segment.add(Float.valueOf(inkSegment[1]));
                    inkLists.add(segment);
                } else if (segmentType == 1) {
                    segment.add(Float.valueOf(inkSegment[0]));
                    segment.add(Float.valueOf(inkSegment[1]));
                }
                pathIterator.next();
            }
        }
        return inkLists;
    }

    public static InkAnnotation getInstance(Library library, Rectangle rect) {
        StateManager stateManager = library.getStateManager();
        HashMap<Name, Object> entries = new HashMap<Name, Object>();
        entries.put(Dictionary.TYPE_KEY, Annotation.TYPE_VALUE);
        entries.put(Dictionary.SUBTYPE_KEY, Annotation.SUBTYPE_INK);
        if (rect != null) {
            entries.put(Annotation.RECTANGLE_KEY, PRectangle.getPRectangleVector(rect));
        } else {
            entries.put(Annotation.RECTANGLE_KEY, new Rectangle(10, 10, 50, 100));
        }
        InkAnnotation inkAnnotation = null;
        try {
            inkAnnotation = new InkAnnotation(library, entries);
            inkAnnotation.setPObjectReference(stateManager.getNewReferencNumber());
            inkAnnotation.init();
            inkAnnotation.setNew(true);
            inkAnnotation.setFlag(64, false);
            inkAnnotation.setFlag(16, false);
            inkAnnotation.setFlag(8, false);
            inkAnnotation.setFlag(4, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.fine("Ink annotation instance creation was interrupted");
        }
        return inkAnnotation;
    }

    @Override
    public void resetAppearanceStream(double dx, double dy, AffineTransform pageSpace) {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        appearanceState.setMatrix(new AffineTransform());
        appearanceState.setShapes(new Shapes());
        AffineTransform af = new AffineTransform();
        af.setToTranslation(dx * pageSpace.getScaleX(), -dy * pageSpace.getScaleY());
        this.inkPath = af.createTransformedShape(this.inkPath);
        this.entries.put(INK_LIST_KEY, this.convertPathToArray(this.inkPath));
        Rectangle2D bbox = appearanceState.getBbox();
        bbox.setRect(this.userSpaceRectangle.x, this.userSpaceRectangle.y, this.userSpaceRectangle.width, this.userSpaceRectangle.height);
        this.setUserSpaceRectangle(this.userSpaceRectangle);
        this.setModifiedDate(PDate.formatDateTime(new Date()));
        if (this.borderStyle.getStrokeWidth() == 0.0f) {
            this.borderStyle.setStrokeWidth(1.0f);
        }
        BasicStroke stroke = this.getBorderStyleStroke();
        Shapes shapes = appearanceState.getShapes();
        shapes.add(new GraphicsStateCmd(EXT_GSTATE_NAME));
        shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, this.opacity)));
        shapes.add(new StrokeDrawCmd(stroke));
        shapes.add(new ColorDrawCmd(this.color));
        shapes.add(new ShapeDrawCmd(this.inkPath));
        shapes.add(new DrawDrawCmd());
        shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, 1.0f)));
        this.entries.remove(APPEARANCE_STREAM_KEY);
        StateManager stateManager = this.library.getStateManager();
        stateManager.addChange(new PObject(this, this.getPObjectReference()));
    }

    public Shape getInkPath() {
        return this.inkPath;
    }

    public void setInkPath(Shape inkPath) {
        this.inkPath = inkPath;
    }
}

