/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.demo;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.BrowserConfig;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.render.SVGRenderer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImageRenderer {
    public static final short TYPE_PNG = 0;
    public static final short TYPE_SVG = 1;
    private boolean loadImages = true;
    private boolean loadBackgroundImages = true;

    public void setLoadImages(boolean content, boolean background) {
        this.loadImages = content;
        this.loadBackgroundImages = background;
    }

    public boolean renderURL(String urlstring, OutputStream out, short type) throws IOException, SAXException {
        if (!(urlstring.startsWith("http:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:"))) {
            urlstring = "http://" + urlstring;
        }
        DefaultDocumentSource docSource = new DefaultDocumentSource(urlstring);
        DefaultDOMSource parser = new DefaultDOMSource(docSource);
        Document doc = ((DOMSource)parser).parse();
        DOMAnalyzer da = new DOMAnalyzer(doc, ((DocumentSource)docSource).getURL());
        da.attributesToStyles();
        da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.getStyleSheets();
        if (type == 0) {
            BrowserCanvas contentCanvas = new BrowserCanvas(da.getRoot(), da, ((DocumentSource)docSource).getURL());
            contentCanvas.getConfig().setLoadImages(this.loadImages);
            contentCanvas.getConfig().setLoadBackgroundImages(this.loadBackgroundImages);
            contentCanvas.createLayout(new Dimension(1200, 600));
            ImageIO.write((RenderedImage)contentCanvas.getImage(), "png", out);
        } else if (type == 1) {
            BrowserCanvas contentCanvas = new BrowserCanvas(da.getRoot(), da, ((DocumentSource)docSource).getURL());
            contentCanvas.getConfig().setLoadImages(this.loadImages);
            contentCanvas.getConfig().setLoadBackgroundImages(this.loadBackgroundImages);
            this.setDefaultFonts(contentCanvas.getConfig());
            contentCanvas.createLayout(new Dimension(1200, 600));
            OutputStreamWriter w = new OutputStreamWriter(out, "utf-8");
            this.writeSVG(contentCanvas.getViewport(), w);
            ((Writer)w).close();
        }
        ((DocumentSource)docSource).close();
        return true;
    }

    protected void setDefaultFonts(BrowserConfig config) {
        config.setDefaultFont("Serif", "Times New Roman");
        config.setDefaultFont("SansSerif", "Arial");
        config.setDefaultFont("Monospaced", "Courier New");
    }

    protected void writeSVG(Viewport vp, Writer out) throws IOException {
        int w = vp.getClippedContentBounds().width;
        int h = vp.getClippedContentBounds().height;
        SVGRenderer render = new SVGRenderer(w, h, out);
        vp.draw(render);
        render.close();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: ImageRenderer <url> <output_file> <format>");
            System.err.println();
            System.err.println("Renders a document at the specified URL and stores the document image");
            System.err.println("to the specified file.");
            System.err.println("Supported formats:");
            System.err.println("png: a Portable Network Graphics file (bitmap image)");
            System.err.println("svg: a SVG file (vector image)");
            System.exit(0);
        }
        try {
            short type = -1;
            if (args[2].equalsIgnoreCase("png")) {
                type = 0;
            } else if (args[2].equalsIgnoreCase("svg")) {
                type = 1;
            } else {
                System.err.println("Error: unknown format");
                System.exit(0);
            }
            FileOutputStream os = new FileOutputStream(args[1]);
            ImageRenderer r = new ImageRenderer();
            r.renderURL(args[0], os, type);
            os.close();
            System.err.println("Done.");
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}

