/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.io;

import java.net.URI;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.AbstractRasterFileDataParameters;
import org.gvsig.raster.tilecache.io.TileProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;

public class TileDataParametersImpl
extends AbstractRasterFileDataParameters
implements TileDataParameters {
    public static final String FIELD_PARAMETERS = "parameters";
    public static final String FIELD_SECONDLEVEL = "secondlevel";
    public static final String FIELD_NAME = "name";
    private static final String FIELD_DELETECACHE = "deletecache";
    private DelegatedDynObject delegatedDynObject = null;
    private TileServer tileServer = null;

    public TileDataParametersImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(TileDataParametersImpl.registerDynClass());
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("TileDataParameters_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(TileDataParametersImpl.class, "TileDataParameters_Persistent", "TileDataParameters Persistency", null, null);
        }
        AbstractRasterDataParameters.registerDynClass((DynStruct)definition);
        definition.addDynFieldObject(FIELD_PARAMETERS).setDescription("Provider").setClassOfValue(RasterDataParameters.class).setMandatory(true);
        definition.addDynFieldBoolean(FIELD_SECONDLEVEL).setDescription("SecondLevelProvider").setMandatory(false);
        definition.addDynFieldString(FIELD_NAME).setDescription("Name").setMandatory(false);
        definition.addDynFieldBoolean(FIELD_DELETECACHE).setDescription("Flag to delete cache the next request").setMandatory(false);
        return definition;
    }

    public void setDataParameters(DataParameters params) {
        this.setDynValue(FIELD_PARAMETERS, params);
    }

    public DataParameters getDataParameters() {
        return (DataParameters)this.getDynValue(FIELD_PARAMETERS);
    }

    public void setTileServer(TileServer tileServer) {
        this.tileServer = tileServer;
    }

    public TileServer getTileServer() {
        return this.tileServer;
    }

    public boolean isSecondLevelCache() {
        Object obj = this.getDynValue(FIELD_SECONDLEVEL);
        if (obj != null && obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public void setSecondLevelCache(boolean secondLevel) {
        this.setDynValue(FIELD_SECONDLEVEL, new Boolean(secondLevel));
    }

    public String getName() {
        DataParameters p = this.getDataParameters();
        if (p != null) {
            if (p instanceof FilesystemStoreParameters) {
                return ((FilesystemStoreParameters)p).getFile().getAbsolutePath();
            }
            return ((RasterDataParameters)p).getURI().getPath();
        }
        return null;
    }

    public URI getURI() {
        DataParameters p;
        if (this.getDynValue("uri") == null && (p = this.getDataParameters()) != null) {
            if (p instanceof FilesystemStoreParameters) {
                return ((FilesystemStoreParameters)p).getFile().toURI();
            }
            return ((RasterDataParameters)p).getURI();
        }
        return (URI)this.getDynValue("uri");
    }

    public String getDataStoreName() {
        return TileProvider.NAME;
    }

    public String getDescription() {
        return TileProvider.DESCRIPTION;
    }

    public String getExplorerName() {
        return "TileServerExplorer";
    }

    public boolean isValid() {
        return this.getDataParameters() != null;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    public void deleteCache(boolean deleteCache) {
        this.setDynValue(FIELD_DELETECACHE, new Boolean(deleteCache));
    }

    public boolean isDeletingCache() {
        Boolean b = (Boolean)this.getDynValue(FIELD_DELETECACHE);
        if (b != null) {
            return (Boolean)this.getDynValue(FIELD_DELETECACHE);
        }
        return false;
    }

    public boolean isSourceTiled() {
        return true;
    }
}

