/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.io.tff;

import java.awt.geom.Point2D;
import java.io.File;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.TiledRasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.tilecache.io.tff.TileFileFormatDataParameters;
import org.gvsig.raster.tilecache.io.tff.TileFileFormatFilesystemServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileFileFormatProvider
extends AbstractRasterProvider
implements TiledRasterProvider {
    public static String NAME = "TileFileFormat Store";
    public static String DESCRIPTION = "Tile file format Source";
    public static final String METADATA_DEFINITION_NAME = "TileFileFormatStore";
    private static final Logger logger = LoggerFactory.getLogger(TileFileFormatProvider.class);
    protected static String[] formatList = null;
    private boolean open = false;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        TileFileFormatProvider.registerFormats();
        ExtensionPoint point = extensionPoints.get("DefaultRasterProvider");
        point.append("reader", NAME, TileFileFormatProvider.class);
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, TileFileFormatProvider.class, TileFileFormatDataParameters.class);
        }
        if (DALFileLocator.getFilesystemServerExplorerManager() != null) {
            DALFileLocator.getFilesystemServerExplorerManager().registerProvider(NAME, DESCRIPTION, TileFileFormatFilesystemServerExplorer.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    private static void registerFormats() {
        formatList = new String[]{"tff"};
        for (int i = 0; i < formatList.length; ++i) {
            RasterLocator.getManager().getProviderServices().addFormat(formatList[i], TileFileFormatProvider.class);
        }
    }

    public String[] getFormatList() {
        return formatList;
    }

    public boolean isExtensionSupported(String ext) {
        if (ext.indexOf(".") != -1) {
            ext = ext.substring(ext.lastIndexOf(".") + 1, ext.length());
        }
        for (int i = 0; i < formatList.length; ++i) {
            if (formatList[i].compareTo(ext) != 0) continue;
            return true;
        }
        return false;
    }

    public TileFileFormatProvider() throws NotSupportedExtensionException {
    }

    public TileFileFormatProvider(TileFileFormatDataParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        super((AbstractRasterDataParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        try {
            this.init(params, storeServices);
        }
        catch (OpenException e) {
            throw new InitializeException("Error open the source", (Throwable)e);
        }
        catch (NotSupportedExtensionException e) {
            throw new InitializeException("Not supported extension", (Throwable)e);
        }
    }

    public void init(TileFileFormatDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException, OpenException {
        this.openFromTff();
        this.uri = this.getParameters().getURI();
        super.init();
        try {
            this.loadFromRmf(this.getRmfBlocksManager());
        }
        catch (ParsingException e) {
            logger.debug("Problems reading from RMF", (Throwable)e);
        }
        this.open = true;
    }

    private void openFromTff() throws OpenException {
    }

    public TileFileFormatDataParameters getParameters() {
        try {
            return (TileFileFormatDataParameters)this.parameters;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public int getBlockSize() {
        return 0;
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return null;
    }

    public double getHeight() {
        return 0.0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public Extent getView() {
        return null;
    }

    public double getWidth() {
        return 0.0;
    }

    public boolean isOverviewsSupported() {
        return false;
    }

    public RasterProvider load() {
        return null;
    }

    public void setView(Extent e) {
    }

    public Extent getCoordsInLevel(Point2D viewCenter, int level, int w, int h) {
        return null;
    }

    public Extent getCoordsInTheNearestLevel(Extent extent, int w, int h) {
        return null;
    }

    public RasterProvider getInternalProvider() {
        return null;
    }

    public int getNearestLevel(double pixelSize) {
        return 0;
    }

    public Tile getTile(SpiRasterQuery q) throws TileGettingException {
        return null;
    }

    public int getZoomLevels() {
        return 0;
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public TileServer getTileServer() {
        return null;
    }

    public boolean isOpen() {
        return this.open;
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        return null;
    }

    public void setStatus(RasterProvider provider) {
    }

    public String getProviderName() {
        return NAME;
    }

    public void loadBuffer(SpiRasterQuery query) throws ProcessInterruptedException, RasterDriverException {
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }
}

